/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.spatialite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jgrasstools.gears.spatialite.ForeignKey;
import org.jgrasstools.gears.spatialite.QueryResult;
import org.jgrasstools.gears.spatialite.SpatialiteGeometryColumns;
import org.jgrasstools.gears.spatialite.SpatialiteGeometryType;
import org.jgrasstools.gears.spatialite.SpatialiteTableNames;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.time.EggClock;
import org.sqlite.SQLiteConfig;

public class SpatialiteDb
implements AutoCloseable {
    public static final String PK_UID = "PK_UID";
    public static final String defaultGeomFieldName = "the_geom";
    protected Connection conn = null;
    private String dbPath;

    public void open(String dbPath) throws SQLException {
        this.dbPath = dbPath;
        File dbFile = new File(dbPath);
        if (dbFile.exists()) {
            System.out.println("Database exists");
        }
        SQLiteConfig config = new SQLiteConfig();
        config.enableLoadExtension(true);
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + dbPath, config.toProperties());
        try (Statement stmt = this.conn.createStatement();){
            stmt.setQueryTimeout(30);
            stmt.execute("SELECT load_extension('mod_spatialite')");
        }
    }

    public String getDatabasePath() {
        return this.dbPath;
    }

    public void initSpatialMetadata(String options) throws SQLException {
        if (options == null) {
            options = "";
        }
        String sql = "SELECT InitSpatialMetadata(" + options + ")";
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql);
        }
    }

    public String[] getDbInfo() throws SQLException {
        String sql = "SELECT sqlite_version(), spatialite_version(), spatialite_target_cpu()";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            String[] info = new String[3];
            while (rs.next()) {
                info[0] = rs.getString(1);
                info[1] = rs.getString(2);
                info[2] = rs.getString(3);
            }
            String[] stringArray = info;
            return stringArray;
        }
    }

    public void createTable(String tableName, String ... fieldData) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(tableName).append("(");
        for (int i = 0; i < fieldData.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(fieldData[i]);
        }
        sb.append(")");
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sb.toString());
        }
    }

    public void deleteGeoTable(String tableName) throws SQLException {
        String sql = "SELECT DropGeoTable('" + tableName + "');";
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql);
        }
    }

    public void createIndex(String tableName, String column, boolean isUnique) throws SQLException {
        String sql = this.getIndexSql(tableName, column, isUnique);
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    public String getIndexSql(String tableName, String column, boolean isUnique) {
        String unique = "UNIQUE ";
        if (!isUnique) {
            unique = "";
        }
        String indexName = tableName + "__" + column + "_idx";
        String sql = "CREATE " + unique + "INDEX " + indexName + " on " + tableName + "(" + column + ");";
        return sql;
    }

    public void addGeometryXYColumnAndIndex(String tableName, String geomType, String epsg) throws SQLException {
        String epsgStr = "4326";
        if (epsg != null) {
            epsgStr = epsg;
        }
        String geomTypeStr = "LINESTRING";
        if (geomType != null) {
            geomTypeStr = geomType;
        }
        try (Statement stmt = this.conn.createStatement();){
            String sql = "SELECT AddGeometryColumn('" + tableName + "','" + defaultGeomFieldName + "', " + epsgStr + ", '" + geomTypeStr + "', 'XY')";
            stmt.execute(sql);
            sql = "SELECT CreateSpatialIndex('" + tableName + "', '" + defaultGeomFieldName + "');";
            stmt.execute(sql);
        }
    }

    public void insertGeometry(String tableName, Geometry geometry, String epsg) throws SQLException {
        String epsgStr = "4326";
        if (epsg == null) {
            epsgStr = epsg;
        }
        SpatialiteGeometryColumns gc = this.getGeometryColumnsForTable(tableName);
        String sql = "INSERT INTO " + tableName + " (" + gc.f_geometry_column + ") VALUES (GeomFromText(?, " + epsgStr + "))";
        try (PreparedStatement pStmt = this.conn.prepareStatement(sql);){
            pStmt.setString(1, geometry.toText());
            pStmt.executeUpdate();
        }
    }

    public List<String> getTables(boolean doOrder) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String orderBy = " ORDER BY name";
        if (!doOrder) {
            orderBy = "";
        }
        String sql = "SELECT name FROM sqlite_master WHERE type='table' or type='view'" + orderBy;
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String tabelName = rs.getString(1);
                tableNames.add(tabelName);
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
    }

    public HashMap<String, List<String>> getTablesMap(boolean doOrder) throws SQLException {
        List<String> tableNames = this.getTables(doOrder);
        LinkedHashMap<String, List<String>> tablesMap = SpatialiteTableNames.getTablesSorted(tableNames, doOrder);
        return tablesMap;
    }

    public boolean hasTable(String tableName) throws SQLException {
        String sql = "SELECT name FROM sqlite_master WHERE type='table'";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString(1);
                if (!name.equals(tableName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<String[]> getTableColumns(String tableName) throws SQLException {
        ArrayList<String[]> columnNames = new ArrayList<String[]>();
        String sql = "PRAGMA table_info(" + tableName + ")";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int nameIndex = -1;
            int typeIndex = -1;
            int pkIndex = -1;
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                if (columnName.equals("name")) {
                    nameIndex = i;
                    continue;
                }
                if (columnName.equals("type")) {
                    typeIndex = i;
                    continue;
                }
                if (!columnName.equals("pk")) continue;
                pkIndex = i;
            }
            while (rs.next()) {
                String name = rs.getString(nameIndex);
                String type = rs.getString(typeIndex);
                String pk = "0";
                if (pkIndex > 0) {
                    pk = rs.getString(pkIndex);
                }
                columnNames.add(new String[]{name, type, pk});
            }
            ArrayList<String[]> arrayList = columnNames;
            return arrayList;
        }
    }

    public SpatialiteGeometryColumns getGeometryColumnsForTable(String tableName) throws SQLException {
        String sql = "select f_table_name, f_geometry_column, geometry_type,coord_dimension, srid, spatial_index_enabled from geometry_columns where f_table_name='" + tableName + "'";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                SpatialiteGeometryColumns gc = new SpatialiteGeometryColumns();
                gc.f_table_name = rs.getString(1);
                gc.f_geometry_column = rs.getString(2);
                gc.geometry_type = rs.getInt(3);
                gc.coord_dimension = rs.getInt(4);
                gc.srid = rs.getInt(5);
                gc.spatial_index_enabled = rs.getInt(6);
                SpatialiteGeometryColumns spatialiteGeometryColumns = gc;
                return spatialiteGeometryColumns;
            }
            SpatialiteGeometryColumns spatialiteGeometryColumns = null;
            return spatialiteGeometryColumns;
        }
    }

    public boolean isTableSpatial(String tableName) throws SQLException {
        SpatialiteGeometryColumns geometryColumns = this.getGeometryColumnsForTable(tableName);
        return geometryColumns != null;
    }

    public List<ForeignKey> getForeignKeys(String tableName) throws SQLException {
        ArrayList<ForeignKey> fKeys = new ArrayList<ForeignKey>();
        String sql = "PRAGMA foreign_key_list(" + tableName + ")";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int fromIndex = -1;
            int toIndex = -1;
            int toTableIndex = -1;
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                if (columnName.equals("from")) {
                    fromIndex = i;
                    continue;
                }
                if (columnName.equals("to")) {
                    toIndex = i;
                    continue;
                }
                if (!columnName.equals("table")) continue;
                toTableIndex = i;
            }
            while (rs.next()) {
                ForeignKey fKey = new ForeignKey();
                Object fromObj = rs.getObject(fromIndex);
                Object toObj = rs.getObject(toIndex);
                Object toTableObj = rs.getObject(toTableIndex);
                if (fromObj == null || toObj == null || toTableObj == null) continue;
                fKey.from = fromObj.toString();
                fKey.to = toObj.toString();
                fKey.table = toTableObj.toString();
                fKeys.add(fKey);
            }
            ArrayList<ForeignKey> arrayList = fKeys;
            return arrayList;
        }
    }

    public long getCount(String tableName) throws SQLException {
        String sql = "select count(*) from " + tableName;
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                long count;
                long l = count = rs.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    public QueryResult getTableRecordsMapIn(String tableName, Envelope envelope, boolean alsoPK_UID, int limit) throws SQLException, ParseException {
        QueryResult queryResult = new QueryResult();
        SpatialiteGeometryColumns gCol = this.getGeometryColumnsForTable(tableName);
        boolean hasGeom = gCol != null;
        List<String[]> tableColumnsInfo = this.getTableColumns(tableName);
        ArrayList<String> tableColumns = new ArrayList<String>();
        for (String[] info : tableColumnsInfo) {
            tableColumns.add(info[0]);
        }
        if (hasGeom) {
            tableColumns.remove(gCol.f_geometry_column);
        }
        if (!alsoPK_UID) {
            tableColumns.remove(PK_UID);
        }
        String sql = "SELECT ";
        if (hasGeom) {
            sql = sql + "ST_AsBinary(" + gCol.f_geometry_column + ") AS " + gCol.f_geometry_column;
        }
        for (int i = 0; i < tableColumns.size(); ++i) {
            if (hasGeom || i != 0) {
                sql = sql + ",";
            }
            sql = sql + (String)tableColumns.get(i);
        }
        sql = sql + " FROM " + tableName;
        if (envelope != null) {
            double x1 = envelope.getMinX();
            double y1 = envelope.getMinY();
            double x2 = envelope.getMaxX();
            double y2 = envelope.getMaxY();
            sql = sql + " WHERE ";
            sql = sql + this.getSpatialindexBBoxWherePiece(tableName, null, x1, y1, x2, y2);
        }
        if (limit > 0) {
            sql = sql + " LIMIT " + limit;
        }
        WKBReader wkbReader = new WKBReader();
        try (Statement stmt = this.conn.createStatement();){
            int i;
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            for (i = 1; i <= columnCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                queryResult.names.add(columnName);
                String columnTypeName = rsmd.getColumnTypeName(i);
                queryResult.types.add(columnTypeName);
                if (!hasGeom || !columnName.equals(gCol.f_geometry_column)) continue;
                queryResult.geometryIndex = i - 1;
            }
            while (rs.next()) {
                i = 1;
                Object[] rec = new Object[columnCount];
                if (hasGeom) {
                    byte[] geomBytes = rs.getBytes(i);
                    Geometry geometry = wkbReader.read(geomBytes);
                    rec[i - 1] = geometry;
                }
                for (int j = ++i; j <= columnCount; ++j) {
                    Object object;
                    rec[j - 1] = object = rs.getObject(j);
                }
                queryResult.data.add(rec);
            }
            QueryResult queryResult2 = queryResult;
            return queryResult2;
        }
    }

    public QueryResult getTableRecordsMapFromRawSql(String sql, int limit) throws SQLException, ParseException {
        QueryResult queryResult = new QueryResult();
        WKBReader wkbReader = new WKBReader();
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int geometryIndex = -1;
            for (int i = 1; i <= columnCount; ++i) {
                int columnType = rsmd.getColumnType(i);
                String columnName = rsmd.getColumnName(i);
                queryResult.names.add(columnName);
                String columnTypeName = rsmd.getColumnTypeName(i);
                queryResult.types.add(columnTypeName);
                if (!columnTypeName.equals("BLOB") || SpatialiteGeometryType.forValue(columnType) == null) continue;
                geometryIndex = i;
                queryResult.geometryIndex = i - 1;
            }
            int count = 0;
            while (rs.next()) {
                Object[] rec = new Object[columnCount];
                for (int j = 1; j <= columnCount; ++j) {
                    Object object;
                    if (j == geometryIndex) {
                        byte[] geomBytes = rs.getBytes(j);
                        try {
                            Geometry geometry = wkbReader.read(geomBytes);
                            rec[j - 1] = geometry;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    rec[j - 1] = object = rs.getObject(j);
                }
                queryResult.data.add(rec);
                if (limit <= 0 || ++count <= limit - 1) continue;
                break;
            }
            QueryResult queryResult2 = queryResult;
            return queryResult2;
        }
    }

    public void runRawSqlToCsv(String sql, File csvFile, boolean doHeader, String separator) throws SQLException, ParseException, IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvFile));){
            WKBReader wkbReader = new WKBReader();
            try (Statement stmt = this.conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                int geometryIndex = -1;
                for (int i = 1; i <= columnCount; ++i) {
                    if (i > 1) {
                        bw.write(separator);
                    }
                    int columnType = rsmd.getColumnType(i);
                    String columnTypeName = rsmd.getColumnTypeName(i);
                    String columnName = rsmd.getColumnName(i);
                    bw.write(columnName);
                    if (!columnTypeName.equals("BLOB") || SpatialiteGeometryType.forValue(columnType) == null) continue;
                    geometryIndex = i;
                }
                bw.write("\n");
                while (rs.next()) {
                    for (int j = 1; j <= columnCount; ++j) {
                        block37: {
                            if (j > 1) {
                                bw.write(separator);
                            }
                            if (j == geometryIndex) {
                                byte[] geomBytes = rs.getBytes(j);
                                if (geomBytes != null) {
                                    try {
                                        Geometry geometry = wkbReader.read(geomBytes);
                                        bw.write(geometry.toText());
                                    }
                                    catch (Exception e) {
                                        Object object = rs.getObject(j);
                                        if (object != null) {
                                            bw.write(object.toString());
                                            break block37;
                                        }
                                        bw.write("");
                                    }
                                } else {
                                    Object object = rs.getObject(j);
                                    if (object != null) {
                                        bw.write(object.toString());
                                    } else {
                                        bw.write("");
                                    }
                                }
                            }
                        }
                        bw.write("\n");
                    }
                }
            }
        }
    }

    public int executeInsertUpdateDeleteSql(String sql) throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            int executeUpdate;
            int n = executeUpdate = stmt.executeUpdate(sql);
            return n;
        }
    }

    public List<Geometry> getGeometriesIn(String tableName, Envelope envelope) throws SQLException, ParseException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        SpatialiteGeometryColumns gCol = this.getGeometryColumnsForTable(tableName);
        String sql = "SELECT ST_AsBinary(" + gCol.f_geometry_column + ") FROM " + tableName;
        if (envelope != null) {
            double x1 = envelope.getMinX();
            double y1 = envelope.getMinY();
            double x2 = envelope.getMaxX();
            double y2 = envelope.getMaxY();
            sql = sql + " WHERE " + this.getSpatialindexBBoxWherePiece(tableName, null, x1, y1, x2, y2);
        }
        WKBReader wkbReader = new WKBReader();
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                byte[] geomBytes = rs.getBytes(1);
                Geometry geometry = wkbReader.read(geomBytes);
                geoms.add(geometry);
            }
            ArrayList<Geometry> arrayList = geoms;
            return arrayList;
        }
    }

    public String getSpatialindexBBoxWherePiece(String tableName, String alias, double x1, double y1, double x2, double y2) throws SQLException {
        String rowid = "";
        if (alias == null) {
            alias = "";
            rowid = tableName + ".ROWID";
        } else {
            rowid = alias + ".ROWID";
            alias = alias + ".";
        }
        SpatialiteGeometryColumns gCol = this.getGeometryColumnsForTable(tableName);
        String sql = "ST_Intersects(" + alias + gCol.f_geometry_column + ", BuildMbr(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ")) = 1 AND " + rowid + " IN ( SELECT ROWID FROM SpatialIndex WHERE " + "f_table_name = '" + tableName + "' AND " + "search_frame = BuildMbr(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + "))";
        return sql;
    }

    public Envelope getTableBounds(String tableName) throws SQLException {
        SpatialiteGeometryColumns gCol = this.getGeometryColumnsForTable(tableName);
        String geomFieldName = gCol.f_geometry_column;
        String trySql = "SELECT extent_min_x, extent_min_y, extent_max_x, extent_max_y FROM vector_layers_statistics WHERE table_name='" + tableName + "' AND geometry_column='" + geomFieldName + "'";
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(trySql);
            if (rs.next()) {
                Envelope env;
                double minX = rs.getDouble(1);
                double minY = rs.getDouble(2);
                double maxX = rs.getDouble(3);
                double maxY = rs.getDouble(4);
                Envelope envelope = env = new Envelope(minX, maxX, minY, maxY);
                return envelope;
            }
        }
        String sql = "SELECT Min(MbrMinX(" + geomFieldName + ")) AS min_x, Min(MbrMinY(" + geomFieldName + ")) AS min_y," + "Max(MbrMaxX(" + geomFieldName + ")) AS max_x, Max(MbrMaxY(" + geomFieldName + ")) AS max_y " + "FROM " + tableName;
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                Envelope env;
                double minX = rs.getDouble(1);
                double minY = rs.getDouble(2);
                double maxX = rs.getDouble(3);
                double maxY = rs.getDouble(4);
                Envelope envelope = env = new Envelope(minX, maxX, minY, maxY);
                return envelope;
            }
            Envelope envelope = null;
            return envelope;
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public static String escapeSql(String sql) {
        sql = sql.replaceAll("'", "''");
        sql = sql.replaceAll("\"", "\"\"");
        sql = sql.replaceAll("\\\\", "");
        return sql;
    }

    public static String getTimestampQuery(String columnName, String datePattern) {
        if (datePattern == null) {
            datePattern = "%Y-%m-%d %H:%M:%S";
        }
        String sql = "strftime('" + datePattern + "', " + columnName + " / 1000, 'unixepoch')";
        return sql;
    }

    public static void main(String[] args) throws Exception {
        String dbPath = "";
        try (SpatialiteDb db = new SpatialiteDb();){
            Object gc;
            db.open(dbPath);
            EggClock clock = new EggClock("time:", "\n");
            clock.startAndPrint(System.out);
            System.out.println(Arrays.toString(db.getDbInfo()));
            clock.printTimePassedInSeconds(System.out);
            List<String> tableNames = db.getTables(true);
            System.out.println("Tables:");
            for (String string : tableNames) {
                System.out.println(string);
            }
            clock.printTimePassedInSeconds(System.out);
            HashMap<String, List<String>> tablesMap = db.getTablesMap(true);
            for (Map.Entry<String, List<String>> entry : tablesMap.entrySet()) {
                System.out.println(entry.getKey() + ": ");
                for (String tableName3 : entry.getValue()) {
                    gc = db.getGeometryColumnsForTable(tableName3);
                    if (gc == null) {
                        System.out.println("\t->" + tableName3);
                        continue;
                    }
                    System.out.println("\t->" + tableName3 + " / geom col: " + ((SpatialiteGeometryColumns)gc).f_geometry_column + " / srid: " + ((SpatialiteGeometryColumns)gc).srid + " / geom type: " + (Object)((Object)SpatialiteGeometryType.forValue(((SpatialiteGeometryColumns)gc).geometry_type)));
                }
            }
            clock.printTimePassedInSeconds(System.out);
            System.out.println("Has table roads:" + db.hasTable("roads"));
            clock.printTimePassedInSeconds(System.out);
            String string = "roads";
            List<String[]> list = db.getTableColumns(string);
            System.out.println(Arrays.toString(list.toArray()));
            clock.printTimePassedInSeconds(System.out);
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            QueryResult recordsIn = db.getTableRecordsMapIn(string, null, false, 10);
            System.out.println(recordsIn.data.size());
            if (recordsIn.geometryIndex != -1) {
                for (Object[] tableRecord : recordsIn.data) {
                    geoms.add((Geometry)tableRecord[recordsIn.geometryIndex]);
                }
            }
            gc = new GeometryCollection(geoms.toArray(GeometryUtilities.TYPE_GEOMETRY), new GeometryFactory());
            System.out.println(gc.toText());
            clock.printTimePassedInSeconds(System.out);
            String sql = "SELECT ST_AsBinary(the_geom) AS the_geom,osm_id,name,ref,type,oneway,bridge,tunnel,maxspeed FROM roads LIMIT 10";
            QueryResult recordsIn1 = db.getTableRecordsMapFromRawSql(sql, 10);
            System.out.println(recordsIn1.data.size());
            if (recordsIn1.geometryIndex != -1) {
                for (Object[] tableRecord : recordsIn1.data) {
                    geoms.add((Geometry)tableRecord[recordsIn1.geometryIndex]);
                }
            }
            gc = new GeometryCollection(geoms.toArray(GeometryUtilities.TYPE_GEOMETRY), new GeometryFactory());
            System.out.println(gc.toText());
            clock.printTimePassedInSeconds(System.out);
            List<Geometry> geometriesIn = db.getGeometriesIn(string, null);
            gc = new GeometryCollection(geometriesIn.toArray(GeometryUtilities.TYPE_GEOMETRY), new GeometryFactory());
            System.out.println(gc.toText());
            clock.printTimePassedInSeconds(System.out);
            Envelope tableBounds = db.getTableBounds(string);
            System.out.println(tableBounds);
            clock.printTimePassedInSeconds(System.out);
            QueryResult tableRecordsMapFromRawSql = db.getTableRecordsMapFromRawSql("SELECT *  FROM sql_statements_log", -1);
            System.out.println("sql history");
            int indexOf = tableRecordsMapFromRawSql.names.indexOf("sql_statement");
            if (indexOf != -1) {
                for (Object[] tableRecordMap : tableRecordsMapFromRawSql.data) {
                    System.out.println(tableRecordMap[indexOf]);
                }
            }
            clock.printTimePassedInSeconds(System.out);
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

