/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectortransformer;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.AffineTransform;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for vector tranforms. Currently only translation is supported.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Transform, Vector")
@Label(value="Vector Processing")
@Name(value="vtrans")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorTransformer
extends JGTModel {
    @Description(value="The feature collection that has to be transformed.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The translation along the X axis.")
    @In
    public double pTransX;
    @Description(value="The translation along the Y axis.")
    @In
    public double pTransY;
    @Description(value="The rotation angle in clockwise degrees.")
    @In
    public Double pRotate;
    @Description(value="The transformed feature collection.")
    @Out
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.outVector = new DefaultFeatureCollection();
        SimpleFeatureType featureType = (SimpleFeatureType)this.inVector.getSchema();
        ReferencedEnvelope vectorBounds = this.inVector.getBounds();
        double centerX = vectorBounds.getMinX() + (vectorBounds.getMaxX() - vectorBounds.getMinX()) / 2.0;
        double centerY = vectorBounds.getMinY() + (vectorBounds.getMaxY() - vectorBounds.getMinY()) / 2.0;
        double pAngle = 0.0;
        AffineTransform2D rotationTransform = null;
        if (this.pRotate != null) {
            pAngle = this.pRotate;
            AffineTransform rotationAT = new AffineTransform();
            rotationAT.translate(centerX, centerY);
            rotationAT.rotate(Math.toRadians(-pAngle));
            rotationAT.translate(-centerX, -centerY);
            rotationTransform = new AffineTransform2D(rotationAT);
        }
        FeatureGeometrySubstitutor substitutor = new FeatureGeometrySubstitutor(featureType);
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        this.pm.beginTask("Transforming geometries...", this.inVector.size());
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (this.pRotate != null) {
                geometry = JTS.transform((Geometry)geometry, (MathTransform)rotationTransform);
            }
            AffineTransform2D transform = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, this.pTransX, this.pTransY);
            Geometry transformedGeometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
            SimpleFeature newFeature = substitutor.substituteGeometry(feature, transformedGeometry);
            ((DefaultFeatureCollection)this.outVector).add(newFeature);
            this.pm.worked(1);
        }
        inFeatureIterator.close();
        this.pm.done();
    }
}

