/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorconverter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.ALasWriter;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.utils.LasStats;
import org.jgrasstools.gears.io.vectorwriter.OmsVectorWriter;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Coverter from LAS to vector point data.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Feature, Vector, Convert")
@Label(value="Vector Processing")
@Name(value="lasconverter")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsLasConverter
extends JGTModel {
    @Description(value="The LAS file.")
    @In
    public String inFile;
    @Description(value="A vector map of polygons to filter the data on.")
    @In
    public SimpleFeatureCollection inPolygons;
    @Description(value="The (min, max) range inside which the values should be taken.")
    @In
    public String pIntensityrange;
    @Description(value="The comma separated list of impulses values to keep.")
    @In
    public String pImpulses;
    @Description(value="The comma separated list of classes to keep.")
    @In
    public String pClasses;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="Only print header and exit (default is false).")
    @In
    public boolean doHeader = false;
    @Description(value="Print additional info and exit (default is false).")
    @In
    public boolean doInfo = false;
    @Description(value="Generate a bounding box polygon as output vector (default is false).")
    @In
    public boolean doBbox = false;
    @Description(value="The output file (csv, shp, las).")
    @UI(value="outfile")
    @In
    public String outFile;
    public static final String OMSLASCONVERTER_DESCRIPTION = "Coverter from LAS to vector point data.";
    public static final String OMSLASCONVERTER_DOCUMENTATION = "";
    public static final String OMSLASCONVERTER_KEYWORDS = "IO, Feature, Vector, Convert";
    public static final String OMSLASCONVERTER_LABEL = "Vector Processing";
    public static final String OMSLASCONVERTER_NAME = "lasconverter";
    public static final int OMSLASCONVERTER_STATUS = 5;
    public static final String OMSLASCONVERTER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSLASCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLASCONVERTER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSLASCONVERTER_inFile_DESCRIPTION = "The LAS file.";
    public static final String OMSLASCONVERTER_inPolygons_DESCRIPTION = "A vector map of polygons to filter the data on.";
    public static final String OMSLASCONVERTER_pIntensityrange_DESCRIPTION = "The (min, max) range inside which the values should be taken.";
    public static final String OMSLASCONVERTER_pImpulses_DESCRIPTION = "The comma separated list of impulses values to keep.";
    public static final String OMSLASCONVERTER_pClasses_DESCRIPTION = "The comma separated list of classes to keep.";
    public static final String OMSLASCONVERTER_pIndexrange_DESCRIPTION = "The min,max index of data to consider (useful to split in different files). Note that filters are applied after this for performance reasons, so resulting data might be less than expected.";
    public static final String OMSLASCONVERTER_pNorth_DESCRIPTION = "The optional requested boundary north coordinate.";
    public static final String OMSLASCONVERTER_pSouth_DESCRIPTION = "The optional requested boundary south coordinate.";
    public static final String OMSLASCONVERTER_pWest_DESCRIPTION = "The optional requested boundary west coordinate.";
    public static final String OMSLASCONVERTER_pEast_DESCRIPTION = "The optional requested boundary east coordinate.";
    public static final String OMSLASCONVERTER_doHeader_DESCRIPTION = "Only print header and exit (default is false).";
    public static final String OMSLASCONVERTER_doInfo_DESCRIPTION = "Print additional info and exit (default is false).";
    public static final String OMSLASCONVERTER_doBbox_DESCRIPTION = "Generate a bounding box polygon as output vector (default is false).";
    public static final String OMSLASCONVERTER_outFile_DESCRIPTION = "The output file (csv, shp, las).";
    private double[] intensityRange = null;
    private double[] impulses = null;
    private int[] classes = null;
    private ALasReader lasReader;
    private PreparedGeometry filterPolygons;
    private GeometryFactory gf = GeometryUtilities.gf();

    @Execute
    public void process() throws Exception {
        int i;
        String[] split;
        this.checkNull(this.inFile);
        if (this.inPolygons != null) {
            List<Geometry> polygonsList = FeatureUtilities.featureCollectionToGeometriesList(this.inPolygons, false, null);
            GeometryCollection gc = new GeometryCollection(polygonsList.toArray(new Geometry[0]), this.gf);
            Geometry polygonUnion = gc.buffer(0.0);
            this.filterPolygons = PreparedGeometryFactory.prepare((Geometry)polygonUnion);
        }
        boolean doShapefile = false;
        boolean doCsv = false;
        boolean doLas = false;
        if (this.outFile != null) {
            if (this.outFile.endsWith(".shp")) {
                doShapefile = true;
            } else if (this.outFile.endsWith(".las")) {
                doLas = true;
            } else if (this.outFile.endsWith(".csv")) {
                doCsv = true;
            }
        }
        DefaultFeatureCollection outGeodata = new DefaultFeatureCollection();
        File lasFile = new File(this.inFile);
        this.lasReader = ALasReader.getReader(lasFile, null);
        this.lasReader.open();
        ILasHeader header = this.lasReader.getHeader();
        CoordinateReferenceSystem crs = header.getCrs();
        if (crs == null) {
            throw new ModelsIllegalargumentException("No CRS infromation available for the input data.", this);
        }
        if (this.doHeader) {
            String headerString = header.toString();
            this.pm.message(headerString);
            if (!this.doInfo) {
                return;
            }
        }
        if (this.doBbox && doShapefile) {
            this.createBboxGeometry(crs, lasFile, (SimpleFeatureCollection)outGeodata);
            return;
        }
        if (this.pIntensityrange != null) {
            split = this.pIntensityrange.split(",");
            if (split.length != 2) {
                throw new ModelsIllegalargumentException("Intensity range has to be of the form: min,max", this, this.pm);
            }
            try {
                this.intensityRange = new double[]{Double.parseDouble(split[0]), Double.parseDouble(split[1])};
            }
            catch (Exception e) {
                throw new ModelsIllegalargumentException("Problem in converting min and max to numbers.", this, this.pm);
            }
        }
        if (this.pImpulses != null) {
            split = this.pImpulses.split(",");
            try {
                this.impulses = new double[split.length];
                for (i = 0; i < split.length; ++i) {
                    this.impulses[i] = Double.parseDouble(split[i]);
                }
            }
            catch (Exception e) {
                throw new ModelsIllegalargumentException("Problem in converting impulses values to numbers.", this, this.pm);
            }
        }
        if (this.pClasses != null) {
            split = this.pClasses.split(",");
            try {
                this.classes = new int[split.length];
                for (i = 0; i < split.length; ++i) {
                    this.classes[i] = (int)Double.parseDouble(split[i]);
                }
            }
            catch (Exception e) {
                throw new ModelsIllegalargumentException("Problem in converting classes to numbers.", this, this.pm);
            }
        }
        Envelope envelope = null;
        if (this.pNorth != null && this.pSouth != null && this.pEast != null && this.pWest != null) {
            envelope = new Envelope(this.pWest.doubleValue(), this.pEast.doubleValue(), this.pSouth.doubleValue(), this.pNorth.doubleValue());
        }
        SimpleFeatureType type = null;
        if (doShapefile) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("lasdata");
            b.setCRS(crs);
            b.add("the_geom", Point.class);
            b.add("elev", Double.class);
            b.add("intensity", Double.class);
            b.add("classification", Integer.class);
            b.add("impulse", Double.class);
            b.add("numimpulse", Double.class);
            type = b.buildFeatureType();
        }
        BufferedWriter csvWriter = null;
        if (doCsv) {
            csvWriter = new BufferedWriter(new FileWriter(this.outFile));
        }
        ALasWriter lasWriter = null;
        if (doLas) {
            lasWriter = ALasWriter.getWriter(new File(this.outFile), crs);
            lasWriter.setBounds(header);
            lasWriter.open();
        }
        long recordsCount = header.getRecordsCount();
        this.pm.message("File header info \n" + header);
        long addedFeatures = 0L;
        LasStats stats = new LasStats();
        this.pm.beginTask("Reading las data...", (int)recordsCount);
        while (this.lasReader.hasNextPoint()) {
            Point point;
            this.pm.worked(1);
            LasRecord lasDot = this.lasReader.getNextPoint();
            double x = lasDot.x;
            double y = lasDot.y;
            double z = lasDot.z;
            double intensity = lasDot.intensity;
            byte classification = lasDot.classification;
            double impulse = lasDot.returnNumber;
            double impulseNumber = lasDot.numberOfReturns;
            Coordinate tmp = new Coordinate(x, y, z);
            boolean takeIt = true;
            if (envelope != null && envelope.contains(tmp)) {
                takeIt = true;
            }
            if (takeIt && this.intensityRange != null) {
                takeIt = false;
                if (intensity >= this.intensityRange[0] && intensity <= this.intensityRange[1]) {
                    takeIt = true;
                }
            }
            if (takeIt && this.impulses != null) {
                takeIt = false;
                for (double imp : this.impulses) {
                    if (!NumericsUtilities.dEq(impulse, imp)) continue;
                    takeIt = true;
                    break;
                }
            }
            if (takeIt && this.classes != null) {
                takeIt = false;
                int[] nArray = this.classes;
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    double classs = nArray[j];
                    if (classification != (int)classs) continue;
                    takeIt = true;
                    break;
                }
            }
            if (this.filterPolygons != null && !this.filterPolygons.contains((Geometry)(point = this.gf.createPoint(tmp)))) {
                takeIt = false;
            }
            if (!takeIt) continue;
            if (this.doInfo) {
                stats.addClassification(classification);
                stats.addImpulse((int)impulse);
                stats.addIntensity(intensity);
                continue;
            }
            if (doLas) {
                lasWriter.addPoint(lasDot);
                ++addedFeatures;
                continue;
            }
            if (doShapefile) {
                SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(type);
                Point point2 = this.gf.createPoint(tmp);
                Object[] values = new Object[]{point2, z, intensity, (int)classification, impulse, impulseNumber};
                simpleFeatureBuilder.addAll(values);
                SimpleFeature feature = simpleFeatureBuilder.buildFeature(null);
                outGeodata.add(feature);
                ++addedFeatures;
                continue;
            }
            if (!doCsv) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(x);
            stringBuilder.append(",");
            stringBuilder.append(y);
            stringBuilder.append(",");
            stringBuilder.append(z);
            stringBuilder.append(",");
            stringBuilder.append(intensity);
            stringBuilder.append(",");
            stringBuilder.append(classification);
            stringBuilder.append(",");
            stringBuilder.append(impulse);
            stringBuilder.append(",");
            stringBuilder.append(impulseNumber);
            stringBuilder.append("\n");
            csvWriter.write(stringBuilder.toString());
            ++addedFeatures;
        }
        this.pm.done();
        if (this.doInfo) {
            this.pm.message(stats.toString());
        }
        if (addedFeatures != 0L) {
            this.pm.message("Points extracted: " + addedFeatures);
        }
        if (doCsv) {
            csvWriter.close();
        }
        if (doLas) {
            lasWriter.close();
        }
        if (doShapefile) {
            OmsVectorWriter.writeVector(this.outFile, (SimpleFeatureCollection)outGeodata);
        }
        if (this.lasReader != null) {
            this.lasReader.close();
        }
    }

    private void createBboxGeometry(CoordinateReferenceSystem crs, File lasFile, SimpleFeatureCollection outGeodata) throws IOException {
        ReferencedEnvelope3D envelope = this.lasReader.getHeader().getDataEnvelope();
        ReferencedEnvelope env2d = new ReferencedEnvelope((ReferencedEnvelope)envelope);
        Polygon polygon = FeatureUtilities.envelopeToPolygon(new Envelope2D((org.opengis.geometry.Envelope)env2d));
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("lasdataenvelope");
        b.setCRS(crs);
        b.add("the_geom", Polygon.class);
        b.add("id", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        Object[] values = new Object[]{polygon, lasFile.getName()};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(null);
        ((DefaultFeatureCollection)outGeodata).add(feature);
        OmsVectorWriter.writeVector(this.outFile, outGeodata);
    }
}

