/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorconverter;

import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.PrjFileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.io.dxfdwg.libs.DwgHandler;
import org.jgrasstools.gears.io.dxfdwg.libs.DwgReader;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to convert dxf files to geotools vecotors.")
@Documentation(value="OmsDwgConverter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, OmsDxfConverter, Feature, Vector, Reading")
@Label(value="Vector Processing")
@Name(value="dwgimport")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsDwgConverter
extends JGTModel {
    @Description(value="The dwg input file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The output point vector.")
    @Out
    public SimpleFeatureCollection pointsVector = null;
    @Description(value="The output line vector.")
    @Out
    public SimpleFeatureCollection lineVector = null;
    @Description(value="The output polygon vector.")
    @Out
    public SimpleFeatureCollection polygonVector = null;
    @Description(value="The output text vector.")
    @Out
    public SimpleFeatureCollection textVector;
    @Description(value="The output attributes vector.")
    @Out
    public SimpleFeatureCollection attributesVector;
    @Description(value="The output contour vector.")
    @Out
    public SimpleFeatureCollection contourVector;
    private CoordinateReferenceSystem crs;

    @Execute
    public void readFeatureCollection() throws Exception {
        String nameWithoutExtention;
        if (!this.concatOr(this.pointsVector == null, this.lineVector == null, this.polygonVector == null, this.doReset)) {
            return;
        }
        File dwgFile = new File(this.file);
        File parentFolder = dwgFile.getParentFile();
        File prjFile = new File(parentFolder, (nameWithoutExtention = FileUtilities.getNameWithoutExtention(dwgFile)) + ".prj");
        if (prjFile.exists()) {
            FileInputStream instream = new FileInputStream(prjFile);
            FileChannel channel = instream.getChannel();
            PrjFileReader reader = new PrjFileReader((ReadableByteChannel)channel);
            this.crs = reader.getCoordinateReferenceSystem();
        }
        if (this.crs == null) {
            if (this.pCode != null) {
                this.crs = CRS.decode((String)this.pCode);
            } else {
                throw new ModelsIllegalargumentException("Please specify the CRS for the imported DWG file.", this, this.pm);
            }
        }
        DwgHandler dataHandler = new DwgHandler(dwgFile, this.crs);
        dataHandler.getLayerTypes();
        DwgReader dwgReader = dataHandler.getDwgReader();
        this.textVector = dwgReader.getTextFeatures();
        this.attributesVector = dwgReader.getAttributesFeatures();
        this.contourVector = dwgReader.getContourFeatures();
        this.pointsVector = dwgReader.getMultiPointFeatures();
        this.lineVector = dwgReader.getMultiLineFeatures();
        this.polygonVector = dwgReader.getMultiPolygonFeatures();
    }
}

