/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.smoothing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;

public class FeatureSlidingAverage {
    private static final double DELTA = 1.0E-5;
    private final Geometry geometry;

    public FeatureSlidingAverage(Geometry geometry) {
        this.geometry = geometry;
    }

    public List<Coordinate> smooth(int lookAhead, boolean considerZ, double slide) {
        int i;
        List<Object> res = new ArrayList<Coordinate>();
        Coordinate[] coordinates = this.geometry.getCoordinates();
        int n = coordinates.length;
        if (n < 4 * lookAhead) {
            lookAhead = (int)Math.floor((double)n * 0.2);
        }
        if (lookAhead % 2 == 0) {
            ++lookAhead;
        }
        if (lookAhead < 3) {
            return null;
        }
        int halfLookAhead = lookAhead / 2;
        if (halfLookAhead > coordinates.length) {
            throw new RuntimeException();
        }
        int padding = 0;
        if (coordinates[0].distance(coordinates[n - 1]) < 1.0E-5) {
            int tmpN = lookAhead / 2;
            if (tmpN > n / 2) {
                tmpN = n / 2;
            }
            padding = tmpN;
            Coordinate[] ringCoordinates = new Coordinate[n + 2 * tmpN];
            for (i = 0; i < tmpN; ++i) {
                ringCoordinates[i] = coordinates[n - (tmpN - i) - 1];
            }
            System.arraycopy(coordinates, 0, ringCoordinates, tmpN, n);
            int index = 1;
            for (int i2 = ringCoordinates.length - padding; i2 < ringCoordinates.length; ++i2) {
                ringCoordinates[i2] = coordinates[index++];
            }
            coordinates = ringCoordinates;
        }
        n += 2 * padding;
        for (int j = 0; j < n; ++j) {
            Coordinate tmp = new Coordinate();
            res.add(tmp);
        }
        double sc = 1.0 / (double)lookAhead;
        Coordinate pCoord = new Coordinate();
        Coordinate sCoord = new Coordinate();
        this.pointAssign(coordinates, 0, considerZ, pCoord);
        for (i = 1; i < lookAhead; ++i) {
            Coordinate tmpCoord = new Coordinate();
            this.pointAssign(coordinates, i, considerZ, tmpCoord);
            this.pointAdd(pCoord, tmpCoord, pCoord);
        }
        i = halfLookAhead;
        while (i + halfLookAhead < n) {
            Coordinate tmpCoord = new Coordinate();
            this.pointAssign(coordinates, i, considerZ, sCoord);
            this.pointScalar(sCoord, 1.0 - slide, sCoord);
            this.pointScalar(pCoord, sc * slide, tmpCoord);
            this.pointAdd(tmpCoord, sCoord, (Coordinate)res.get(i));
            if (i + halfLookAhead + 1 < n) {
                this.pointAssign(coordinates, i - halfLookAhead, considerZ, tmpCoord);
                this.pointSubtract(pCoord, tmpCoord, pCoord);
                this.pointAssign(coordinates, i + halfLookAhead + 1, considerZ, tmpCoord);
                this.pointAdd(pCoord, tmpCoord, pCoord);
            }
            ++i;
        }
        for (i = 0; i < halfLookAhead; ++i) {
            Coordinate coordinate = (Coordinate)res.get(i);
            coordinate.x = coordinates[i].x;
            coordinate.y = coordinates[i].y;
            coordinate.z = coordinates[i].z;
        }
        for (i = n - halfLookAhead - 1; i < n; ++i) {
            Coordinate coordinate = (Coordinate)res.get(i);
            coordinate.x = coordinates[i].x;
            coordinate.y = coordinates[i].y;
            coordinate.z = coordinates[i].z;
        }
        if (padding != 0) {
            res = res.subList(padding, n - padding - 1);
            res.add(res.get(0));
        }
        return res;
    }

    private void pointAssign(Coordinate[] coordinates, int index, boolean considerZ, Coordinate newAssignedCoordinate) {
        Coordinate coordinate = coordinates[index];
        newAssignedCoordinate.x = coordinate.x;
        newAssignedCoordinate.y = coordinate.y;
        newAssignedCoordinate.z = considerZ ? coordinate.z : 0.0;
    }

    private void pointAdd(Coordinate a, Coordinate b, Coordinate res) {
        res.x = a.x + b.x;
        res.y = a.y + b.y;
        res.z = a.z + b.z;
    }

    private void pointSubtract(Coordinate a, Coordinate b, Coordinate res) {
        res.x = a.x - b.x;
        res.y = a.y - b.y;
        res.z = a.z - b.z;
    }

    private void pointScalar(Coordinate a, double k, Coordinate res) {
        res.x = a.x * k;
        res.y = a.y * k;
        res.z = a.z * k;
    }
}

