/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.tmsgenerator;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jgrasstools.gears.io.vectorreader.OmsVectorReader;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.r.tmsgenerator.GlobalMercator;
import org.jgrasstools.gears.modules.r.tmsgenerator.MBTilesHelper;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.images.ImageGenerator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for the generation of map tiles.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, TMS, Tiles")
@Label(value="Raster Processing")
@Name(value="tmsgenerator")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsTmsGenerator
extends JGTModel {
    @Description(value="A file containing the list of raster map paths to consider (the order is relevant, first layers are placed below others).")
    @UI(value="infile")
    @In
    public String inRasterFile = null;
    @Description(value="Optional regions for reading the rasters.")
    @In
    public List<GridGeometry2D> inRasterBounds = null;
    @Description(value="A file containing the list of vector map paths to consider (the order is relevant, first layers are placed below others).")
    @UI(value="infile")
    @In
    public String inVectorFile = null;
    @Description(value="An optional WMS url and layer name in the format: http://wmsurl#layername")
    @In
    public String inWMS = null;
    @Description(value="A name of the tile source.")
    @In
    public String pName = "tmstiles";
    @Description(value="The min zoom for which to generate tiles.")
    @In
    public Integer pMinzoom = null;
    @Description(value="The max zoom for which to generate tiles.")
    @In
    public Integer pMaxzoom = null;
    @Description(value="The north bound of the region to consider.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The coordinate reference system of the bound coordinates and supplied datasets (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pEpsg;
    @Description(value="An optional prj file to use instead of teh epsg code.")
    @UI(value="infile")
    @In
    public String inPrj;
    @Description(value="A shapefile to use to draw maps on zoom levels higher than pZoomLimit. Everything outside is not drawn.")
    @In
    public String inZoomLimitVector;
    @Description(value="The zoom limit above which the inZoomLimitVector is considered.")
    @In
    public double pZoomLimit = 17.0;
    @Description(value="Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.")
    @In
    public boolean doLenient = true;
    @Description(value="The image type to generate (0 = png = default, 1 = jpg).")
    @In
    public int pImagetype = 0;
    @Description(value="A color rgb tripled. if it is not null and a tiles is made only of that color, then the tiles is not generated. Usefull to avoid generation of empty tiles.")
    @In
    public int[] pCheckcolor = new int[]{255, 255, 255};
    @Description(value="Optional flag to force a legacy GRASS driver usage.")
    @In
    public Boolean doLegacyGrass = false;
    @Description(value="Do mbtiles database.")
    @In
    public boolean doMbtiles = false;
    @Description(value="The folder inside which to create the tiles.")
    @In
    public String inPath;
    private static final String EPSG_MERCATOR = "EPSG:3857";
    private static final String EPSG_LATLONG = "EPSG:4326";
    private int TILESIZE = 256;
    private PreparedGeometry zoomLimitGeometry;
    private MBTilesHelper mbtilesHelper;
    public CoordinateReferenceSystem dataCrs;

    @Execute
    public void process() throws Exception {
        File file;
        this.checkNull(this.inPath, this.pMinzoom, this.pMaxzoom, this.pWest, this.pEast, this.pSouth, this.pNorth);
        if (this.dataCrs == null) {
            if (this.pEpsg != null) {
                this.dataCrs = CRS.decode((String)this.pEpsg);
            } else {
                String wkt = FileUtilities.readFile(this.inPrj);
                this.dataCrs = CRS.parseWKT((String)wkt);
            }
        }
        String format = null;
        if (this.doMbtiles) {
            this.mbtilesHelper = new MBTilesHelper();
            File dbFolder = new File(this.inPath);
            File dbFile = new File(dbFolder, this.pName + ".mbtiles");
            ReferencedEnvelope dataBounds = new ReferencedEnvelope(this.pWest.doubleValue(), this.pEast.doubleValue(), this.pSouth.doubleValue(), this.pNorth.doubleValue(), this.dataCrs);
            MathTransform data2LLTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.dataCrs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            Envelope llEnvelope = JTS.transform((Envelope)dataBounds, (MathTransform)data2LLTransform);
            float n = (float)llEnvelope.getMaxY();
            float s = (float)llEnvelope.getMinY();
            float w = (float)llEnvelope.getMinX();
            float e = (float)llEnvelope.getMaxX();
            format = this.pImagetype == 0 ? "png" : "jpg";
            this.mbtilesHelper.open(dbFile);
            this.mbtilesHelper.createTables(true);
            this.mbtilesHelper.fillMetadata(n, s, w, e, this.pName, format, this.pMinzoom, this.pMaxzoom);
        }
        int threads = OmsTmsGenerator.getDefaultThreadsNum() * 5;
        String ext = "png";
        if (this.pImagetype == 1) {
            ext = "jpg";
        }
        List<String> inVectors = null;
        if (this.inVectorFile != null && new File(this.inVectorFile).exists()) {
            inVectors = FileUtilities.readFileToLinesList(new File(this.inVectorFile));
        }
        List<String> inRasters = null;
        if (this.inRasterFile != null && new File(this.inRasterFile).exists()) {
            inRasters = FileUtilities.readFileToLinesList(new File(this.inRasterFile));
        }
        if (inRasters == null && inVectors == null) {
            throw new ModelsIllegalargumentException("No raster and vector input maps available. check your inputs.", this, this.pm);
        }
        if (this.dataCrs == null && this.pEpsg == null && this.inPrj == null) {
            throw new ModelsIllegalargumentException("No projection info available. check your inputs.", this, this.pm);
        }
        CoordinateReferenceSystem mercatorCrs = CRS.decode((String)EPSG_MERCATOR);
        ReferencedEnvelope dataBounds = new ReferencedEnvelope(this.pWest.doubleValue(), this.pEast.doubleValue(), this.pSouth.doubleValue(), this.pNorth.doubleValue(), this.dataCrs);
        MathTransform data2MercatorTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.dataCrs, (CoordinateReferenceSystem)mercatorCrs);
        Envelope mercatorEnvelope = JTS.transform((Envelope)dataBounds, (MathTransform)data2MercatorTransform);
        ReferencedEnvelope mercatorBounds = new ReferencedEnvelope(mercatorEnvelope, mercatorCrs);
        if (this.inZoomLimitVector != null) {
            SimpleFeatureCollection zoomLimitVector = OmsVectorReader.readVector(this.inZoomLimitVector);
            List<Geometry> geoms = FeatureUtilities.featureCollectionToGeometriesList(zoomLimitVector, true, null);
            MultiPolygon multiPolygon = this.gf.createMultiPolygon(geoms.toArray(GeometryUtilities.TYPE_POLYGON));
            Geometry multiPolygonGeom = JTS.transform((Geometry)multiPolygon, (MathTransform)data2MercatorTransform);
            this.zoomLimitGeometry = PreparedGeometryFactory.prepare((Geometry)multiPolygonGeom);
        }
        File inFolder = new File(this.inPath);
        File baseFolder = new File(inFolder, this.pName);
        final ImageGenerator imgGen = new ImageGenerator(this.pm);
        if (this.inWMS != null) {
            imgGen.setWMS(this.inWMS);
        }
        imgGen.doLegacyGrass = this.doLegacyGrass;
        String notLoading = "Not loading non-existing file: ";
        if (inRasters != null) {
            for (String rasterPath : inRasters) {
                file = new File(rasterPath);
                if (file.exists()) {
                    imgGen.addCoveragePath(rasterPath);
                    continue;
                }
                this.pm.errorMessage(notLoading + rasterPath);
            }
        }
        if (this.inRasterBounds != null) {
            for (GridGeometry2D rasterBounds : this.inRasterBounds) {
                imgGen.addCoverageRegion(rasterBounds);
            }
        }
        if (inVectors != null) {
            for (String vectorPath : inVectors) {
                file = new File(vectorPath);
                if (file.exists()) {
                    imgGen.addFeaturePath(vectorPath, null);
                    continue;
                }
                this.pm.errorMessage(notLoading + vectorPath);
            }
        }
        imgGen.setLayers();
        double w = mercatorBounds.getMinX();
        double s = mercatorBounds.getMinY();
        double e = mercatorBounds.getMaxX();
        double n = mercatorBounds.getMaxY();
        GlobalMercator mercator = new GlobalMercator();
        for (int z = this.pMinzoom.intValue(); z <= this.pMaxzoom; ++z) {
            int[] llTileNumber = mercator.MetersToTile(w, s, z);
            int[] urTileNumber = mercator.MetersToTile(e, n, z);
            int startXTile = llTileNumber[0];
            int startYTile = llTileNumber[1];
            int endXTile = urTileNumber[0];
            int endYTile = urTileNumber[1];
            int tileNum = 0;
            ReferencedEnvelope levelBounds = new ReferencedEnvelope(mercatorCrs);
            ExecutorService fixedThreadPool = Executors.newFixedThreadPool(threads);
            this.pm.beginTask("Generating tiles at zoom level: " + z, (endXTile - startXTile + 1) * (endYTile - startYTile + 1));
            for (int i = startXTile; i <= endXTile; ++i) {
                for (int j = startYTile; j <= endYTile; ++j) {
                    double[] bounds = mercator.TileBounds(i, j, z);
                    double west = bounds[0];
                    double south = bounds[1];
                    double east = bounds[2];
                    double north = bounds[3];
                    final ReferencedEnvelope tmpBounds = new ReferencedEnvelope(west, east, south, north, mercatorCrs);
                    levelBounds.expandToInclude((Envelope)tmpBounds);
                    if (this.zoomLimitGeometry != null && (double)z > this.pZoomLimit) {
                        double safeExtend = tmpBounds.getWidth() > tmpBounds.getHeight() ? tmpBounds.getWidth() : tmpBounds.getHeight();
                        ReferencedEnvelope tmp = new ReferencedEnvelope(tmpBounds);
                        tmp.expandBy(safeExtend);
                        Polygon polygon = FeatureUtilities.envelopeToPolygon((Envelope)tmp);
                        if (!this.zoomLimitGeometry.intersects((Geometry)polygon)) {
                            this.pm.worked(1);
                            continue;
                        }
                    }
                    if (this.mbtilesHelper != null) {
                        final int x = i;
                        final int y = j;
                        final int zz = z;
                        final String fformat = format;
                        ++tileNum;
                        Runnable runner = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    BufferedImage image = imgGen.getImageWithCheck(tmpBounds, OmsTmsGenerator.this.TILESIZE, OmsTmsGenerator.this.TILESIZE, 0.0, OmsTmsGenerator.this.pCheckcolor);
                                    if (image != null) {
                                        OmsTmsGenerator.this.mbtilesHelper.addTile(x, y, zz, image, fformat);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                OmsTmsGenerator.this.pm.worked(1);
                            }
                        };
                        fixedThreadPool.execute(runner);
                        continue;
                    }
                    File imageFolder = new File(baseFolder, z + "/" + i);
                    if (!imageFolder.exists() && !imageFolder.mkdirs()) {
                        throw new ModelsIOException("Unable to create folder:" + imageFolder, this);
                    }
                    File ignoreMediaFile = new File(imageFolder, ".nomedia");
                    ignoreMediaFile.createNewFile();
                    File imageFile = new File(imageFolder, j + "." + ext);
                    if (imageFile.exists()) {
                        this.pm.worked(1);
                        continue;
                    }
                    ++tileNum;
                    final String imagePath = imageFile.getAbsolutePath();
                    final ReferencedEnvelope finalBounds = tmpBounds;
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (OmsTmsGenerator.this.pImagetype == 1) {
                                    imgGen.dumpJpgImage(imagePath, finalBounds, OmsTmsGenerator.this.TILESIZE, OmsTmsGenerator.this.TILESIZE, 0.0, OmsTmsGenerator.this.pCheckcolor);
                                } else {
                                    imgGen.dumpPngImage(imagePath, finalBounds, OmsTmsGenerator.this.TILESIZE, OmsTmsGenerator.this.TILESIZE, 0.0, OmsTmsGenerator.this.pCheckcolor);
                                }
                                OmsTmsGenerator.this.pm.worked(1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    };
                    fixedThreadPool.execute(runner);
                }
            }
            try {
                fixedThreadPool.shutdown();
                while (!fixedThreadPool.isTerminated()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException exx) {
                exx.printStackTrace();
            }
            this.pm.done();
            this.pm.message("Zoom level: " + z + " has " + tileNum + " tiles.");
        }
        if (this.mbtilesHelper != null) {
            this.mbtilesHelper.close();
        } else {
            CoordinateReferenceSystem latLongCrs = CRS.decode((String)EPSG_LATLONG);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)mercatorCrs, (CoordinateReferenceSystem)latLongCrs);
            Envelope latLongBounds = JTS.transform((Envelope)mercatorBounds, (MathTransform)transform);
            Coordinate latLongCentre = latLongBounds.centre();
            StringBuilder properties = new StringBuilder();
            properties.append("url=").append(this.pName).append("/ZZZ/XXX/YYY.").append(ext).append("\n");
            properties.append("minzoom=").append(this.pMinzoom).append("\n");
            properties.append("maxzoom=").append(this.pMaxzoom).append("\n");
            properties.append("center=").append(latLongCentre.y).append(" ").append(latLongCentre.x).append("\n");
            properties.append("type=tms").append("\n");
            File propFile = new File(inFolder, this.pName + ".mapurl");
            FileUtilities.writeFile(properties.toString(), propFile);
        }
    }
}

