/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.rasternull;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;

@Description(value="Module that puts a certain value of the raster to null.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Null, Raster")
@Label(value="Raster Processing")
@Name(value="rnull")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterNull
extends JGTModel {
    @Description(value="The raster to modify.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The value to set to null.")
    @In
    public Double pValue = null;
    @Description(value="If true, sets everything else to null.")
    @In
    public boolean doInverse = false;
    @Description(value="The the null value to set (else it is guessed).")
    @In
    public Double pNull = null;
    @Description(value="The new raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.pValue);
        double replaceValue = this.pValue;
        double nullValue = Double.NaN;
        if (this.pNull != null) {
            nullValue = this.pNull;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int rows = regionMap.getRows();
        int cols = regionMap.getCols();
        WritableRaster outWR = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, null);
        RandomIter inRasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        this.pm.beginTask("Nulling data...", cols);
        for (int c = 0; c < cols; ++c) {
            if (this.isCanceled(this.pm)) {
                return;
            }
            for (int r = 0; r < rows; ++r) {
                double value = inRasterIter.getSampleDouble(c, r, 0);
                if (!JGTConstants.isNovalue(value)) {
                    if (this.doInverse) {
                        if (!NumericsUtilities.dEq(value, replaceValue)) {
                            value = Double.NaN;
                        }
                    } else if (NumericsUtilities.dEq(value, replaceValue)) {
                        value = nullValue;
                    }
                    outIter.setSample(c, r, 0, value);
                    continue;
                }
                outIter.setSample(c, r, 0, Double.NaN);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        inRasterIter.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverage("nulled", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

