/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.houghes;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class HoughCircles {
    public int radiusMin;
    public int radiusMax;
    public int radiusInc;
    public int maxCircles;
    public int threshold = -1;
    byte[] imageValues;
    public int width;
    public int height;
    public int depth;
    public int offset;
    public int offx;
    public int offy;
    private int vectorMaxSize = 500;
    boolean useThreshold = false;
    int[][][] lut;
    private BufferedImage raster;

    public static void main(String[] args) throws Exception {
        int[] i;
        for (int index : i = new int[]{10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30}) {
            String inImage = "/home/hydrologis/data/rilievo_tls/slice_" + index + ".0rgb.png";
            String outImage = "/home/hydrologis/data/rilievo_tls/slice_" + index + ".0bw_out.png";
            BufferedImage src = ImageIO.read(new File(inImage));
            HoughCircles h = new HoughCircles(src, 10, 40, 1, 300);
            h.run();
            ImageIO.write((RenderedImage)src, "png", new File(outImage));
        }
    }

    public HoughCircles(BufferedImage raster, int radiusMin, int radiusMax, int radiusIncrement, int circleCount) {
        this.raster = raster;
        this.radiusMin = radiusMin;
        this.radiusMax = radiusMax;
        this.maxCircles = circleCount;
        this.radiusInc = radiusIncrement;
        this.depth = (radiusMax - radiusMin) / this.radiusInc + 1;
    }

    public void run() {
        this.offx = 0;
        this.offy = 0;
        this.width = this.raster.getWidth();
        this.height = this.raster.getHeight();
        this.offset = this.width;
        this.imageValues = new byte[this.width * this.height];
        int count = 0;
        RandomIter renderedImageIterator = RandomIterFactory.create((RenderedImage)this.raster, null);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                int sample = renderedImageIterator.getSample(c, r, 0);
                this.imageValues[count++] = (byte)sample;
            }
        }
        renderedImageIterator.done();
        double[][][] houghValues = this.houghTransform();
        Coordinate[] centerPoints = this.getCenterPoints(houghValues, this.maxCircles);
        Graphics2D g2d = (Graphics2D)this.raster.getGraphics();
        g2d.setColor(Color.red);
        g2d.setStroke(new BasicStroke(2.0f));
        for (Coordinate point : centerPoints) {
            int size = (int)point.z * 2;
            g2d.drawOval((int)point.x - size / 2, (int)point.y + -size / 2, size, size);
        }
    }

    private int buildLookUpTable() {
        int i = 0;
        int incDen = Math.round(8.0f * (float)this.radiusMin);
        this.lut = new int[2][incDen][this.depth];
        for (int radius = this.radiusMin; radius <= this.radiusMax; radius += this.radiusInc) {
            i = 0;
            for (int incNun = 0; incNun < incDen; ++incNun) {
                int rsin;
                int rcos;
                double angle = Math.PI * 2 * (double)incNun / (double)incDen;
                int indexR = (radius - this.radiusMin) / this.radiusInc;
                if (!(i == 0 | (rcos = (int)Math.round((double)radius * Math.cos(angle))) != this.lut[0][i][indexR] & (rsin = (int)Math.round((double)radius * Math.sin(angle))) != this.lut[1][i][indexR])) continue;
                this.lut[0][i][indexR] = rcos;
                this.lut[1][i][indexR] = rsin;
                ++i;
            }
        }
        return i;
    }

    private double[][][] houghTransform() {
        int lutSize = this.buildLookUpTable();
        double[][][] houghValues = new double[this.width][this.height][this.depth];
        int k = this.width - 1;
        int l = this.height - 1;
        for (int y = 1; y < l; ++y) {
            for (int x = 1; x < k; ++x) {
                for (int radius = this.radiusMin; radius <= this.radiusMax; radius += this.radiusInc) {
                    if (this.imageValues[x + this.offx + (y + this.offy) * this.offset] == 0) continue;
                    int indexR = (radius - this.radiusMin) / this.radiusInc;
                    for (int i = 0; i < lutSize; ++i) {
                        int a;
                        int b = y + this.lut[0][i][indexR];
                        if (!(b >= 0 & b < this.height & (a = x + this.lut[1][i][indexR]) >= 0 & a < this.width)) continue;
                        double[] dArray = houghValues[a][b];
                        int n = indexR;
                        dArray[n] = dArray[n] + 1.0;
                    }
                }
            }
        }
        return houghValues;
    }

    private void createHoughPixels(double[][][] houghValues, byte[] houghPixels) {
        double d = -1.0;
        for (int j = 0; j < this.height; ++j) {
            for (int k = 0; k < this.width; ++k) {
                if (!(houghValues[k][j][0] > d)) continue;
                d = houghValues[k][j][0];
            }
        }
        for (int l = 0; l < this.height; ++l) {
            for (int i = 0; i < this.width; ++i) {
                houghPixels[i + l * this.width] = (byte)Math.round(houghValues[i][l][0] * 255.0 / d);
            }
        }
    }

    public void drawCircles(double[][][] houghValues, byte[] circlespixels) {
        int roiaddr = 0;
        for (int y = this.offy; y < this.offy + this.height; ++y) {
            for (int x = this.offx; x < this.offx + this.width; ++x) {
                circlespixels[roiaddr] = this.imageValues[x + this.offset * y];
                circlespixels[roiaddr] = circlespixels[roiaddr] != 0 ? 100 : 0;
                ++roiaddr;
            }
        }
        Coordinate[] centerPoints = this.getCenterPoints(houghValues, this.maxCircles);
        int cor = -1;
        int offset = this.width;
        int offx = 0;
        int offy = 0;
        for (int l = 0; l < this.maxCircles; ++l) {
            int k;
            int i = (int)centerPoints[l].x;
            int j = (int)centerPoints[l].y;
            for (k = -10; k <= 10; ++k) {
                int p = (j + k + offy) * offset + (i + offx);
                if (!this.outOfBounds(j + k + offy, i + offx)) {
                    circlespixels[(j + k + offy) * offset + (i + offx)] = cor;
                }
                if (this.outOfBounds(j + offy, i + k + offx)) continue;
                circlespixels[(j + offy) * offset + (i + k + offx)] = cor;
            }
            for (k = -2; k <= 2; ++k) {
                if (!this.outOfBounds(j - 2 + offy, i + k + offx)) {
                    circlespixels[(j - 2 + offy) * offset + (i + k + offx)] = cor;
                }
                if (!this.outOfBounds(j + 2 + offy, i + k + offx)) {
                    circlespixels[(j + 2 + offy) * offset + (i + k + offx)] = cor;
                }
                if (!this.outOfBounds(j + k + offy, i - 2 + offx)) {
                    circlespixels[(j + k + offy) * offset + (i - 2 + offx)] = cor;
                }
                if (this.outOfBounds(j + k + offy, i + 2 + offx)) continue;
                circlespixels[(j + k + offy) * offset + (i + 2 + offx)] = cor;
            }
        }
    }

    private boolean outOfBounds(int y, int x) {
        if (x >= this.width) {
            return true;
        }
        if (x <= 0) {
            return true;
        }
        if (y >= this.height) {
            return true;
        }
        return y <= 0;
    }

    private Coordinate[] getCenterPoints(double[][][] houghValues, int maxCircles) {
        Coordinate[] centerPoints = new Coordinate[maxCircles];
        int xMax = 0;
        int yMax = 0;
        int rMax = 0;
        for (int c = 0; c < maxCircles; ++c) {
            double counterMax = -1.0;
            for (int radius = this.radiusMin; radius <= this.radiusMax; radius += this.radiusInc) {
                int indexR = (radius - this.radiusMin) / this.radiusInc;
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        if (!(houghValues[x][y][indexR] > counterMax)) continue;
                        counterMax = houghValues[x][y][indexR];
                        xMax = x;
                        yMax = y;
                        rMax = radius;
                    }
                }
            }
            centerPoints[c] = new Coordinate((double)xMax, (double)yMax, (double)rMax);
            this.clearNeighbours(houghValues, xMax, yMax, rMax);
        }
        return centerPoints;
    }

    private void clearNeighbours(double[][][] houghValues, int x, int y, int radius) {
        double halfRadius = (float)radius / 2.0f;
        double halfSquared = halfRadius * halfRadius;
        int y1 = (int)Math.floor((double)y - halfRadius);
        int y2 = (int)Math.ceil((double)y + halfRadius) + 1;
        int x1 = (int)Math.floor((double)x - halfRadius);
        int x2 = (int)Math.ceil((double)x + halfRadius) + 1;
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > this.height) {
            y2 = this.height;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > this.width) {
            x2 = this.width;
        }
        for (int r = this.radiusMin; r <= this.radiusMax; r += this.radiusInc) {
            int indexR = (r - this.radiusMin) / this.radiusInc;
            for (int i = y1; i < y2; ++i) {
                for (int j = x1; j < x2; ++j) {
                    if (!(Math.pow(j - x, 2.0) + Math.pow(i - y, 2.0) < halfSquared)) continue;
                    houghValues[j][i][indexR] = 0.0;
                }
            }
        }
    }
}

