/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.filter;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.libs.modules.GridNode;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

@Description(value="A biased sigma filter.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, filter, biased sigma")
@Label(value="Raster Processing")
@Name(value="sigmafilter")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsBiasedSigmaFilter
extends JGTModel {
    @Description(value="The input raster")
    @In
    public GridCoverage2D inGeodata;
    @Description(value="The filter windows in cells.")
    @In
    public int pWindow = 3;
    @Description(value="The output raster")
    @Out
    public GridCoverage2D outGeodata;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeodata);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGeodata);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        RandomIter inIter = CoverageUtilities.getRandomIterator(this.inGeodata);
        WritableRaster outWR = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, Double.NaN);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        int part = (this.pWindow - 1) / 2;
        this.pm.beginTask("Processing filter...", cols - (this.pWindow - 1));
        for (int c = part; c < cols - part; ++c) {
            for (int r = part; r < rows - part; ++r) {
                double deltaLower;
                double deltaUpper;
                GridNode node = new GridNode(inIter, cols, rows, xres, yres, c, r);
                if (!node.isValid() || node.touchesBound()) continue;
                double[][] window = node.getWindow(this.pWindow, false);
                double elevation = node.elevation;
                double sumUpper = 0.0;
                double countUpper = 0.0;
                double sumLower = 0.0;
                double countLower = 0.0;
                for (int i = 0; i < window.length; ++i) {
                    for (int j = 0; j < window[0].length; ++j) {
                        if (i == 1 && j == 1) continue;
                        if (window[i][j] >= elevation) {
                            sumUpper += window[i][j];
                            countUpper += 1.0;
                            continue;
                        }
                        sumLower += window[i][j];
                        countLower += 1.0;
                    }
                }
                double avgUpper = sumUpper / countUpper;
                double avgLower = sumLower / countLower;
                double value = 0.0;
                value = countUpper == 0.0 ? avgLower : (countLower == 0.0 ? avgUpper : ((deltaUpper = Math.abs(elevation - avgUpper)) < (deltaLower = Math.abs(elevation - avgLower)) ? avgUpper : avgLower));
                if (JGTConstants.isNovalue(value)) continue;
                outIter.setSample(c, r, 0, value);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        outIter.done();
        this.outGeodata = CoverageUtilities.buildCoverage("sigma", outWR, (HashMap<String, Double>)regionMap, this.inGeodata.getCoordinateReferenceSystem());
    }
}

