/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.cutout;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

@Description(value="Module for raster thresholding and masking.")
@Documentation(value="OmsCutOut.html")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Threshold, OmsMapcalc")
@Label(value="Raster Processing")
@Name(value="cutout")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsCutOut
extends JGTModel {
    @Description(value="The map that has to be processed.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The map to use as mask.")
    @In
    public GridCoverage2D inMask;
    @Description(value="The upper threshold value.")
    @In
    public Double pMax;
    @Description(value="The lower threshold value.")
    @In
    public Double pMin;
    @Description(value="Switch for doing extraction of the mask area or the inverse (negative). Default is false and extract the mask area.")
    @In
    public boolean doInverse = false;
    @Description(value="The processed map.")
    @Out
    public GridCoverage2D outRaster = null;
    private RandomIter maskIter;
    private boolean doMax = false;
    private boolean doMin = false;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        double max = -1.0;
        double min = -1.0;
        if (this.pMax != null) {
            max = this.pMax;
            this.doMax = true;
        }
        if (this.pMin != null) {
            min = this.pMin;
            this.doMin = true;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int nCols = ((Double)regionMap.get("COLS")).intValue();
        int nRows = ((Double)regionMap.get("ROWS")).intValue();
        RenderedImage geodataRI = this.inRaster.getRenderedImage();
        RandomIter geodataIter = RandomIterFactory.create((RenderedImage)geodataRI, null);
        if (this.inMask != null) {
            RenderedImage maskRI = this.inMask.getRenderedImage();
            this.maskIter = RandomIterFactory.create((RenderedImage)maskRI, null);
        }
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(geodataRI, false);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        this.pm.beginTask("Processing map...", nRows);
        for (int i = 0; i < nRows; ++i) {
            if (this.isCanceled(this.pm)) {
                return;
            }
            for (int j = 0; j < nCols; ++j) {
                if (this.maskIter != null) {
                    double maskValue = this.maskIter.getSampleDouble(j, i, 0);
                    if (!this.doInverse) {
                        if (JGTConstants.isNovalue(maskValue)) {
                            outIter.setSample(j, i, 0, Double.NaN);
                            continue;
                        }
                    } else if (!JGTConstants.isNovalue(maskValue)) {
                        outIter.setSample(j, i, 0, Double.NaN);
                        continue;
                    }
                }
                double value = geodataIter.getSampleDouble(j, i, 0);
                if (this.doMax && value > max) {
                    outIter.setSample(j, i, 0, Double.NaN);
                    continue;
                }
                if (!this.doMin || !(value < min)) continue;
                outIter.setSample(j, i, 0, Double.NaN);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("pitfiller", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

