/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.rasterreader;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.Operations;
import org.geotools.coverageio.gdal.aig.AIGReader;
import org.geotools.factory.Hints;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.gce.image.WorldImageReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.io.grasslegacy.OmsGrassLegacyReader;
import org.jgrasstools.gears.io.grasslegacy.utils.GrassLegacyUtilities;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Raster reader module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Reading")
@Label(value="Raster Reader")
@Name(value="rasterreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterReader
extends JGTModel {
    @Description(value="The raster file to read with extension (supported are: asc, tiff, grass).")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The file novalue.")
    @In
    public Double fileNovalue = -9999.0;
    @Description(value="The novalue wanted in the raster.")
    @In
    public Double geodataNovalue = Double.NaN;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The optional requested resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The optional requested resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The optional requested numer of rows.")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The optional requested numer of cols.")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="Optional flag to force a legacy GRASS driver usage.")
    @In
    public Boolean doLegacyGrass = false;
    @Description(value="The read output raster map.")
    @Out
    public GridCoverage2D outRaster = null;
    public boolean doEnvelope = false;
    public GeneralEnvelope originalEnvelope;
    private GeneralParameterValue[] generalParameter = null;
    private double[] pBounds;
    private double[] pRes;
    private int[] pRowcol;
    private double internalFileNovalue = -9999.0;
    private double internalGeodataNovalue = Double.NaN;
    private boolean doLegacyGrassAutoBoxed = false;

    @Execute
    public void process() throws Exception {
        block29: {
            if (!this.concatOr(this.outRaster == null, this.doReset)) {
                return;
            }
            if (this.doLegacyGrass != null && this.doLegacyGrass.booleanValue()) {
                this.doLegacyGrassAutoBoxed = true;
            }
            if (this.fileNovalue != null) {
                this.internalFileNovalue = this.fileNovalue;
            }
            if (this.geodataNovalue != null) {
                this.internalGeodataNovalue = this.geodataNovalue;
            }
            if (this.hasBoundsRequest() && !this.hasResolutionRequest() && !this.hasRowColsRequest()) {
                throw new RuntimeException("If bounds are requested, also a resolution or number of rows/cols has to be supplied.");
            }
            if (this.hasBoundsRequest()) {
                this.pBounds = new double[]{this.pNorth, this.pSouth, this.pWest, this.pEast};
            }
            if (this.hasResolutionRequest()) {
                this.pRes = new double[]{this.pXres, this.pYres};
            }
            if (this.hasRowColsRequest()) {
                this.pRowcol = new int[]{this.pRows, this.pCols};
            }
            String pType = null;
            if (this.file.toLowerCase().endsWith("asc")) {
                pType = "asc";
            } else if (this.file.toLowerCase().endsWith("adf")) {
                pType = "adf";
            } else if (this.file.toLowerCase().endsWith("tiff") || this.file.toLowerCase().endsWith("tif")) {
                pType = "tiff";
            } else if (this.file.toLowerCase().endsWith("jpeg") || this.file.toLowerCase().endsWith("jpg")) {
                pType = "jpg";
            } else if (this.file.toLowerCase().endsWith("png")) {
                pType = "png";
            } else if (CoverageUtilities.isGrass(this.file)) {
                pType = "grass";
            } else {
                throw new ModelsIllegalargumentException("Can't recognize the data format. Supported are: asc, tiff, jpg, png, grass.", this.getClass().getSimpleName(), this.pm);
            }
            File mapFile = new File(this.file);
            try {
                this.pm.beginTask("Reading coverage: " + mapFile.getName(), -1);
                if (pType.equals("asc")) {
                    this.readArcGrid(mapFile);
                    break block29;
                }
                if (pType.equals("tiff")) {
                    this.readGeotiff(mapFile);
                    break block29;
                }
                if (pType.equals("jpg")) {
                    this.readWorldImage(mapFile);
                    break block29;
                }
                if (pType.equals("png")) {
                    this.readWorldImage(mapFile);
                    break block29;
                }
                if (pType.equals("adf") || pType.endsWith("w001001x.adf")) {
                    this.readAig(mapFile);
                    break block29;
                }
                if (pType.equals("grass")) {
                    this.readGrass(mapFile);
                    break block29;
                }
                throw new ModelsIllegalargumentException("Data type not supported: " + pType, this.getClass().getSimpleName(), this.pm);
            }
            finally {
                this.pm.done();
            }
        }
    }

    private void readGrass(File mapFile) throws Exception {
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(new File(this.file));
        CoordinateReferenceSystem crs = mapEnvironment.getCoordinateReferenceSystem();
        JGrassRegion readRegion = mapEnvironment.getFileRegion();
        double n = readRegion.getNorth();
        double s = readRegion.getSouth();
        double w = readRegion.getWest();
        double e = readRegion.getEast();
        Envelope env = readRegion.getEnvelope();
        this.originalEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs));
        if (this.pBounds != null) {
            n = this.pBounds[0];
            s = this.pBounds[1];
            w = this.pBounds[2];
            e = this.pBounds[3];
        }
        if (this.pRes != null) {
            readRegion = new JGrassRegion(w, e, s, n, this.pRes[0], this.pRes[1]);
        }
        if (this.pRowcol != null) {
            readRegion = new JGrassRegion(w, e, s, n, this.pRowcol[0], this.pRowcol[1]);
        }
        if (!this.doEnvelope) {
            int c;
            int r = readRegion.getRows();
            if (!JGTConstants.doesOverFlow(r, c = readRegion.getCols()) && !this.doLegacyGrassAutoBoxed) {
                if (this.generalParameter == null) {
                    this.generalParameter = CoverageUtilities.createGridGeometryGeneralParameter(readRegion.getCols(), readRegion.getRows(), readRegion.getNorth(), readRegion.getSouth(), readRegion.getEast(), readRegion.getWest(), crs);
                }
                GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
                GrassCoverageReader reader = format.getReader((Object)mapEnvironment.getCELL());
                this.outRaster = reader.read(this.generalParameter);
            } else {
                OmsGrassLegacyReader reader = new OmsGrassLegacyReader();
                reader.file = this.file;
                reader.pm = this.pm;
                reader.inWindow = GrassLegacyUtilities.jgrassRegion2legacyWindow(readRegion);
                reader.readCoverage();
                this.outRaster = reader.outGC;
            }
            this.checkNovalues();
        }
    }

    private void readAig(File mapFile) throws IllegalArgumentException, IOException {
        URL url;
        ImageLayout l = new ImageLayout();
        l.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(512).setTileWidth(512);
        Hints hints = new Hints();
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, l));
        URL source = url = mapFile.toURI().toURL();
        AIGReader reader = new AIGReader((Object)source, hints);
        this.originalEnvelope = reader.getOriginalEnvelope();
        if (!this.doEnvelope) {
            GridCoverage2D coverage = reader.read(this.generalParameter);
            this.outRaster = coverage.view(ViewType.GEOPHYSICS);
            this.resample();
            this.checkNovalues();
        }
    }

    private void readGeotiff(File mapFile) throws IOException {
        String nameWithoutExtention = FileUtilities.getNameWithoutExtention(mapFile);
        File twfFile = new File(mapFile.getParentFile(), nameWithoutExtention + ".tfw");
        Object geoTiffReader = twfFile.exists() ? new WorldImageReader((Object)mapFile) : new GeoTiffReader((Object)mapFile);
        this.originalEnvelope = geoTiffReader.getOriginalEnvelope();
        if (!this.doEnvelope) {
            GridCoverage2D coverage = geoTiffReader.read(this.generalParameter);
            this.outRaster = coverage.view(ViewType.GEOPHYSICS);
            this.resample();
            this.checkNovalues();
        }
    }

    private void readArcGrid(File mapFile) throws IllegalArgumentException, IOException {
        ArcGridReader arcGridReader = new ArcGridReader((Object)mapFile);
        this.originalEnvelope = arcGridReader.getOriginalEnvelope();
        if (!this.doEnvelope) {
            GridCoverage2D coverage = arcGridReader.read(this.generalParameter);
            this.outRaster = coverage.view(ViewType.GEOPHYSICS);
            this.resample();
            this.checkNovalues();
        }
    }

    private void readWorldImage(File mapFile) throws IllegalArgumentException, IOException {
        WorldImageReader worldImageReader = new WorldImageReader((Object)mapFile);
        this.originalEnvelope = worldImageReader.getOriginalEnvelope();
        if (!this.doEnvelope) {
            GridCoverage2D coverage = worldImageReader.read(this.generalParameter);
            this.outRaster = coverage.view(ViewType.RENDERED);
            this.resample();
        }
    }

    private void resample() {
        if (!(this.hasBoundsRequest() || this.hasResolutionRequest() || this.hasRowColsRequest())) {
            return;
        }
        RegionMap envelopeParams = CoverageUtilities.getRegionParamsFromGridCoverage(this.outRaster);
        double west = (Double)envelopeParams.get("WEST");
        double south = (Double)envelopeParams.get("SOUTH");
        double east = (Double)envelopeParams.get("EAST");
        double north = (Double)envelopeParams.get("NORTH");
        double xres = (Double)envelopeParams.get("XRES");
        double yres = (Double)envelopeParams.get("YRES");
        if (this.pBounds == null) {
            this.pBounds = new double[]{north, south, west, east};
        }
        if (this.pRes == null) {
            this.pRes = new double[]{xres, yres};
        }
        double n = this.pBounds[0];
        double s = this.pBounds[1];
        double w = this.pBounds[2];
        double e = this.pBounds[3];
        if (this.pRes != null || this.pRowcol != null) {
            int newRows = 0;
            int newCols = 0;
            if (this.pRowcol != null) {
                newRows = this.pRowcol[0];
                newCols = this.pRowcol[1];
                if (this.pRes == null) {
                    this.pRes = new double[2];
                }
                this.pRes[0] = (e - w) / (double)newCols;
                this.pRes[1] = (n - s) / (double)newRows;
            } else if (this.pRes != null) {
                this.pRowcol = new int[2];
                newRows = (int)Math.round((n - s) / this.pRes[1]);
                newCols = (int)Math.round((e - w) / this.pRes[0]);
            }
            this.pRowcol[0] = newRows;
            this.pRowcol[1] = newCols;
        }
        RegionMap newParams = CoverageUtilities.makeRegionParamsMap(n, s, w, e, this.pRes[0], this.pRes[1], this.pRowcol[1], this.pRowcol[0]);
        CoordinateReferenceSystem crs = this.outRaster.getCoordinateReferenceSystem();
        GridGeometry2D gg = CoverageUtilities.gridGeometryFromRegionParams(newParams, crs);
        this.outRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.outRaster, crs, (GridGeometry)gg, null);
    }

    private void checkNovalues() {
        if (this.fileNovalue == null || this.geodataNovalue == null) {
            return;
        }
        if (JGTConstants.isNovalue(this.internalFileNovalue) && JGTConstants.isNovalue(this.internalGeodataNovalue)) {
            return;
        }
        if (!NumericsUtilities.dEq(this.internalFileNovalue, this.internalGeodataNovalue)) {
            RegionMap params = CoverageUtilities.getRegionParamsFromGridCoverage(this.outRaster);
            int height = ((Double)params.get("ROWS")).intValue();
            int width = ((Double)params.get("COLS")).intValue();
            WritableRaster tmpWR = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
            WritableRandomIter tmpIter = RandomIterFactory.createWritable((WritableRaster)tmpWR, null);
            RenderedImage readRI = this.outRaster.getRenderedImage();
            RandomIter readIter = RandomIterFactory.create((RenderedImage)readRI, null);
            int minX = readRI.getMinX();
            int minY = readRI.getMinY();
            for (int r = 0; r < height; ++r) {
                for (int c = 0; c < width; ++c) {
                    double value = readIter.getSampleDouble(c + minX, r + minY, 0);
                    if (JGTConstants.isNovalue(value) || value == this.internalFileNovalue || value == -3.4028234663852886E38 || value == 3.4028234663852886E38) {
                        tmpIter.setSample(c, r, 0, this.internalGeodataNovalue);
                        continue;
                    }
                    tmpIter.setSample(c, r, 0, value);
                }
            }
            readIter.done();
            tmpIter.done();
            this.outRaster = CoverageUtilities.buildCoverage(new File(this.file).getName(), tmpWR, (HashMap<String, Double>)params, this.outRaster.getCoordinateReferenceSystem());
        }
    }

    private boolean hasBoundsRequest() {
        return this.pNorth != null && this.pSouth != null && this.pWest != null && this.pEast != null;
    }

    private boolean hasRowColsRequest() {
        return this.pRows != null && this.pCols != null;
    }

    private boolean hasResolutionRequest() {
        return this.pXres != null && this.pYres != null;
    }

    public static GridCoverage2D readRaster(String path) throws Exception {
        OmsRasterReader reader = new OmsRasterReader();
        reader.file = path;
        reader.process();
        GridCoverage2D geodata = reader.outRaster;
        return geodata;
    }
}

