/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.utils;

public class LasStats {
    private int[] classifications = new int[20];
    private int[] impulses = new int[20];
    private double[] intensityRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    public void addClassification(int classificationType) {
        this.classifications[classificationType] = this.classifications[classificationType] + 1;
    }

    public void addImpulse(int impulseId) {
        this.impulses[impulseId] = this.impulses[impulseId] + 1;
    }

    public void addIntensity(double intensity) {
        this.intensityRange[0] = Math.min(this.intensityRange[0], intensity);
        this.intensityRange[1] = Math.max(this.intensityRange[1], intensity);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Classifications contained\n");
        for (i = 0; i < this.classifications.length; ++i) {
            if (this.classifications[i] == 0) continue;
            sb.append(i).append(" = ").append(this.classifications[i]).append("\n");
        }
        sb.append("Impulses contained\n");
        for (i = 0; i < this.impulses.length; ++i) {
            if (this.impulses[i] == 0) continue;
            sb.append(i).append(" = ").append(this.impulses[i]).append("\n");
        }
        sb.append("Intensity range\n");
        sb.append("min = ").append(this.intensityRange[0]).append("\n");
        sb.append("max = ").append(this.intensityRange[1]).append("\n");
        return sb.toString();
    }
}

