/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_VPORT_ITEM
extends DxfTABLE_ITEM {
    private double[] lowerLeftCorner;
    private double[] upperRightCorner;
    private double[] centerPoint;
    private double[] snapBasePoint;
    private double[] snapSpacing;
    private double[] gridSpacing;
    private double[] viewDirection;
    private double[] viewTargetPoint;
    private double viewHeight;
    private float aspectRatio;
    private float lensLength;
    private double frontClippingPlaneOffset;
    private double backClippingPlaneOffset;
    private float snapRotationAngle;
    private float twistAngle;
    private int viewMode;
    private int circleZoomPercent;
    private int fastZoomSetting;
    private int ucsIconSetting;
    private int snapOnOff;
    private int gridOnOff;
    private int snapStyle;
    private int snapIsoPair;

    public DxfTABLE_VPORT_ITEM(String name, int flags) {
        super(name, flags);
        this.lowerLeftCorner = new double[2];
        this.upperRightCorner = new double[2];
        this.centerPoint = new double[2];
        this.snapBasePoint = new double[2];
        this.snapSpacing = new double[2];
        this.gridSpacing = new double[2];
        this.viewDirection = new double[3];
        this.viewTargetPoint = new double[3];
        this.viewHeight = 0.0;
        this.aspectRatio = 0.0f;
        this.lensLength = 0.0f;
        this.frontClippingPlaneOffset = 0.0;
        this.backClippingPlaneOffset = 0.0;
        this.snapRotationAngle = 0.0f;
        this.twistAngle = 0.0f;
        this.viewMode = 0;
        this.circleZoomPercent = 0;
        this.fastZoomSetting = 0;
        this.ucsIconSetting = 0;
        this.snapOnOff = 0;
        this.gridOnOff = 0;
        this.snapStyle = 0;
        this.snapIsoPair = 0;
    }

    public DxfTABLE_VPORT_ITEM(String name, int flags, double[] lowerLeftCorner, double[] upperRightCorner, double[] centerPoint, double[] snapBasePoint, double[] snapSpacing, double[] gridSpacing, double[] viewDirection, double[] viewTargetPoint, double viewHeight, float aspectRatio, float lensLength, double frontClippingPlaneOffset, double backClippingPlaneOffset, float snapRotationAngle, float twistAngle, int viewMode, int circleZoomPercent, int fastZoomSetting, int ucsIconSetting, int snapOnOff, int gridOnOff, int snapStyle, int snapIsoPair) {
        super(name, flags);
        this.lowerLeftCorner = lowerLeftCorner;
        this.upperRightCorner = upperRightCorner;
        this.centerPoint = centerPoint;
        this.snapBasePoint = snapBasePoint;
        this.snapSpacing = snapSpacing;
        this.gridSpacing = gridSpacing;
        this.viewDirection = viewDirection;
        this.viewTargetPoint = viewTargetPoint;
        this.viewHeight = viewHeight;
        this.aspectRatio = aspectRatio;
        this.lensLength = lensLength;
        this.frontClippingPlaneOffset = frontClippingPlaneOffset;
        this.backClippingPlaneOffset = backClippingPlaneOffset;
        this.snapRotationAngle = snapRotationAngle;
        this.twistAngle = twistAngle;
        this.viewMode = viewMode;
        this.circleZoomPercent = circleZoomPercent;
        this.fastZoomSetting = fastZoomSetting;
        this.ucsIconSetting = ucsIconSetting;
        this.snapOnOff = snapOnOff;
        this.gridOnOff = gridOnOff;
        this.snapStyle = snapStyle;
        this.snapIsoPair = snapIsoPair;
    }

    public double[] getLowerLeftCorner() {
        return this.lowerLeftCorner;
    }

    public double[] getUpperRightCorner() {
        return this.upperRightCorner;
    }

    public double[] getCenterPoint() {
        return this.centerPoint;
    }

    public double[] getSnapBasePoint() {
        return this.snapBasePoint;
    }

    public double[] getSnapSpacing() {
        return this.snapSpacing;
    }

    public double[] getGridSpacing() {
        return this.gridSpacing;
    }

    public double[] getViewDirection() {
        return this.viewDirection;
    }

    public double[] getViewTargetPoint() {
        return this.viewTargetPoint;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public float getLensLength() {
        return this.lensLength;
    }

    public double getFrontClippingPlaneOffset() {
        return this.frontClippingPlaneOffset;
    }

    public double getBackClippingPlaneOffset() {
        return this.backClippingPlaneOffset;
    }

    public float getSnapRotationAngle() {
        return this.snapRotationAngle;
    }

    public float getTwistAngle() {
        return this.twistAngle;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public int getCircleZoomPercent() {
        return this.circleZoomPercent;
    }

    public int getFastZoomSetting() {
        return this.fastZoomSetting;
    }

    public int getUcsIconSetting() {
        return this.ucsIconSetting;
    }

    public int getSnapOnOff() {
        return this.snapOnOff;
    }

    public int getGridOnOff() {
        return this.gridOnOff;
    }

    public int getSnapStyle() {
        return this.snapStyle;
    }

    public int getSnapIsoPair() {
        return this.snapIsoPair;
    }

    public void setLowerLeftCorner(double[] lowerLeftCorner) {
        this.lowerLeftCorner = lowerLeftCorner;
    }

    public void setUpperRightCorner(double[] upperRightCorner) {
        this.upperRightCorner = upperRightCorner;
    }

    public void setCenterPoint(double[] centerPoint) {
        this.centerPoint = centerPoint;
    }

    public void setSnapBasePoint(double[] snapBasePoint) {
        this.snapBasePoint = snapBasePoint;
    }

    public void setSnapSpacing(double[] snapSpacing) {
        this.snapSpacing = snapSpacing;
    }

    public void setGridSpacing(double[] gridSpacing) {
        this.gridSpacing = gridSpacing;
    }

    public void setViewDirection(double[] viewDirection) {
        this.viewDirection = viewDirection;
    }

    public void setViewTargetPoint(double[] viewTargetPoint) {
        this.viewTargetPoint = viewTargetPoint;
    }

    public void setViewHeight(double viewHeight) {
        this.viewHeight = viewHeight;
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void setLensLength(float lensLength) {
        this.lensLength = lensLength;
    }

    public void setFrontClippingPlaneOffset(double frontClippingPlaneOffset) {
        this.frontClippingPlaneOffset = frontClippingPlaneOffset;
    }

    public void setBackClippingPlaneOffset(double backClippingPlaneOffset) {
        this.backClippingPlaneOffset = backClippingPlaneOffset;
    }

    public void setSnapRotationAngle(float snapRotationAngle) {
        this.snapRotationAngle = snapRotationAngle;
    }

    public void setTwistAngle(float twistAngle) {
        this.twistAngle = twistAngle;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
    }

    public void setCircleZoomPercent(int circleZoomPercent) {
        this.circleZoomPercent = circleZoomPercent;
    }

    public void setFastZoomSetting(int fastZoomSetting) {
        this.fastZoomSetting = fastZoomSetting;
    }

    public void setUcsIconSetting(int ucsIconSetting) {
        this.ucsIconSetting = ucsIconSetting;
    }

    public void setSnapOnOff(int snapOnOff) {
        this.snapOnOff = snapOnOff;
    }

    public void setGridOnOff(int gridOnOff) {
        this.gridOnOff = gridOnOff;
    }

    public void setSnapStyle(int snapStyle) {
        this.snapStyle = snapStyle;
    }

    public void setSnapIsoPair(int snapIsoPair) {
        this.snapIsoPair = snapIsoPair;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_VPORT_ITEM item = new DxfTABLE_VPORT_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_VPORT_ITEM> table = new LinkedHashMap<String, DxfTABLE_VPORT_ITEM>();
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(VPORT)) {
                item = new DxfTABLE_VPORT_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 10) {
                item.getLowerLeftCorner()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 20) {
                item.getLowerLeftCorner()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 11) {
                item.getUpperRightCorner()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 21) {
                item.getUpperRightCorner()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 12) {
                item.getCenterPoint()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 22) {
                item.getCenterPoint()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 13) {
                item.getSnapBasePoint()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 23) {
                item.getSnapBasePoint()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 14) {
                item.getSnapSpacing()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 24) {
                item.getSnapSpacing()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 15) {
                item.getGridSpacing()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 25) {
                item.getGridSpacing()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 16) {
                item.getViewDirection()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 26) {
                item.getViewDirection()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 36) {
                item.getViewDirection()[2] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 17) {
                item.getViewTargetPoint()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 27) {
                item.getViewTargetPoint()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 37) {
                item.getViewTargetPoint()[2] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 40) {
                item.setViewHeight(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 41) {
                item.setAspectRatio(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 42) {
                item.setLensLength(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 43) {
                item.setFrontClippingPlaneOffset(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 44) {
                item.setBackClippingPlaneOffset(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 50) {
                item.setSnapRotationAngle(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 51) {
                item.setTwistAngle(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 71) {
                item.setViewMode(group.getIntValue());
                continue;
            }
            if (group.getCode() == 72) {
                item.setCircleZoomPercent(group.getIntValue());
                continue;
            }
            if (group.getCode() == 73) {
                item.setFastZoomSetting(group.getIntValue());
                continue;
            }
            if (group.getCode() == 74) {
                item.setUcsIconSetting(group.getIntValue());
                continue;
            }
            if (group.getCode() == 75) {
                item.setSnapOnOff(group.getIntValue());
                continue;
            }
            if (group.getCode() == 76) {
                item.setGridOnOff(group.getIntValue());
                continue;
            }
            if (group.getCode() == 77) {
                item.setSnapStyle(group.getIntValue());
                continue;
            }
            if (group.getCode() != 78) continue;
            item.setSnapIsoPair(group.getIntValue());
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(10, this.lowerLeftCorner[0], 6));
        sb.append(DxfGroup.toString(20, this.lowerLeftCorner[1], 6));
        sb.append(DxfGroup.toString(11, this.upperRightCorner[0], 6));
        sb.append(DxfGroup.toString(21, this.upperRightCorner[1], 6));
        sb.append(DxfGroup.toString(12, this.centerPoint[0], 6));
        sb.append(DxfGroup.toString(22, this.centerPoint[1], 6));
        sb.append(DxfGroup.toString(13, this.snapBasePoint[0], 6));
        sb.append(DxfGroup.toString(23, this.snapBasePoint[1], 6));
        sb.append(DxfGroup.toString(14, this.snapSpacing[0], 6));
        sb.append(DxfGroup.toString(24, this.snapSpacing[1], 6));
        sb.append(DxfGroup.toString(15, this.gridSpacing[0], 6));
        sb.append(DxfGroup.toString(25, this.gridSpacing[1], 6));
        sb.append(DxfGroup.toString(16, this.viewDirection[0], 6));
        sb.append(DxfGroup.toString(26, this.viewDirection[1], 6));
        sb.append(DxfGroup.toString(36, this.viewDirection[2], 6));
        sb.append(DxfGroup.toString(17, this.viewTargetPoint[0], 6));
        sb.append(DxfGroup.toString(27, this.viewTargetPoint[1], 6));
        sb.append(DxfGroup.toString(37, this.viewTargetPoint[2], 6));
        sb.append(DxfGroup.toString(40, this.viewHeight, 6));
        sb.append(DxfGroup.toString(41, this.aspectRatio, 6));
        sb.append(DxfGroup.toString(42, this.lensLength, 6));
        sb.append(DxfGroup.toString(43, this.frontClippingPlaneOffset, 6));
        sb.append(DxfGroup.toString(44, this.backClippingPlaneOffset, 6));
        sb.append(DxfGroup.toString(50, this.snapRotationAngle, 6));
        sb.append(DxfGroup.toString(51, this.twistAngle, 6));
        sb.append(DxfGroup.toString(71, this.viewMode));
        sb.append(DxfGroup.toString(72, this.circleZoomPercent));
        sb.append(DxfGroup.toString(73, this.fastZoomSetting));
        sb.append(DxfGroup.toString(74, this.ucsIconSetting));
        sb.append(DxfGroup.toString(75, this.snapOnOff));
        sb.append(DxfGroup.toString(76, this.gridOnOff));
        sb.append(DxfGroup.toString(77, this.snapStyle));
        sb.append(DxfGroup.toString(78, this.snapIsoPair));
        return sb.toString();
    }
}

