/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects;

import java.awt.geom.Point2D;
import java.util.Vector;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgAttrib
extends DwgObject {
    private int dataFlag;
    private double elevation;
    private Point2D insertionPoint;
    private Point2D alignmentPoint;
    private double[] extrusion;
    private double thickness;
    private double obliqueAngle;
    private double rotationAngle;
    private double height;
    private double widthFactor;
    private String text;
    private int generation;
    private int halign;
    private int valign;
    private String tag;
    private int fieldLength;
    private int flags;
    private String prompt;
    private int styleHandle;

    public void readDwgAttribV15(int[] data, int offset) throws Exception {
        int flags;
        int fl;
        String tag;
        String text;
        double height;
        double th;
        int dflag;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.dataFlag = dflag = ((Integer)v.get(1)).intValue();
        if ((dflag & 1) == 0) {
            double elev;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.elevation = elev = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double x1 = (Double)v.get(1);
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double y1 = (Double)v.get(1);
        this.insertionPoint = new Point2D.Double(x1, y1);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if ((dflag & 2) == 0) {
            v = DwgUtil.getDefaultDouble(data, bitPos, x1);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, y1);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
        }
        this.alignmentPoint = new Point2D.Double(x, y);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean flag = (Boolean)v.get(1);
        if (flag) {
            x = y = 0.0;
            z = 1.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        }
        this.extrusion = new double[]{x, y, z};
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        flag = (Boolean)v.get(1);
        if (flag) {
            th = 0.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            th = (Double)v.get(1);
        }
        this.thickness = th;
        if ((dflag & 4) == 0) {
            double oblique;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.obliqueAngle = oblique = ((Double)v.get(1)).doubleValue();
        }
        if ((dflag & 8) == 0) {
            double rot;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.rotationAngle = rot = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.height = height = ((Double)v.get(1)).doubleValue();
        if ((dflag & 0x10) == 0) {
            double width;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.widthFactor = width = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.text = text = (String)v.get(1);
        if ((dflag & 0x20) == 0) {
            int gen;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.generation = gen = ((Integer)v.get(1)).intValue();
        }
        if ((dflag & 0x40) == 0) {
            int halign;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.halign = halign = ((Integer)v.get(1)).intValue();
        }
        if ((dflag & 0x80) == 0) {
            int valign;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.valign = valign = ((Integer)v.get(1)).intValue();
        }
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.tag = tag = (String)v.get(1);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.fieldLength = fl = ((Integer)v.get(1)).intValue();
        v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.flags = flags = ((Integer)v.get(1)).intValue();
        bitPos = this.readObjectTailV15(data, bitPos);
        v = DwgUtil.getHandle(data, bitPos);
        bitPos = (Integer)v.get(0);
        int[] handle = new int[v.size() - 1];
        for (int j = 1; j < v.size(); ++j) {
            handle[j - 1] = (Integer)v.get(j);
        }
        Vector<Integer> handleVect = new Vector<Integer>();
        for (int i = 0; i < handle.length; ++i) {
            handleVect.add(new Integer(handle[i]));
        }
        this.styleHandle = DwgUtil.handleBinToHandleInt(handleVect);
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public Point2D getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(Point2D insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public Object clone() {
        DwgAttrib dwgAttrib = new DwgAttrib();
        dwgAttrib.setType(this.type);
        dwgAttrib.setHandle(this.handle);
        dwgAttrib.setVersion(this.version);
        dwgAttrib.setMode(this.mode);
        dwgAttrib.setLayerHandle(this.layerHandle);
        dwgAttrib.setColor(this.color);
        dwgAttrib.setNumReactors(this.numReactors);
        dwgAttrib.setNoLinks(this.noLinks);
        dwgAttrib.setLinetypeFlags(this.linetypeFlags);
        dwgAttrib.setPlotstyleFlags(this.plotstyleFlags);
        dwgAttrib.setSizeInBits(this.sizeInBits);
        dwgAttrib.setExtendedData(this.extendedData);
        dwgAttrib.setGraphicData(this.graphicData);
        dwgAttrib.setDataFlag(this.dataFlag);
        dwgAttrib.setElevation(this.elevation);
        dwgAttrib.setInsertionPoint(this.insertionPoint);
        dwgAttrib.setAlignmentPoint(this.alignmentPoint);
        dwgAttrib.setExtrusion(this.extrusion);
        dwgAttrib.setThickness(this.thickness);
        dwgAttrib.setObliqueAngle(this.obliqueAngle);
        dwgAttrib.setRotationAngle(this.rotationAngle);
        dwgAttrib.setHeight(this.height);
        dwgAttrib.setWidthFactor(this.widthFactor);
        dwgAttrib.setText(this.text);
        dwgAttrib.setGeneration(this.generation);
        dwgAttrib.setHalign(this.halign);
        dwgAttrib.setValign(this.valign);
        dwgAttrib.setTag(this.tag);
        dwgAttrib.setFieldLength(this.fieldLength);
        dwgAttrib.setFlags(this.flags);
        dwgAttrib.setPrompt(this.prompt);
        dwgAttrib.setStyleHandle(this.styleHandle);
        return dwgAttrib;
    }

    public Point2D getAlignmentPoint() {
        return this.alignmentPoint;
    }

    public void setAlignmentPoint(Point2D alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
    }

    public int getDataFlag() {
        return this.dataFlag;
    }

    public void setDataFlag(int dataFlag) {
        this.dataFlag = dataFlag;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getObliqueAngle() {
        return this.obliqueAngle;
    }

    public void setObliqueAngle(double obliqueAngle) {
        this.obliqueAngle = obliqueAngle;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public int getStyleHandle() {
        return this.styleHandle;
    }

    public void setStyleHandle(int styleHandle) {
        this.styleHandle = styleHandle;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }
}

