/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.adige;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.jgrasstools.gears.io.adige.AdigeBoundaryCondition;
import org.jgrasstools.gears.libs.modules.JGTModel;

@Description(value="Utility class for reading the initial boundary conditions of the model adige from an OMS formatted csv file.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="Generic Reader")
@Name(value="adigeboundcondreader")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class AdigeBoundaryConditionReader
extends JGTModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The list initial boundary conditions.")
    @Out
    public HashMap<Integer, AdigeBoundaryCondition> data;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            this.table = DataIO.table((File)new File(this.file), null);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
        }
    }

    @Execute
    public void read() throws IOException {
        if (!this.concatOr(this.data == null, this.doReset)) {
            return;
        }
        this.ensureOpen();
        this.data = new HashMap();
        while (this.rowsIterator.hasNext()) {
            String[] row = (String[])this.rowsIterator.next();
            AdigeBoundaryCondition condition = new AdigeBoundaryCondition();
            int i = 1;
            condition.basinId = (int)Double.parseDouble(row[i++]);
            condition.discharge = Double.parseDouble(row[i++]);
            condition.dischargeSub = Double.parseDouble(row[i++]);
            condition.S1 = Double.parseDouble(row[i++]);
            condition.S2 = Double.parseDouble(row[i]);
            this.data.put(condition.basinId, condition);
        }
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

