/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import de.odysseus.el.util.SimpleResolver;
import jams.io.BufferedFileWriter;
import jams.model.Context;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.stores.Filter;
import jams.workspace.stores.FilterFunctions;
import jams.workspace.stores.OutputDataStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultOutputDataStore
implements OutputDataStore {
    private static final String TRACE_STRING = "attribute";
    private static final String FILTER_STRING = "filter";
    private static final String CONTEXT_STRING = "context";
    private static final String EXPRESSION_STRING = "expression";
    private static final String ATTRIBUTE_STRING = "id";
    private String id;
    private String[] attributes;
    private DefaultFilter[] filters;
    private transient BufferedFileWriter writer;
    private transient Workspace ws;
    private int columnsPerLine;
    private int columnCounter;
    private boolean firstRow;
    private File outputFile;

    public DefaultOutputDataStore(JAMSWorkspace ws, Document doc, String id) {
        this.id = id;
        this.ws = ws;
        Element root = doc.getDocumentElement();
        NodeList traceNodes = root.getElementsByTagName(TRACE_STRING);
        int length = traceNodes.getLength();
        this.attributes = new String[length];
        for (int i = 0; i < length; ++i) {
            Element traceElement = (Element)traceNodes.item(i);
            this.attributes[i] = traceElement.getAttribute(ATTRIBUTE_STRING);
        }
        NodeList filterNodes = root.getElementsByTagName(FILTER_STRING);
        length = filterNodes.getLength();
        this.filters = new DefaultFilter[length];
        for (int i = 0; i < length; ++i) {
            Element filterElement = (Element)filterNodes.item(i);
            this.filters[i] = new DefaultFilter(filterElement.getAttribute(CONTEXT_STRING), filterElement.getAttribute(EXPRESSION_STRING));
        }
        this.firstRow = true;
        this.columnsPerLine = 0;
        this.columnCounter = 0;
        File outputDirectory = ws.getOutputDataDirectory();
        outputDirectory.mkdirs();
        this.outputFile = new File(outputDirectory.getPath() + File.separator + id + ".dat");
    }

    public String getID() {
        return this.id;
    }

    public void setWorkspace(Workspace ws) throws IOException {
        boolean wasOpen = this.writer != null;
        this.close();
        this.ws = ws;
        File outputDirectory = ws.getOutputDataDirectory();
        outputDirectory.mkdirs();
        this.outputFile = new File(outputDirectory.getPath() + File.separator + this.id + ".dat");
        if (wasOpen) {
            this.open(true);
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void open(boolean append) throws IOException {
        File outputDirectory = this.ws.getOutputDataDirectory();
        outputDirectory.mkdirs();
        this.outputFile = new File(outputDirectory.getPath() + File.separator + this.id + ".dat");
        this.writer = new BufferedFileWriter(new FileOutputStream(this.outputFile, append));
    }

    public void write(Object o) throws IOException {
        this.writer.write(o.toString());
    }

    public void writeCell(Object o) throws IOException {
        ++this.columnCounter;
        this.writer.write(o.toString() + "\t");
    }

    public void nextRow() throws IOException {
        if (this.firstRow) {
            this.columnsPerLine = this.columnCounter;
            this.firstRow = false;
        } else {
            if (this.columnsPerLine > this.columnCounter) {
                System.err.println("DefaultOutputDataStore:row not complete, one or more attributes are missing");
            }
            if (this.columnsPerLine < this.columnCounter) {
                System.err.println("DefaultOutputDataStore:too many attributes in row");
            }
        }
        this.columnCounter = 0;
        this.writer.write("\n");
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        long position = in.readLong();
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = new BufferedFileWriter(new FileOutputStream(this.outputFile, true));
        this.writer.setPosition(position);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.writer != null) {
            out.writeLong(this.writer.getPosition());
        } else {
            out.writeLong(0L);
        }
    }

    public DefaultFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(DefaultFilter[] filters) {
        this.filters = filters;
    }

    public boolean isValid() {
        if (this.outputFile.canWrite()) {
            return true;
        }
        return true;
    }

    public static class DefaultFilter
    implements Filter {
        private String contextName;
        private String expression;
        private Context context = null;
        transient ExpressionFactory factory = null;
        transient SimpleContext exprContext = new SimpleContext((ELResolver)new SimpleResolver());
        transient ValueExpression valueExpr = null;
        transient ValueExpression idExpr = null;

        public DefaultFilter(String contextName, String expression) {
            this.contextName = contextName;
            this.expression = "${" + expression + "}";
            Properties properties = new Properties();
            properties.put("javax.el.cacheSize", "1000");
            properties.put("javax.el.methodInvocations", "false");
            properties.put("javax.el.nullProperties", "false");
            properties.put("javax.el.varArgs", "false");
            properties.put("javax.el.ignoreReturnType", "false");
            this.factory = new ExpressionFactoryImpl(properties);
            this.exprContext = FilterFunctions.getContext();
            this.valueExpr = this.factory.createValueExpression((ELContext)this.exprContext, this.expression, Boolean.TYPE);
            this.idExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${id}", Double.TYPE);
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isFiltered(String id) {
            this.idExpr.setValue((ELContext)this.exprContext, (Object)id);
            boolean result = (Boolean)this.valueExpr.getValue((ELContext)this.exprContext);
            return result;
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
            for (Context searchContext = this.getContext(); searchContext != null; searchContext = searchContext.getContext()) {
                ValueExpression contextExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${" + searchContext.getInstanceName() + "}", Context.class);
                contextExpr.setValue((ELContext)this.exprContext, (Object)searchContext);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Properties properties = new Properties();
            properties.put("javax.el.cacheSize", "1000");
            properties.put("javax.el.methodInvocations", "false");
            properties.put("javax.el.nullProperties", "false");
            properties.put("javax.el.varArgs", "false");
            properties.put("javax.el.ignoreReturnType", "false");
            this.exprContext = FilterFunctions.getContext();
            this.factory = new ExpressionFactoryImpl(properties);
            this.valueExpr = this.factory.createValueExpression((ELContext)this.exprContext, this.expression, Boolean.TYPE);
            this.idExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${id}", Double.TYPE);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }
    }
}

