/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.data.JAMSCalendar;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.Processor;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeSpaceProcessor
extends Processor {
    private static final String TABLE_NAME_MONTHAVG = "MONTHAVG";
    private static final String TABLE_NAME_YEARAVG = "YEARAVG";
    private static final String TABLE_NAME_SPATSUM = "SPATSUM";
    private String spaceID;
    private String timeID;
    private String timeFilter = null;
    private DateFormat dFormat;

    public TimeSpaceProcessor(File file) {
        this(new DataStoreProcessor(file));
    }

    public TimeSpaceProcessor(AbstractDataStoreProcessor dsdb) {
        this.dsdb = dsdb;
        this.contexts = dsdb.getContexts();
        this.dFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        if (dsdb.isTimeSpaceDatastore()) {
            this.spaceID = ((AbstractDataStoreProcessor.ContextData)this.contexts.get(0)).getName() + "ID";
            this.timeID = ((AbstractDataStoreProcessor.ContextData)this.contexts.get(1)).getName() + "ID";
            try {
                this.conn = dsdb.getH2Connection(true);
            }
            catch (SQLException ex) {
                Logger.getLogger(TimeSpaceProcessor.class.getName()).log(Level.INFO, "Error while creating connection to H2 database of {0}", dsdb.getFile());
                Logger.getLogger(TimeSpaceProcessor.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public synchronized ResultSet getData() throws SQLException {
        String query = "SELECT " + this.timeID + ", position FROM index";
        if (this.timeFilter != null) {
            query = query + " WHERE ";
            String s = null;
            if (this.timeFilter != null) {
                s = this.timeFilter.contains("%") ? " LIKE '" + this.timeFilter + "'" : " = '" + this.timeFilter + "'";
                query = query + this.timeID + s;
            }
        }
        query = query + " ORDER BY position";
        ResultSet rs = this.customSelectQuery(query);
        return rs;
    }

    public synchronized int getResultCount() throws SQLException {
        String query = "SELECT count(*) as COUNT FROM index";
        if (this.timeFilter != null) {
            query = query + " WHERE ";
            String s = null;
            if (this.timeFilter != null) {
                s = this.timeFilter.contains("%") ? " LIKE '" + this.timeFilter + "'" : " = '" + this.timeFilter + "'";
                query = query + this.timeID + s;
            }
        }
        ResultSet rs = this.customSelectQuery(query);
        rs.next();
        return rs.getInt("COUNT");
    }

    public synchronized DataMatrix getCrossProduct(long[] entityIds, String[] dateIds) throws SQLException, IOException {
        return this.getCrossProduct(entityIds, dateIds, 0);
    }

    public synchronized DataMatrix getCrossProduct(long[] entityIds, String[] dateIds, int attributeID) throws SQLException, IOException {
        if (entityIds == null) {
            throw new NullPointerException("getCrossProduct: entityIds must not be null");
        }
        if (dateIds == null) {
            throw new NullPointerException("getCrossProduct: dateIds must not be null");
        }
        double[][] matrix = new double[dateIds.length][entityIds.length];
        int[] idMap = null;
        Attribute.Calendar calendar = DefaultDataFactory.getDataFactory().createCalendar();
        for (int i = 0; i < dateIds.length; ++i) {
            calendar.setValue(dateIds[i]);
            DataMatrix col = this.getTemporalData(calendar);
            if (col == null) {
                if (this.dsdb != null && this.dsdb.getFile() != null) {
                    throw new IOException("getCrossProduct: date " + calendar.toString() + " is not available in file " + this.dsdb.getFile().getAbsolutePath());
                }
                throw new IOException("getCrossProduct: date " + calendar.toString() + " is not available");
            }
            if (idMap == null) {
                idMap = new int[entityIds.length];
                for (int j = 0; j < entityIds.length; ++j) {
                    idMap[j] = col.getIDPosition(Long.toString(entityIds[j]));
                }
            }
            double[] entities = col.getCol(attributeID);
            for (int j = 0; j < entityIds.length; ++j) {
                matrix[i][j] = entities[idMap[j]];
            }
        }
        String[] modelRunIdStrings = new String[entityIds.length];
        for (int i = 0; i < entityIds.length; ++i) {
            modelRunIdStrings[i] = Long.toString(entityIds[i]);
        }
        return new DataMatrix(matrix, (Object[])dateIds, modelRunIdStrings);
    }

    private synchronized DataMatrix getTemporalData(Attribute.Calendar date) throws SQLException, IOException {
        String filterString = date.toString(this.dFormat);
        this.setTimeFilter(filterString);
        ResultSet rs = this.getData();
        DataMatrix result = null;
        if (rs.next()) {
            long position = rs.getLong("POSITION");
            result = this.dsdb.getData(position);
        }
        return result;
    }

    private DataMatrix getAggregate(DataMatrix aggregate, int count, int weightAttribIndex) {
        int i;
        double[][] a = aggregate.getArray();
        double[] w = new double[a.length];
        if (weightAttribIndex == -1) {
            for (i = 0; i < a.length; ++i) {
                w[i] = 1.0;
            }
        } else {
            for (i = 0; i < a.length; ++i) {
                w[i] = a[i][weightAttribIndex] / (double)count;
            }
        }
        i = -1;
        for (AbstractDataStoreProcessor.AttributeData attrib : this.dsdb.getAttributes()) {
            int k;
            if (!attrib.isSelected()) continue;
            ++i;
            if (attrib.getAggregationType() == 2 && count > 1) {
                for (k = 0; k < a.length; ++k) {
                    double[] dArray = a[k];
                    int n = i;
                    dArray[n] = dArray[n] / (double)count;
                }
            }
            if (attrib.getWeightingType() == 3 && weightAttribIndex >= 0) {
                for (k = 0; k < a.length; ++k) {
                    double[] dArray = a[k];
                    int n = i;
                    dArray[n] = dArray[n] / w[k];
                }
                continue;
            }
            if (attrib.getWeightingType() != 2 || weightAttribIndex < 0) continue;
            for (k = 0; k < a.length; ++k) {
                double[] dArray = a[k];
                int n = i;
                dArray[n] = dArray[n] * w[k];
            }
        }
        return aggregate;
    }

    public synchronized DataMatrix getTemporalAggregate(Attribute.Calendar[] dates, int weightAttribIndex) throws SQLException, IOException {
        if (dates == null || dates.length == 0) {
            return null;
        }
        DataMatrix aggregate = null;
        int count = 0;
        int percent = 0;
        for (Attribute.Calendar date : dates) {
            int current;
            if (this.abortOperation) {
                return null;
            }
            DataMatrix matrix = this.getTemporalData(date);
            if (matrix != null) {
                if (aggregate == null) {
                    aggregate = matrix;
                    count = 1;
                } else {
                    aggregate = aggregate.plus(matrix);
                    ++count;
                }
            }
            if ((current = Math.round((float)count / (float)dates.length * 100.0f)) <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
        return this.getAggregate(aggregate, count, weightAttribIndex);
    }

    public synchronized DataMatrix getTemporalAggregate(String datePattern, int weightAttribIndex) throws SQLException, IOException {
        DataMatrix aggregate;
        long position;
        this.setTimeFilter(datePattern);
        ResultSet rs = this.getData();
        int max = this.getResultCount();
        int count = 1;
        int percent = 0;
        if (rs.next()) {
            position = rs.getLong("POSITION");
            aggregate = this.dsdb.getData(position);
        } else {
            return null;
        }
        while (rs.next()) {
            int current;
            if (this.abortOperation) {
                return null;
            }
            position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            aggregate = aggregate.plus(m);
            if ((current = Math.round(++count * 100 / max)) <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
        return this.getAggregate(aggregate, count, weightAttribIndex);
    }

    public synchronized DataMatrix getSpatialSum(long[] ids, int weightAttribIndex) throws SQLException, IOException {
        double[][] a;
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int attribCount = attributeIDs.length;
        int[] idPosition = new int[ids.length];
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<String> timeStamps = new ArrayList<String>();
        JAMSCalendar utcCal = new JAMSCalendar();
        int[] aggregationTypes = new int[this.dsdb.getAttributes().size()];
        int c = 0;
        for (AbstractDataStoreProcessor.AttributeData a2 : this.dsdb.getAttributes()) {
            aggregationTypes[c++] = a2.getAggregationType();
        }
        if (ids.length == 1) {
            for (AbstractDataStoreProcessor.AttributeData a2 : this.dsdb.getAttributes()) {
                a2.setAggregationType(1);
            }
        }
        if (weightAttribIndex >= attributeIDs.length) {
            Logger.getLogger(TimeSpaceProcessor.class.getName()).log(Level.INFO, "Area attribute does not exist!");
            return null;
        }
        this.resetTimeFilter();
        ResultSet rs = this.getData();
        if (rs.next()) {
            DataMatrix m = this.dsdb.getData(rs.getLong("POSITION"));
            a = new double[ids.length][];
            for (int i = 0; i < ids.length; ++i) {
                idPosition[i] = m.getIDPosition(String.valueOf(ids[i]));
                a[i] = m.getRow(idPosition[i]);
            }
        } else {
            return null;
        }
        double[][] weights = this.calcWeights(a, weightAttribIndex);
        data.add(this.getWeightedSum(a, weights));
        utcCal.setTimeInMillis(rs.getTimestamp(this.timeID, (Calendar)utcCal).getTime());
        timeStamps.add(utcCal.toString());
        int percent = 0;
        int max = this.dsdb.getContexts().get(1).getSize();
        float counter = 1.0f;
        while (rs.next()) {
            if (this.abortOperation) {
                return null;
            }
            DataMatrix m = this.dsdb.getData(rs.getLong("POSITION"));
            double[][] a3 = new double[ids.length][];
            for (int i = 0; i < ids.length; ++i) {
                a3[i] = m.getRow(idPosition[i]);
            }
            data.add(this.getWeightedSum(a3, weights));
            utcCal.setTimeInMillis(rs.getTimestamp(this.timeID, (Calendar)utcCal).getTime());
            timeStamps.add(utcCal.toString());
            int current = Math.round((counter += 1.0f) / (float)max * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
        double[][] dataArray = (double[][])data.toArray((T[])new double[data.size()][attribCount]);
        Object[] timeStampArray = timeStamps.toArray(new String[timeStamps.size()]);
        DataMatrix result = new DataMatrix(dataArray, timeStampArray, attributeIDs);
        c = 0;
        for (AbstractDataStoreProcessor.AttributeData a4 : this.dsdb.getAttributes()) {
            a4.setAggregationType(aggregationTypes[c++]);
        }
        return result;
    }

    public synchronized DataMatrix getSpatialSum() throws SQLException, IOException {
        DataMatrix result = null;
        if (!this.isSpatSumExisiting()) {
            return result;
        }
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int attribCount = attributeIDs.length;
        String q = "SELECT * FROM SPATSUM";
        ResultSet rs = this.customSelectQuery(q);
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<String> ids = new ArrayList<String>();
        while (rs.next()) {
            double[] rowdata = new double[attribCount];
            for (int i = 0; i < attribCount; ++i) {
                rowdata[i] = rs.getDouble(i + 2);
            }
            data.add(rowdata);
            ids.add(rs.getString(1));
        }
        double[][] dataArray = (double[][])data.toArray((T[])new double[data.size()][attribCount]);
        Object[] idArray = ids.toArray(new String[ids.size()]);
        result = new DataMatrix(dataArray, idArray, attributeIDs);
        return result;
    }

    public synchronized DataMatrix getTemporalMean() throws SQLException, IOException {
        return null;
    }

    public synchronized DataMatrix getMonthlyMean(int month) throws SQLException, IOException {
        return this.getTemporalAggregate("%-" + String.format("%02d", month) + "-%", -1);
    }

    public synchronized DataMatrix getYearlyMean(int year) throws SQLException, IOException {
        return this.getTemporalAggregate(String.format("%04d", year) + "%", -1);
    }

    public boolean isYearlyMeanExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_YEARAVG);
    }

    public boolean isMonthlyMeanExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_MONTHAVG);
    }

    public boolean isSpatSumExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_SPATSUM);
    }

    public synchronized void deleteCache() throws SQLException {
        String[] tables;
        for (String table : tables = new String[]{TABLE_NAME_YEARAVG, TABLE_NAME_SPATSUM, TABLE_NAME_MONTHAVG}) {
            this.customQuery("DROP TABLE IF EXISTS " + table);
        }
    }

    public synchronized void calcYearlyMean() throws SQLException, IOException {
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int numSelected = attributeIDs.length;
        this.customQuery("DROP TABLE IF EXISTS YEARAVG");
        String q = "CREATE TABLE YEARAVG (";
        q = q + "YEAR " + DataStoreProcessor.TYPE_MAP.get("JAMSInteger") + ",";
        q = q + this.spaceID + " " + DataStoreProcessor.TYPE_MAP.get("JAMSLong") + ",";
        for (int i = 1; i <= numSelected; ++i) {
            q = q + "a_" + i + " " + DataStoreProcessor.TYPE_MAP.get("JAMSDouble") + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.customQuery(q);
        q = "SELECT min(" + this.timeID + ") AS MINDATE, max(" + this.timeID + ") AS MAXDATE FROM index";
        ResultSet rs = this.customSelectQuery(q);
        rs.next();
        Attribute.Calendar minDate = DefaultDataFactory.getDataFactory().createCalendar();
        Attribute.Calendar maxDate = DefaultDataFactory.getDataFactory().createCalendar();
        minDate.setValue(rs.getTimestamp("MINDATE").toString());
        maxDate.setValue(rs.getTimestamp("MAXDATE").toString());
        int percent = 0;
        int max = maxDate.get(1) - minDate.get(1) + 1;
        float counter = 0.0f;
        for (int i = minDate.get(1); i <= maxDate.get(1); ++i) {
            String filterString = String.format("%04d", i) + "-%-%";
            this.calcTemporalMean(filterString, TABLE_NAME_YEARAVG, String.valueOf(i));
            if (this.abortOperation) {
                this.customQuery("DROP TABLE IF EXISTS YEARAVG");
                return;
            }
            int current = Math.round((counter += 1.0f) / (float)max * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
    }

    public synchronized int[] getYears() throws SQLException {
        String q = "SELECT min(" + this.timeID + ") AS MINDATE, max(" + this.timeID + ") AS MAXDATE FROM index";
        ResultSet rs = this.customSelectQuery(q);
        rs.next();
        Attribute.Calendar minDate = DefaultDataFactory.getDataFactory().createCalendar();
        Attribute.Calendar maxDate = DefaultDataFactory.getDataFactory().createCalendar();
        minDate.setValue(rs.getTimestamp("MINDATE").toString());
        maxDate.setValue(rs.getTimestamp("MAXDATE").toString());
        int startYear = minDate.get(1);
        int endYear = maxDate.get(1);
        int[] years = new int[endYear - startYear + 1];
        int c = 0;
        int i = startYear;
        while (i <= endYear) {
            years[c++] = i++;
        }
        return years;
    }

    public synchronized void calcMonthlyMean() throws SQLException, IOException {
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int numSelected = attributeIDs.length;
        this.customQuery("DROP TABLE IF EXISTS MONTHAVG");
        String q = "CREATE TABLE MONTHAVG (";
        q = q + "MONTH " + DataStoreProcessor.TYPE_MAP.get("JAMSInteger") + ",";
        q = q + this.spaceID + " " + DataStoreProcessor.TYPE_MAP.get("JAMSLong") + ",";
        for (int i = 1; i <= numSelected; ++i) {
            q = q + "a_" + i + " " + DataStoreProcessor.TYPE_MAP.get("JAMSDouble") + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.customQuery(q);
        int percent = 0;
        for (int i = 1; i <= 12; ++i) {
            String filterString = "%-" + String.format("%02d", i) + "-%";
            this.calcTemporalMean(filterString, TABLE_NAME_MONTHAVG, String.valueOf(i));
            if (this.abortOperation) {
                this.customQuery("DROP TABLE IF EXISTS MONTHAVG");
                return;
            }
            int current = Math.round((float)i / 12.0f * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
    }

    private synchronized DataMatrix calcTemporalMean(String filter, String tableName, String id) throws SQLException, IOException {
        DataMatrix aggregate;
        long position;
        this.setTimeFilter(filter);
        ResultSet rs = this.getData();
        int count = 1;
        if (rs.next()) {
            position = rs.getLong("POSITION");
            aggregate = this.dsdb.getData(position);
        } else {
            return null;
        }
        while (rs.next()) {
            if (this.abortOperation) {
                return null;
            }
            position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            aggregate = aggregate.plus(m);
            ++count;
        }
        aggregate = aggregate.times(1.0 / (double)count);
        Object[] ids = aggregate.getIds();
        double[][] data = aggregate.getArray();
        for (int i = 0; i < data.length; ++i) {
            String q = "INSERT INTO " + tableName + " VALUES (" + id + ", " + ids[i];
            for (int j = 0; j < data[i].length; ++j) {
                q = q + ", " + data[i][j];
            }
            q = q + ")";
            this.customQuery(q);
        }
        return aggregate;
    }

    public synchronized DataMatrix calcSpatialSum() throws SQLException, IOException {
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int attribCount = attributeIDs.length;
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<String> timeStamps = new ArrayList<String>();
        JAMSCalendar utcCal = new JAMSCalendar();
        this.customQuery("DROP TABLE IF EXISTS SPATSUM");
        String q = "CREATE TABLE SPATSUM (";
        q = q + this.timeID + " " + DataStoreProcessor.TYPE_MAP.get("JAMSCalendar") + ",";
        for (int i = 1; i <= attribCount; ++i) {
            q = q + "a_" + i + " " + DataStoreProcessor.TYPE_MAP.get("JAMSDouble") + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.customQuery(q);
        this.resetTimeFilter();
        ResultSet rs = this.getData();
        int percent = 0;
        int max = this.dsdb.getContexts().get(1).getSize();
        float counter = 0.0f;
        while (rs.next()) {
            long position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            data.add(m.getSumRow());
            utcCal.setTimeInMillis(rs.getTimestamp(this.timeID, (Calendar)utcCal).getTime());
            timeStamps.add(utcCal.toString());
            if (this.abortOperation) {
                this.customQuery("DROP TABLE IF EXISTS SPATSUM");
                return null;
            }
            int current = Math.round((counter += 1.0f) / (float)max * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
        double[][] dataArray = (double[][])data.toArray((T[])new double[data.size()][attribCount]);
        Object[] timeStampArray = timeStamps.toArray(new String[timeStamps.size()]);
        for (int i = 0; i < dataArray.length; ++i) {
            q = "INSERT INTO SPATSUM VALUES ('" + (String)timeStampArray[i] + "'";
            for (int j = 0; j < dataArray[i].length; ++j) {
                q = q + ", " + dataArray[i][j];
            }
            q = q + ")";
            this.customQuery(q);
        }
        DataMatrix result = new DataMatrix(dataArray, timeStampArray, attributeIDs);
        return result;
    }

    public synchronized Long[] getEntityIDs() throws SQLException, IOException {
        Object[] ids = null;
        ResultSet rs = this.customSelectQuery("SELECT * FROM index LIMIT 1");
        if (rs.next()) {
            long position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            ids = m.getIds();
        }
        if (ids == null) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object o : ids) {
            result.add(Long.parseLong(o.toString()));
        }
        Collections.sort(result);
        return result.toArray(new Long[result.size()]);
    }

    public synchronized JAMSCalendar[] getTimeSteps() throws SQLException {
        ArrayList<JAMSCalendar> result = new ArrayList<JAMSCalendar>();
        ResultSet rs = this.customSelectQuery("SELECT * FROM index");
        while (rs.next()) {
            JAMSCalendar utcCal = new JAMSCalendar();
            utcCal.setTimeInMillis(rs.getTimestamp(this.timeID, (Calendar)utcCal).getTime());
            result.add(utcCal);
        }
        return result.toArray(new JAMSCalendar[result.size()]);
    }

    public synchronized void setTimeFilter(String timeFilter) {
        this.timeFilter = timeFilter;
    }

    public synchronized void resetTimeFilter() {
        this.timeFilter = null;
    }

    public static void main(String[] args) throws Exception {
        TimeSpaceProcessor tsproc = new TimeSpaceProcessor(new File("D:/jamsapplication/JAMS-Gehlberg/output/current/ATestData.dat"));
        tsproc.dsdb.isTimeSpaceDatastore();
        ArrayList<AbstractDataStoreProcessor.AttributeData> attribs = tsproc.getDataStoreProcessor().getAttributes();
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            if (!attrib.getName().startsWith("act")) {
                attrib.setSelected(true);
                System.out.print(attrib.getName() + " ");
                continue;
            }
            attrib.setSelected(false);
        }
        System.out.println();
        tsproc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.println("Progress: " + arg);
            }
        });
        int c = 4;
        DataMatrix m = null;
        switch (c) {
            case 0: {
                tsproc.calcMonthlyMean();
                m = tsproc.getMonthlyMean(12);
                break;
            }
            case 1: {
                m = tsproc.getYearlyMean(1997);
                break;
            }
            case 2: {
                m = tsproc.getTemporalMean();
                break;
            }
            case 3: {
                tsproc.calcSpatialSum();
                m = tsproc.getSpatialSum();
                break;
            }
            case 4: {
                long[] ids = new long[]{1L};
                m = tsproc.getSpatialSum(ids, 0);
                break;
            }
            case 5: {
                Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                cal.setValue("2000-10-31 07:30");
                m = tsproc.getTemporalData(cal);
                break;
            }
            case 6: {
                m = tsproc.getTemporalAggregate("2%-10-30 07:30%", -1);
                break;
            }
            case 7: {
                Attribute.Calendar[] dates = new Attribute.Calendar[2];
                dates[0] = DefaultDataFactory.getDataFactory().createCalendar();
                dates[0].setValue("2000-10-31 07:30");
                dates[1] = DefaultDataFactory.getDataFactory().createCalendar();
                dates[1].setValue("2000-10-30 07:30");
                m = tsproc.getTemporalAggregate(dates, -1);
                break;
            }
            case 8: {
                Attribute.Calendar[] dates;
                for (Attribute.Calendar date : dates = tsproc.getTimeSteps()) {
                    System.out.println(date);
                }
                break;
            }
        }
        if (m == null) {
            return;
        }
        for (Object o : m.getIds()) {
            System.out.print(o + " ");
        }
        System.out.println();
        m.print(5, 3);
        tsproc.dsdb.close();
    }
}

