/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.Processor;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleSerieProcessor
extends Processor {
    private String contextID;
    private String ensembleFilter = null;
    private boolean timeSerie = false;

    public SimpleSerieProcessor(File file) {
        this(new DataStoreProcessor(file));
        this.timeSerie = this.dsdb.isSimpleTimeSerieDatastore();
    }

    public boolean isEmpty() {
        return this.dsdb.getSize() <= 1;
    }

    public boolean isTimeSerie() {
        return this.timeSerie;
    }

    public synchronized Attribute.Calendar[] getTimeSteps() throws SQLException, IOException {
        if (!this.isTimeSerie()) {
            return null;
        }
        String[] ids = this.getIDs();
        Attribute.Calendar[] steps = new Attribute.Calendar[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Attribute.Calendar calendar = DefaultDataFactory.getDataFactory().createCalendar();
            calendar.setValue(ids[i]);
            steps[i] = calendar;
        }
        return steps;
    }

    public int getTimeUnit() throws SQLException, IOException {
        Attribute.Calendar[] timeSteps = this.getTimeSteps();
        if (timeSteps == null) {
            return -1;
        }
        Attribute.Calendar t0 = timeSteps[0];
        Attribute.Calendar tn = timeSteps[timeSteps.length - 1];
        int n = timeSteps.length;
        long diff = (tn.getTimeInMillis() - t0.getTimeInMillis()) / (long)n / 1000L;
        if (0L <= diff && diff < 30L) {
            return 13;
        }
        if (30L <= diff && diff < 1800L) {
            return 12;
        }
        if (1800L <= diff && diff < 43200L) {
            return 10;
        }
        if (43200L <= diff && diff < 1296000L) {
            return 6;
        }
        if (1296000L <= diff && diff < 3456000L) {
            return 2;
        }
        return 1;
    }

    public SimpleSerieProcessor(AbstractDataStoreProcessor dsdb) {
        this.dsdb = dsdb;
        this.contexts = dsdb.getContexts();
        if (dsdb.isSimpleDataSerieDatastore() || dsdb.isSimpleTimeSerieDatastore()) {
            try {
                this.conn = dsdb.getH2Connection(true);
            }
            catch (SQLException ex) {
                Logger.getLogger(SimpleSerieProcessor.class.getName()).log(Level.INFO, "Error while creating connection to H2 database of {0}", dsdb.getFile());
                Logger.getLogger(SimpleSerieProcessor.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.timeSerie = this.dsdb.isSimpleTimeSerieDatastore();
    }

    public synchronized DataMatrix getMean(String[] ids) throws SQLException, IOException {
        DataMatrix result = null;
        if (ids.length == 0) {
            return null;
        }
        DataMatrix rs = this.dsdb.getData(this.dsdb.getStartPosition());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        Object[] obj = rs.getIds();
        int n = rs.getColumnDimension();
        double[][] aggregate = new double[1][n];
        for (int i = 0; i < obj.length; ++i) {
            if (!set.contains(obj[i].toString())) continue;
            for (int j = 0; j < n; ++j) {
                double[] dArray = aggregate[0];
                int n2 = j;
                dArray[n2] = dArray[n2] + rs.getRow(i)[j];
            }
        }
        Object[] id = new Long[]{1L};
        result = new DataMatrix(aggregate, id, rs.getAttributeIDs());
        return result.times(1.0 / (double)ids.length);
    }

    public synchronized DataMatrix getData(String[] ids) throws SQLException, IOException {
        DataMatrix result = null;
        if (ids.length == 0) {
            return null;
        }
        DataMatrix rs = this.dsdb.getData(this.dsdb.getStartPosition());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        Object[] obj = rs.getIds();
        int n = rs.getColumnDimension();
        double[][] aggregate = new double[ids.length][n];
        int count = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (!set.contains(obj[i].toString())) continue;
            for (int j = 0; j < n; ++j) {
                double[] dArray = aggregate[count];
                int n2 = j;
                dArray[n2] = dArray[n2] + rs.getRow(i)[j];
            }
            ++count;
        }
        result = new DataMatrix(aggregate, (Object[])ids, rs.getAttributeIDs());
        return result;
    }

    public synchronized DataMatrix getMean() throws SQLException, IOException {
        return this.getMean(this.getIDs());
    }

    public synchronized String[] getIDs() throws SQLException, IOException {
        DataMatrix rs = this.dsdb.getData(this.dsdb.getStartPosition());
        Object[] objIDs = rs.getIds();
        String[] ids = new String[objIDs.length];
        for (int i = 0; i < objIDs.length; ++i) {
            ids[i] = objIDs[i].toString();
        }
        return ids;
    }

    public synchronized void setFilter(String ensembleFilter) {
        this.ensembleFilter = ensembleFilter;
    }

    public synchronized void resetEnsembleFilter() {
        this.ensembleFilter = null;
    }

    public synchronized DataMatrix calcTemporalMean(String filter) throws SQLException, IOException {
        if (!this.isTimeSerie()) {
            return null;
        }
        DataMatrix rs = this.dsdb.getData(this.dsdb.getStartPosition());
        int count = 0;
        Object[] obj = rs.getIds();
        int n = rs.getColumnDimension();
        double[][] aggregate = new double[1][n];
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].toString().matches(filter)) continue;
            for (int j = 0; j < n; ++j) {
                double[] dArray = aggregate[0];
                int n2 = j;
                dArray[n2] = dArray[n2] + rs.getRow(i)[j];
            }
            ++count;
        }
        Object[] id = new Long[]{1L};
        DataMatrix result = new DataMatrix(aggregate, id, rs.getAttributeIDs());
        return result.times(1.0 / (double)count);
    }

    public synchronized int[] getYears() throws SQLException, IOException {
        if (!this.isTimeSerie()) {
            return new int[0];
        }
        DataMatrix rs = this.dsdb.getData(this.dsdb.getStartPosition());
        Attribute.Calendar minDate = DefaultDataFactory.getDataFactory().createCalendar();
        Attribute.Calendar maxDate = DefaultDataFactory.getDataFactory().createCalendar();
        minDate.setValue(rs.getIds()[0].toString());
        maxDate.setValue(rs.getIds()[rs.getIds().length - 1].toString());
        int startYear = minDate.get(1);
        int endYear = maxDate.get(1);
        int[] years = new int[endYear - startYear + 1];
        int c = 0;
        int i = startYear;
        while (i <= endYear) {
            years[c++] = i++;
        }
        return years;
    }

    public synchronized DataMatrix getYearlyMean(int year) throws SQLException, IOException {
        if (!this.isTimeSerie()) {
            return null;
        }
        String filterString = String.format("%04d", year) + "-.*";
        DataMatrix yearMean = this.calcTemporalMean(filterString);
        return yearMean;
    }

    public synchronized DataMatrix getMonthlyMean(int month) throws SQLException, IOException {
        if (!this.isTimeSerie()) {
            return null;
        }
        String filterString = ".*-" + String.format("%02d", month) + "-.*";
        DataMatrix yearMean = this.calcTemporalMean(filterString);
        return yearMean;
    }
}

