/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.JAMS;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.TimeZone;
import oms3.io.CSTable;
import oms3.io.DataIO;

public class DataStoreProcessorOMS
extends AbstractDataStoreProcessor {
    ArrayList<AbstractDataStoreProcessor.AttributeData> attributes = new ArrayList();
    private AbstractDataStoreProcessor.ImportProgressObservable importProgressObservable = new AbstractDataStoreProcessor.ImportProgressObservable();
    ArrayList<String[]> data = null;
    File f = null;
    CSTable table = null;
    private int tableID = 0;
    ArrayList<AbstractDataStoreProcessor> dsList = null;
    boolean hasSubDataStores = false;

    public DataStoreProcessorOMS(File f) {
        this(f, 0);
        this.collectSubDataStores();
        this.hasSubDataStores = !this.dsList.isEmpty();
    }

    private DataStoreProcessorOMS(File f, int tableID) {
        super(f);
        this.f = f;
        try {
            List tables = DataIO.tables((File)f);
            if (tables.isEmpty()) {
                throw new IOException("File " + f.getAbsolutePath() + " contains no tables");
            }
            String tableName = (String)tables.get(tableID);
            System.out.println("Loading table " + tableName);
            this.table = DataIO.table((File)f, (String)tableName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String dateFormat = (String)this.table.getInfo().get("date_format");
        if (dateFormat == null) {
            dateFormat = "yyyy MM dd HH mm ss";
        }
        for (int i = 1; i <= this.table.getColumnCount(); ++i) {
            String colName = this.table.getColumnName(i);
            String jamsType = "JAMSDouble";
            String omsType = (String)this.table.getColumnInfo(i).get("Type");
            if (omsType != null) {
                jamsType = omsType.equals("Date") ? "JAMSCalendar" : "JAMSDouble";
            }
            AbstractDataStoreProcessor.AttributeData a = new AbstractDataStoreProcessor.AttributeData(jamsType, colName);
            this.attributes.add(a);
        }
        this.data = new ArrayList();
        SimpleDateFormat sdf_in = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdf_out = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf_in.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf_out.setTimeZone(TimeZone.getTimeZone("GMT"));
        for (String[] value : this.table.rows()) {
            String[] row = new String[value.length - 1];
            for (int i = 0; i < this.attributes.size(); ++i) {
                if (this.attributes.get(i).getType().equals("JAMSCalendar")) {
                    try {
                        row[i] = sdf_out.format(sdf_in.parse(value[i + 1]));
                    }
                    catch (ParseException pe) {
                        row[i] = value[i + 1];
                    }
                    continue;
                }
                row[i] = value[i + 1];
            }
            this.data.add(row);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            List tables = DataIO.tables((File)this.f);
            return tables.isEmpty();
        }
        catch (IOException ioe) {
            return true;
        }
    }

    public static AbstractDataStoreProcessor.DataStoreType getDataStoreType(File file) {
        try {
            List tables = DataIO.tables((File)file);
            if (tables.isEmpty()) {
                return AbstractDataStoreProcessor.DataStoreType.Unsupported;
            }
            CSTable table = DataIO.table((File)file, (String)((String)tables.get(0)));
            if (table.getColumnCount() <= 1) {
                return AbstractDataStoreProcessor.DataStoreType.Unsupported;
            }
            String type = (String)table.getColumnInfo(1).get("Type");
            if (type == null) {
                type = (String)table.getColumnInfo(1).get("type");
            }
            if (type != null && type.equals("Date")) {
                return AbstractDataStoreProcessor.DataStoreType.Timeserie;
            }
            return AbstractDataStoreProcessor.DataStoreType.DataSerie1D;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return AbstractDataStoreProcessor.DataStoreType.Unsupported;
        }
    }

    @Override
    public void createDB() throws IOException, SQLException, ClassNotFoundException {
    }

    @Override
    public void clearDB() throws SQLException {
    }

    @Override
    public void removeDBFiles() {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean existsH2DB() throws SQLException {
        return true;
    }

    @Override
    public boolean isDBObsolete() {
        return false;
    }

    @Override
    public boolean existsH2DBFiles() {
        return true;
    }

    @Override
    public Connection getH2Connection(boolean checkForDB) throws SQLException {
        return null;
    }

    @Override
    public void cancelCreateIndex() {
    }

    @Override
    public boolean fillBlock(long position) throws IOException, SQLException {
        return true;
    }

    @Override
    public boolean isTimeSpaceDatastore() {
        return false;
    }

    @Override
    public boolean isEnsembleTimeSeriesDatastore() {
        return false;
    }

    @Override
    public boolean isSimpleTimeSerieDatastore() {
        return this.attributes.get(0).getType().equals("JAMSCalendar");
    }

    @Override
    public boolean isSimpleDataSerieDatastore() {
        return this.attributes.get(0).getType().equals("JAMSLong");
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.ContextData> getContexts() {
        ArrayList<AbstractDataStoreProcessor.ContextData> context = new ArrayList<AbstractDataStoreProcessor.ContextData>();
        context.add(new AbstractDataStoreProcessor.ContextData("omsContext", "omsContext", Integer.toString(this.data.size()), this.attributes.get(0).getType()));
        return context;
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.FilterData> getFilters() {
        return new ArrayList<AbstractDataStoreProcessor.FilterData>();
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.AttributeData> getAttributes() {
        return this.attributes;
    }

    @Override
    public File getFile() {
        return this.f;
    }

    @Override
    public void addImportProgressObserver(Observer o) {
        this.importProgressObservable.addObserver(o);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public long getStartPosition() throws IOException {
        return 0L;
    }

    @Override
    public DataMatrix getData(long position) throws IOException {
        int numSelected = 0;
        boolean[] selected = new boolean[this.attributes.size()];
        ArrayList<String> attributeNames = new ArrayList<String>();
        int i = 0;
        for (AbstractDataStoreProcessor.AttributeData a : this.attributes) {
            if (a.isSelected() && a.getType().equals("JAMSDouble")) {
                selected[i] = true;
                attributeNames.add(a.getName());
                ++numSelected;
            } else {
                selected[i] = false;
            }
            ++i;
        }
        ArrayList<double[]> rows = new ArrayList<double[]>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int k = (int)position; k < this.data.size(); ++k) {
            double[] cols = new double[numSelected];
            idList.add(this.data.get(k)[0]);
            int j = 0;
            for (i = 0; i < this.attributes.size(); ++i) {
                if (!selected[i]) continue;
                cols[j] = Double.parseDouble(this.data.get(k)[i]);
                if (cols[j] == JAMS.getMissingDataValue()) {
                    cols[j] = Double.NaN;
                }
                ++j;
            }
            rows.add(cols);
        }
        double[][] data = (double[][])rows.toArray((T[])new double[rows.size()][numSelected]);
        Object[] ids = idList.toArray(new String[idList.size()]);
        return new DataMatrix(data, ids, attributeNames.toArray(new String[attributeNames.size()]));
    }

    @Override
    public String[] getSelectedDoubleAttribs() {
        ArrayList<String> attribs = new ArrayList<String>();
        for (AbstractDataStoreProcessor.AttributeData a : this.getAttributes()) {
            if (!a.isSelected() || !a.getType().equals("JAMSDouble")) continue;
            attribs.add(a.getName());
        }
        return attribs.toArray(new String[attribs.size()]);
    }

    private void collectSubDataStores() {
        this.dsList = new ArrayList();
        try {
            List tables = DataIO.tables((File)this.f);
            if (tables.isEmpty()) {
                throw new IOException("File " + this.f.getAbsolutePath() + " contains no tables");
            }
            for (String s : tables) {
                CSTable table = DataIO.table((File)this.f, (String)s);
                this.dsList.add(new DataStoreProcessorOMS(this.f, this.tableID++));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public AbstractDataStoreProcessor[] getSubDataStores() {
        return this.dsList.toArray(new AbstractDataStoreProcessor[0]);
    }

    public String toString() {
        if (this.hasSubDataStores) {
            return this.f.getName();
        }
        return this.f.getName() + ":" + this.table.getName();
    }
}

