/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import jams.JAMS;
import jams.JAMSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLTools {
    public static Document getDocument(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new JAMSException(JAMS.i18n("File_") + fileName + JAMS.i18n("_does_not_exist!"), JAMS.i18n("File_open_error"));
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        }
        catch (SAXException sxe) {
            throw new JAMSException(sxe.getMessage(), (Throwable)sxe);
        }
        catch (ParserConfigurationException pce) {
            throw new JAMSException(pce.getMessage(), (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new JAMSException(ioe.getMessage(), (Throwable)ioe);
        }
        return document;
    }

    public static Document getDocumentFromString(String docString) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream source = new ByteArrayInputStream(docString.getBytes(JAMS.getCharset()));
            document = builder.parse(source);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return document;
    }

    public static Document createDocument() {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        return document;
    }

    public static String getStringFromDocument(Document doc) {
        if (doc == null) {
            return "";
        }
        return XMLTools.xmlSerializerSun(doc);
    }

    public static String getStringFromNode(Node doc) {
        if (doc == null) {
            return "";
        }
        return XMLTools.xmlSerializerSun(doc);
    }

    private static String xmlSerializerSun(Node doc) {
        String returnValue = "";
        try {
            Transformer transformer = XMLTools.getTransformer(true);
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            returnValue = writer.toString();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return returnValue;
    }

    public static boolean writeXmlFile(Document modelDoc, String filename) throws IOException {
        return XMLTools.writeXmlFile(modelDoc, new File(filename));
    }

    public static boolean writeXmlFile(Document doc, File savePath) throws IOException {
        if (!savePath.exists()) {
            savePath.createNewFile();
        }
        if (savePath.canWrite()) {
            try {
                Transformer transformer = XMLTools.getTransformer(false);
                DOMSource source = new DOMSource(doc);
                FileOutputStream os = new FileOutputStream(savePath);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                os.close();
            }
            catch (TransformerConfigurationException tce) {
                return false;
            }
            catch (TransformerException te) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static InputStream writeXmlToStream(Document doc) throws IOException {
        try {
            Transformer transformer = XMLTools.getTransformer(false);
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.close();
            byte[] buffer = os.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            return in;
        }
        catch (TransformerConfigurationException tce) {
            return null;
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public static InputStream propertiesToStream(Properties p) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        p.store(output, null);
        return new ByteArrayInputStream(output.toByteArray());
    }

    private static Transformer getTransformer(boolean omitXML) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("omit-xml-declaration", omitXML ? "yes" : "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("encoding", JAMS.getCharset());
        transformer.setOutputProperty("omit-xml-declaration", "no");
        if (omitXML) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("standalone", "yes");
        }
        transformer.setOutputProperty("encoding", JAMS.getCharset());
        return transformer;
    }
}

