/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public class RuntimeLogger
extends Observable
implements Serializable {
    StringBuffer logString = new StringBuffer();
    String lastString;
    int bufferSize = 320000000;

    public void setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
        this.trimBuffer();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void trimBuffer() {
        if (this.bufferSize != -1 && this.bufferSize < this.logString.length()) {
            this.logString.delete(0, this.logString.length() - this.bufferSize);
        }
    }

    public String getLogString() {
        return this.logString.toString();
    }

    public String toString() {
        return this.getLogString();
    }

    public String getLastString() {
        return this.lastString;
    }

    public void print(String str) {
        this.lastString = str;
        this.logString.append(str);
        this.trimBuffer();
        this.setChanged();
        this.notifyObservers(str);
    }

    public void println(String str) {
        this.print(str + "\n");
    }

    public void print(char c) {
        this.logString.append(c);
        this.setChanged();
        this.notifyObservers(Character.valueOf(c));
    }

    @Override
    public void addObserver(Observer o) {
        this.deleteObserver(o);
        super.addObserver(o);
    }
}

