/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import jams.JAMS;
import jams.runtime.RuntimeLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class JAMSClassLoader
extends URLClassLoader {
    private URL[] urls;

    public JAMSClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.urls = urls;
    }

    public JAMSClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.loadClass(name, true);
        return clazz;
    }

    public Class load(String name, byte[] data) {
        return this.defineClass(name, data, 0, data.length);
    }

    private static void addFile(Set<URL> urls, File f, RuntimeLogger logger) {
        try {
            URL url = f.toURI().toURL();
            if (!urls.add(url)) {
                logger.println(JAMS.i18n("WARNING_:_The_file_") + f.getAbsolutePath() + JAMS.i18n("_is_already_loaded"));
            }
        }
        catch (MalformedURLException murle) {
            logger.println(JAMS.i18n("WARNING_:_The_file_") + f.getAbsolutePath() + JAMS.i18n("_could_not_be_converted_to_URL."));
        }
    }

    public static ClassLoader createClassLoader(String[] libs, RuntimeLogger log) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String lib : libs) {
            File dir = new File(lib);
            if (!dir.isAbsolute()) {
                dir = dir.getAbsoluteFile();
            }
            if (!dir.exists()) {
                log.println(JAMS.i18n("DANGER_-_directory_") + dir.getAbsolutePath() + JAMS.i18n("_does_not_exist"));
                continue;
            }
            if (dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    JAMSClassLoader.addFile(urls, file, log);
                }
                continue;
            }
            JAMSClassLoader.addFile(urls, dir, log);
        }
        log.println(JAMS.i18n("created_class_loader_using_"));
        for (URL url : urls) {
            log.println("\t" + url.toString());
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        JAMSClassLoader cl = new JAMSClassLoader(urlArray);
        return cl;
    }
}

