/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.data.Attribute;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.tools.JAMSTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GenericDataReader
implements JAMSTableDataStore,
Serializable {
    BufferedReader reader;
    String fileName;
    boolean timeParse;
    String nextString = "";
    boolean active = false;
    private String[] metadata;
    private JAMSTableDataArray current = null;
    private String delimiters = "\t";
    private String endString = "#end";
    private String metadataID = "#";

    public GenericDataReader(String fileName, boolean timeParse, int startMeta, int startData) {
        this.fileName = fileName;
        this.timeParse = timeParse;
        this.createReader();
        if (startMeta > 0 && startData > startMeta) {
            this.parseMetadata(startMeta, startData);
        } else {
            this.parseMetadata();
        }
    }

    public GenericDataReader(String fileName, boolean timeParse, int startData) {
        this.fileName = fileName;
        this.timeParse = timeParse;
        this.createReader();
        for (int i = 0; i < startData; ++i) {
            this.active = false;
            this.update();
        }
    }

    public GenericDataReader(String fileName, boolean timeParse) {
        this(fileName, timeParse, 0, 0);
    }

    private void createReader() {
        try {
            this.reader = new BufferedReader(new FileReader(new File(this.fileName)));
        }
        catch (IOException ioe) {
            JAMSTools.handle(ioe);
        }
    }

    public void parseMetadata() {
        String hold = "";
        this.update();
        while (this.nextString.startsWith(this.metadataID)) {
            this.active = false;
            hold = this.nextString;
            this.update();
        }
        StringTokenizer st = new StringTokenizer(hold.substring(1), this.delimiters);
        if (this.timeParse) {
            st.nextToken();
        }
        int n = st.countTokens();
        String[] metadata = new String[n];
        for (int i = 0; i < n; ++i) {
            metadata[i] = st.nextToken();
        }
        this.metadata = metadata;
    }

    private void parseMetadata(int startMeta, int startData) {
        int i;
        for (int i2 = 0; i2 < startMeta; ++i2) {
            this.active = false;
            this.update();
        }
        StringTokenizer st = new StringTokenizer(this.nextString, this.delimiters);
        if (this.timeParse) {
            st.nextToken();
        }
        int n = st.countTokens();
        String[] metadata = new String[n];
        for (i = 0; i < n; ++i) {
            metadata[i] = st.nextToken();
        }
        this.metadata = metadata;
        for (i = startMeta; i < startData; ++i) {
            this.active = false;
            this.update();
        }
    }

    private void update() {
        if (!this.active) {
            try {
                this.nextString = this.reader.readLine();
            }
            catch (IOException ioex) {
                JAMSTools.handle(ioex);
            }
            this.active = true;
        }
    }

    @Override
    public JAMSTableDataArray getCurrent() {
        return this.current;
    }

    @Override
    public JAMSTableDataArray getNext() {
        Attribute.Calendar time;
        this.update();
        this.active = false;
        StringTokenizer st = new StringTokenizer(this.nextString, this.delimiters);
        if (this.timeParse) {
            String timeString = st.nextToken();
            try {
                time = JAMSTableDataConverter.parseTime(timeString);
            }
            catch (Throwable t) {
                timeString = timeString + " " + st.nextToken();
                time = JAMSTableDataConverter.parseTime(timeString);
            }
        } else {
            time = null;
        }
        int n = st.countTokens();
        String[] values = new String[n];
        for (int i = 0; i < n; ++i) {
            values[i] = st.nextToken();
        }
        this.current = new JAMSTableDataArray(time, values);
        return this.current;
    }

    public ArrayList<JAMSTableDataArray> getAll() {
        ArrayList<JAMSTableDataArray> array = new ArrayList<JAMSTableDataArray>();
        while (this.hasNext()) {
            array.add(this.getNext());
        }
        return array;
    }

    @Override
    public boolean hasNext() {
        this.update();
        return this.nextString != null && !this.nextString.startsWith(this.endString);
    }

    @Override
    public String[] getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            JAMSTools.handle(ioe);
        }
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.endString = endString;
    }

    public String getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(String metadataID) {
        this.metadataID = metadataID;
    }
}

