/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import jams.data.Attribute;
import jams.data.JAMSCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAMSTimeInterval
implements Attribute.TimeInterval {
    protected Attribute.Calendar start = new JAMSCalendar();
    protected Attribute.Calendar end = new JAMSCalendar();
    protected int timeUnit = 6;
    protected int timeUnitCount = 1;
    private long timestepCount = -1L;

    public JAMSTimeInterval() {
    }

    public JAMSTimeInterval(Attribute.Calendar start, Attribute.Calendar end, int timeUnit, int timeUnitCount) {
        this.start = start;
        this.end = end;
        this.timeUnit = timeUnit;
        this.timeUnitCount = timeUnitCount;
    }

    public void setValue(String value) {
        try {
            StringTokenizer st = new StringTokenizer(value);
            String startDate = st.nextToken();
            String startTime = st.nextToken();
            String endDate = st.nextToken();
            String endTime = st.nextToken();
            String unit = st.nextToken();
            String count = st.nextToken();
            this.start.setValue(startDate + " " + startTime);
            this.end.setValue(endDate + " " + endTime);
            this.timeUnit = Integer.parseInt(unit);
            this.timeUnitCount = Integer.parseInt(count);
        }
        catch (NoSuchElementException nsee) {
            Logger.getLogger(JAMSTimeInterval.class.getName()).log(Level.WARNING, "Unable to parse time interval " + value, nsee);
        }
        catch (Exception e) {
            Logger.getLogger(JAMSTimeInterval.class.getName()).log(Level.WARNING, "Errror while setting time interval " + value, e);
        }
    }

    public boolean encloses(Attribute.TimeInterval ti) {
        return this.start.compareTo(ti.getStart()) <= 0 && this.end.compareTo(ti.getEnd()) >= 0;
    }

    public long getStartOffset(Attribute.TimeInterval ti) {
        if (!this.encloses(ti)) {
            return -1L;
        }
        JAMSTimeInterval tmp = new JAMSTimeInterval();
        tmp.setValue(this.getValue());
        JAMSCalendar start = new JAMSCalendar();
        start.setValue(this.start);
        JAMSCalendar end = new JAMSCalendar();
        end.setValue(ti.getStart());
        tmp.setStart(start);
        tmp.setEnd(end);
        long offset = tmp.getNumberOfTimesteps() - 1L;
        return offset;
    }

    public String getValue() {
        return this.start + " " + this.end + " " + this.timeUnit + " " + this.timeUnitCount;
    }

    public String toString() {
        return this.getValue();
    }

    public Attribute.Calendar getStart() {
        return this.start;
    }

    public void setStart(Attribute.Calendar start) {
        this.start = start;
        this.timestepCount = -1L;
    }

    public Attribute.Calendar getEnd() {
        return this.end;
    }

    public void setEnd(Attribute.Calendar end) {
        this.end = end;
        this.timestepCount = -1L;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
        this.timestepCount = -1L;
    }

    public int getTimeUnitCount() {
        return this.timeUnitCount;
    }

    public void setTimeUnitCount(int timeUnitCount) {
        this.timeUnitCount = timeUnitCount;
        this.timestepCount = -1L;
    }

    public boolean equals(Object obj) {
        return obj instanceof JAMSTimeInterval && (((JAMSTimeInterval)obj).start.compareTo(this.start, 12) == 0 || ((JAMSTimeInterval)obj).end.compareTo(this.end, 12) == 0);
    }

    public long getNumberOfTimesteps() {
        if (this.timestepCount < 0L) {
            this.timestepCount = this.timeUnit <= 2 ? this.getNumberOfTimestepsByIteration() : this.getNumberOfTimestepsByCalculation();
        }
        return this.timestepCount;
    }

    private long getNumberOfTimestepsByIteration() {
        Attribute.Calendar start = this.getStart().clone();
        Attribute.Calendar end = this.getEnd().clone();
        long count = 1L;
        start.add(this.timeUnit, this.timeUnitCount);
        while (!start.after(end)) {
            ++count;
            start.add(this.timeUnit, this.timeUnitCount);
        }
        return count;
    }

    private long getNumberOfTimestepsByCalculation() {
        Attribute.Calendar start = this.getStart().clone();
        Attribute.Calendar end = this.getEnd().clone();
        double milli1 = end.getTimeInMillis() - start.getTimeInMillis();
        double milli2 = 0.0;
        start.set(1970, 0, 1, 0, 0, 0);
        end.set(1970, 0, 1, 0, 0, 0);
        end.add(this.timeUnit, this.timeUnitCount);
        milli2 = end.getTimeInMillis() - start.getTimeInMillis();
        return (long)(milli1 / milli2) + 1L;
    }

    public static void main(String[] args) {
        JAMSTimeInterval ti = new JAMSTimeInterval();
        ti.setStart(new JAMSCalendar(0, 0, 1, 0, 0, 0));
        ti.setEnd(new JAMSCalendar(2018, 0, 1, 0, 0, 0));
        ti.setTimeUnit(13);
        ti.setTimeUnitCount(1);
        System.out.println(ti.getNumberOfTimesteps());
    }
}

