/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oms3.ComponentAccess;
import oms3.Compound;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;

public class Threads {
    private static ExecutorService es;

    public static void seq_e(CompList<?> t) {
        for (Compound c : t) {
            c.execute();
        }
    }

    public static void seq_ief(CompList<?> t) throws Exception {
        for (Compound c : t) {
            ComponentAccess.callAnnotated(c, Initialize.class, true);
            c.execute();
            ComponentAccess.callAnnotated(c, Finalize.class, true);
        }
    }

    public static void par_ief(CompList<?> t) throws Exception {
        Threads.par_ief(t, Runtime.getRuntime().availableProcessors() + 1);
    }

    private static synchronized ExecutorService getES() {
        if (es == null) {
            int nthreads = Runtime.getRuntime().availableProcessors() + 1;
            es = new ThreadPoolExecutor(nthreads, nthreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Threads.shutdownAndAwaitTermination(es);
                }
            });
        }
        return es;
    }

    private static void par_ief(CompList<?> t, int numproc) throws Exception {
        if (numproc < 1) {
            throw new IllegalArgumentException("numproc");
        }
        final CountDownLatch latch = new CountDownLatch(t.list().size());
        final ExecutorService es = Threads.getES();
        for (final Compound c : t) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ComponentAccess.callAnnotated(c, Initialize.class, true);
                        c.execute();
                        ComponentAccess.callAnnotated(c, Finalize.class, true);
                    }
                    catch (Throwable E) {
                        Threads.shutdownAndAwaitTermination(es);
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    public static void par_e(CompList<?> t) throws Exception {
        Threads.par_e(t, Runtime.getRuntime().availableProcessors() + 1);
    }

    public static void par_e(CompList<?> t, int numproc) throws Exception {
        if (numproc < 1) {
            throw new IllegalArgumentException("numproc");
        }
        final CountDownLatch latch = new CountDownLatch(t.list().size());
        final ExecutorService es = Threads.getES();
        for (final Compound c : t) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.execute();
                    }
                    catch (Throwable E) {
                        Threads.shutdownAndAwaitTermination(es);
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static abstract class CompList<T>
    implements Iterable<Compound> {
        List<T> list;
        public List<Compound> p;

        public CompList(List<T> list) {
            this.list = list;
        }

        public abstract Compound create(T var1);

        List<Compound> list() {
            if (this.p == null) {
                this.p = new ArrayList<Compound>();
                for (T el : this.list) {
                    this.p.add(this.create(el));
                }
            }
            return this.p;
        }

        @Override
        public Iterator<Compound> iterator() {
            return this.list().iterator();
        }
    }
}

