/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.util.EventListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.Controller;

public class Notification {
    EventListenerList ll = new EventListenerList();
    Controller c;
    boolean shouldFire = false;
    protected static final Logger log = Logger.getLogger("oms3.sim");

    Notification(Controller c) {
        this.c = c;
    }

    final boolean shouldFire() {
        return this.shouldFire;
    }

    Controller getController() {
        return this.c;
    }

    void addListener(Listener l) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Adding Notification Listener " + l);
        }
        this.ll.add(Listener.class, l);
        this.shouldFire = true;
    }

    void removeListener(Listener l) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Removing Notification Listener " + l);
        }
        this.ll.remove(Listener.class, l);
        this.shouldFire = this.ll.getListenerCount() > 0;
    }

    private void fire(Type t, EventObject E) {
        Object[] listeners = this.ll.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((Listener)listeners[i + 1]).notice(t, E);
        }
    }

    void fireWait(ComponentAccess w) {
        if (this.shouldFire) {
            this.fire(Type.WAITING, new ComponentEvent(this.c, w.getComponent()));
        }
    }

    void fireStart(ComponentAccess w) {
        if (this.shouldFire) {
            this.fire(Type.EXECUTING, new ComponentEvent(this.c, w.getComponent()));
        }
    }

    void fireFinnish(ComponentAccess w) {
        if (this.shouldFire) {
            this.fire(Type.FINISHED, new ComponentEvent(this.c, w.getComponent()));
        }
    }

    void fireException(ComponentException E) {
        if (this.shouldFire) {
            this.fire(Type.EXCEPTION, new ExceptionEvent(this.c, E));
        }
    }

    void fireIn(DataflowEvent e) {
        this.fire(Type.IN, e);
    }

    void fireOut(DataflowEvent e) {
        this.fire(Type.OUT, e);
    }

    public static class DataflowEvent
    extends EventObject {
        private static final long serialVersionUID = -5551146005283344251L;
        Access data;
        Object value;

        DataflowEvent(Object source, Access data, Object value) {
            super(source);
            this.data = data;
            this.value = value;
        }

        public Access getAccess() {
            return this.data;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "Flow: " + this.data.getComponent() + "@" + this.data.getField().getName() + " [" + this.value + "]";
        }
    }

    public static class ExceptionEvent
    extends EventObject {
        private static final long serialVersionUID = -1136021018405823527L;
        ComponentException E;

        ExceptionEvent(Object src, ComponentException E) {
            super(src);
            this.E = E;
        }

        public ComponentException getException() {
            return this.E;
        }

        @Override
        public String toString() {
            if (this.E == null) {
                return "Exception: NULL";
            }
            StringBuilder b = new StringBuilder("\n");
            if (this.E.getCause() != null) {
                for (StackTraceElement ste : this.E.getCause().getStackTrace()) {
                    b.append("  ").append(ste.toString()).append("\n");
                }
            }
            return "Exception: " + this.E.getMessage() + " in '" + this.E.getSource() + "'" + b.toString();
        }
    }

    public static class ComponentEvent
    extends EventObject {
        private static final long serialVersionUID = -8569599337868335893L;
        Object comp;

        ComponentEvent(Object src, Object comp) {
            super(src);
            this.comp = comp;
        }

        public Object getComponent() {
            return this.comp;
        }

        @Override
        public String toString() {
            return "Component: " + this.getComponent();
        }
    }

    public static class ConnectEvent
    extends EventObject {
        private static final long serialVersionUID = 1410979580285808419L;
        Access from;
        Access to;

        ConnectEvent(Object src, Access from, Access to) {
            super(src);
            this.from = from;
            this.to = to;
        }

        public Access getFrom() {
            return this.from;
        }

        public Access getTo() {
            return this.to;
        }

        @Override
        public String toString() {
            return "Connect: " + this.from + " -> " + this.to;
        }
    }

    public static interface Listener
    extends EventListener {
        public void notice(Type var1, EventObject var2);
    }

    public static enum Type {
        WAITING,
        EXECUTING,
        FINISHED,
        IN,
        OUT,
        EXCEPTION;

    }
}

