/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Rank1Lattice
extends PointSet {
    protected int[] genAs;
    protected double[] v;
    protected double normFactor;
    protected double[] shift;

    public Rank1Lattice(int n, int[] a, int s) {
        this.dim = s;
        this.numPoints = n;
        this.normFactor = 1.0 / (double)n;
        this.v = new double[s];
        this.genAs = new int[s];
        for (int j = 0; j < s; ++j) {
            if (a[j] < 0 || a[j] >= n) {
                throw new IllegalArgumentException("Rank1Lattice must have 0 <= a[j] < n");
            }
            this.v[j] = this.normFactor * (double)a[j];
            this.genAs[j] = a[j];
        }
    }

    public int[] getAs() {
        return this.genAs;
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (0 == d2) {
            d2 = Math.max(1, this.dim);
        }
        if (this.shift == null) {
            this.shift = new double[d2];
            this.capacityShift = d2;
        } else if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            double[] temp = new double[d3];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                temp[i] = this.shift[i];
            }
            this.shift = temp;
        }
        this.dimShift = d2;
        for (int i = d1; i < d2; ++i) {
            this.shift[i] = stream.nextDouble();
        }
        this.shiftStream = stream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.shift = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Rank1Lattice:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    public double getCoordinate(int i, int j) {
        double x = this.v[j] * (double)i % 1.0;
        if (this.shift != null) {
            if (j >= this.dimShift) {
                this.addRandomShift(this.dimShift, j + 1, this.shiftStream);
            }
            if ((x += this.shift[j]) >= 1.0) {
                x -= 1.0;
            }
            if (x <= 0.0) {
                x = this.EpsilonHalf;
            }
        }
        return x;
    }

    protected long modPower(long a, int e, int m) {
        if (e == 0) {
            return 1L;
        }
        if (e == 1) {
            return a % (long)m;
        }
        if ((e & 1) == 1) {
            return a * this.modPower(a, e - 1, m) % (long)m;
        }
        long p = this.modPower(a, e / 2, m);
        return p * p % (long)m;
    }

    protected double radicalInverse(int base, int i) {
        double radical;
        double digit = radical = 1.0 / (double)base;
        double inverse = 0.0;
        while (i > 0) {
            inverse += digit * (double)(i % base);
            digit *= radical;
            i /= base;
        }
        return inverse;
    }

    public PointSetIterator iterator() {
        return new Rank1LatticeIterator();
    }

    protected class Rank1LatticeIterator
    extends PointSet.DefaultPointSetIterator {
        protected Rank1LatticeIterator() {
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= Rank1Lattice.this.numPoints || this.curCoordIndex >= Rank1Lattice.this.dim) {
                this.outOfBounds();
            }
            double x = (double)this.curPointIndex * Rank1Lattice.this.v[this.curCoordIndex] % 1.0;
            if (Rank1Lattice.this.shift != null) {
                if (this.curCoordIndex >= Rank1Lattice.this.dimShift) {
                    Rank1Lattice.this.addRandomShift(Rank1Lattice.this.dimShift, this.curCoordIndex + 1, Rank1Lattice.this.shiftStream);
                }
                if ((x += Rank1Lattice.this.shift[this.curCoordIndex]) >= 1.0) {
                    x -= 1.0;
                }
                if (x <= 0.0) {
                    x = this.EpsilonHalf;
                }
            }
            ++this.curCoordIndex;
            return x;
        }
    }
}

