/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Color;
import java.awt.Paint;
import java.util.Formatter;
import java.util.Locale;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import umontreal.iro.lecuyer.charts.EmpiricalRenderer;
import umontreal.iro.lecuyer.charts.SSJXYSeriesCollection;
import umontreal.iro.lecuyer.stat.TallyStore;

public class EmpiricalSeriesCollection
extends SSJXYSeriesCollection {
    private final double EMPIR_EPS = 0.015625;
    private String[] marksType;
    private String[] dashPattern;

    private double setZeroPoint(double x1) {
        return x1 - 0.015625 * Math.abs(x1);
    }

    public EmpiricalSeriesCollection() {
        this.renderer = new EmpiricalRenderer();
        this.seriesCollection = new XYSeriesCollection();
    }

    public EmpiricalSeriesCollection(double[] ... data) {
        int i;
        this.seriesCollection = new XYSeriesCollection();
        this.renderer = new EmpiricalRenderer();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (int j = 0; j < data.length; ++j) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            serie.add(this.setZeroPoint(data[j][0]), 0.0);
            for (int k = 0; k < data[j].length; ++k) {
                serie.add(data[j][k], (double)(k + 1) / (double)data[j].length);
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)EmpiricalSeriesCollection.getDefaultColor(i));
        }
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = "*";
            this.dashPattern[i] = "solid";
        }
    }

    public EmpiricalSeriesCollection(double[] data, int numPoints) {
        this.seriesCollection = new XYSeriesCollection();
        this.renderer = new EmpiricalRenderer();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        XYSeries serie = new XYSeries((Comparable)((Object)" "));
        serie.add(this.setZeroPoint(data[0]), 0.0);
        for (int k = 0; k < numPoints; ++k) {
            serie.add(data[k], (double)(k + 1) / (double)numPoints);
        }
        tempSeriesCollection.addSeries(serie);
        this.renderer.setSeriesPaint(0, (Paint)EmpiricalSeriesCollection.getDefaultColor(0));
        this.marksType = new String[1];
        this.dashPattern = new String[1];
        this.marksType[0] = "*";
        this.dashPattern[0] = "solid";
    }

    public EmpiricalSeriesCollection(DoubleArrayList ... data) {
        int i;
        this.seriesCollection = new XYSeriesCollection();
        this.renderer = new EmpiricalRenderer();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (int j = 0; j < data.length; ++j) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            serie.add(this.setZeroPoint(data[j].get(0)), 0.0);
            for (int k = 0; k < data[j].size(); ++k) {
                serie.add(data[j].get(k), (double)(k + 1) / (double)data[j].size());
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)EmpiricalSeriesCollection.getDefaultColor(i));
        }
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = "*";
            this.dashPattern[i] = "solid";
        }
    }

    public EmpiricalSeriesCollection(TallyStore ... tallies) {
        int i;
        this.seriesCollection = new XYSeriesCollection();
        this.renderer = new EmpiricalRenderer();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (int j = 0; j < tallies.length; ++j) {
            TallyStore temp = tallies[j];
            temp.quickSort();
            double[] array = temp.getArray();
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            serie.add(this.setZeroPoint(array[0]), 0.0);
            for (int k = 0; k < tallies[j].numberObs(); ++k) {
                serie.add(array[k], (double)(k + 1) / (double)tallies[j].numberObs());
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)EmpiricalSeriesCollection.getDefaultColor(i));
        }
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = "*";
            this.dashPattern[i] = "solid";
        }
    }

    public EmpiricalSeriesCollection(XYSeriesCollection data) {
        int i;
        this.renderer = new EmpiricalRenderer();
        this.seriesCollection = data;
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)EmpiricalSeriesCollection.getDefaultColor(i));
            XYSeries ser = data.getSeries(i);
            ser.add(this.setZeroPoint(ser.getX(0).doubleValue()), 0.0);
        }
        this.marksType = new String[data.getSeriesCount()];
        this.dashPattern = new String[data.getSeriesCount()];
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.marksType[i] = "*";
            this.dashPattern[i] = "solid";
        }
    }

    public int add(double[] observationSet) {
        return this.add(observationSet, observationSet.length);
    }

    public int add(double[] observationSet, int numPoints) {
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        XYSeries serie = new XYSeries((Comparable)((Object)" "));
        serie.add(this.setZeroPoint(observationSet[0]), 0.0);
        for (int k = 0; k < numPoints; ++k) {
            serie.add(observationSet[k], (double)(k + 1) / (double)numPoints);
        }
        tempSeriesCollection.addSeries(serie);
        int j = this.seriesCollection.getSeriesCount() - 1;
        this.renderer.setSeriesPaint(j, (Paint)EmpiricalSeriesCollection.getDefaultColor(j));
        String[] newMarksType = new String[this.seriesCollection.getSeriesCount()];
        String[] newDashPattern = new String[this.seriesCollection.getSeriesCount()];
        for (j = 0; j < this.seriesCollection.getSeriesCount() - 1; ++j) {
            newMarksType[j] = this.marksType[j];
            newDashPattern[j] = this.dashPattern[j];
        }
        newMarksType[j] = "*";
        newDashPattern[j] = "solid";
        this.marksType = newMarksType;
        this.dashPattern = newDashPattern;
        return this.seriesCollection.getSeriesCount() - 1;
    }

    public int add(DoubleArrayList observationSet) {
        return this.add(observationSet.elements(), observationSet.size());
    }

    public int add(TallyStore tally) {
        tally.quickSort();
        return this.add(tally.getArray(), tally.numberObs());
    }

    public String getMarksType(int series) {
        return this.marksType[series];
    }

    public void setMarksType(int series, String marksType) {
        this.marksType[series] = marksType;
    }

    public String getDashPattern(int series) {
        return this.dashPattern[series];
    }

    public void setDashPattern(int series, String dashPattern) {
        this.dashPattern[series] = dashPattern;
    }

    public String toLatex(double XScale, double YScale, double XShift, double YShift, double xmin, double xmax, double ymin, double ymax) {
        xmin = Math.min(XShift, xmin);
        xmax = Math.max(XShift, xmax);
        ymin = Math.min(YShift, ymin);
        ymax = Math.max(YShift, ymax);
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        Formatter formatter = new Formatter(Locale.US);
        for (int i = tempSeriesCollection.getSeriesCount() - 1; i >= 0; --i) {
            Color color = (Color)this.renderer.getSeriesPaint(i);
            String colorString = EmpiricalSeriesCollection.detectXColorClassic(color);
            if (colorString == null) {
                colorString = "color" + i;
                formatter.format("\\definecolor{%s}{rgb}{%.2f, %.2f, %.2f}%n", colorString, (double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            }
            for (int j = 0; j < tempSeriesCollection.getItemCount(i); ++j) {
                double currentX = tempSeriesCollection.getXValue(i, j);
                double nextX = j == tempSeriesCollection.getItemCount(i) - 1 ? xmax : Math.min(tempSeriesCollection.getXValue(i, j + 1), xmax);
                if (!(currentX >= xmin) || !(currentX <= xmax)) continue;
                formatter.format("\\draw [color=%s] plot[mark=%s] (%.4f, %.4f) --plot[style=%s] (%.4f, %.4f); %%%n", colorString, this.marksType[i], (currentX - XShift) * XScale, (tempSeriesCollection.getYValue(i, j) - YShift) * YScale, this.dashPattern[i], (nextX - XShift) * XScale, (tempSeriesCollection.getYValue(i, j) - YShift) * YScale);
            }
        }
        return formatter.toString();
    }
}

