/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.interceptor.InvocationContext;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.AroundConstructCallback;
import org.jboss.weld.injection.producer.ForwardingInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;

public class ConstructorInterceptionInstantiator<T>
extends ForwardingInstantiator<T> {
    private final InterceptionModel<ClassMetadata<?>, ?> model;

    public ConstructorInterceptionInstantiator(Instantiator<T> delegate, InterceptionModel<ClassMetadata<?>, ?> model) {
        super(delegate);
        this.model = model;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager, AroundConstructCallback<T> callback) {
        InterceptionContext interceptionContext = InterceptionContext.forConstructorInterception(this.model, ctx, manager);
        final ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(this.model.getConstructorInvocationInterceptors().size());
        for (InterceptorMetadata<?> interceptorMetadata : this.model.getConstructorInvocationInterceptors()) {
            interceptorInvocations.add(interceptorMetadata.getInterceptorInvocation(interceptionContext.getInterceptorInstance(interceptorMetadata), InterceptionType.AROUND_CONSTRUCT));
        }
        AroundConstructCallback aroundConstructCallback = new AroundConstructCallback<T>(){

            @Override
            public T aroundConstruct(Object[] parameters, final AroundConstructCallback.ConstructionHandle<T> constructionHandle) {
                final AtomicReference target = new AtomicReference();
                SimpleInterceptionChain chain = new SimpleInterceptionChain(interceptorInvocations){

                    @Override
                    protected Object interceptorChainCompleted(InvocationContext invocationCtx) throws Exception {
                        target.set(constructionHandle.construct(invocationCtx.getParameters()));
                        return null;
                    }
                };
                InterceptorInvocationContext invocationCtx = new InterceptorInvocationContext(chain, ConstructorInterceptionInstantiator.this.delegate().getConstructor(), parameters){

                    @Override
                    public Object getTarget() {
                        return target.get();
                    }
                };
                try {
                    chain.invokeNextInterceptor(invocationCtx);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new WeldException(e);
                }
                return target.get();
            }
        };
        return this.delegate().newInstance(ctx, manager, aroundConstructCallback);
    }

    public String toString() {
        return "ConstructorInterceptionInstantiator wrapping " + this.delegate();
    }
}

