/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.api.helpers;

import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class IsolatedStaticSingletonProvider
extends SingletonProvider {
    @Override
    public <T> Singleton<T> create(Class<? extends T> type) {
        return new IsolatedStaticSingleton();
    }

    private static class IsolatedStaticSingleton<T>
    implements Singleton<T> {
        private T object;

        private IsolatedStaticSingleton() {
        }

        @Override
        public T get() {
            if (this.object == null) {
                throw new IllegalStateException("Singleton is not set. Is your Thread.currentThread().getContextClassLoader() set correctly?");
            }
            return this.object;
        }

        @Override
        public void set(T object) {
            this.object = object;
        }

        @Override
        public void clear() {
            this.object = null;
        }

        @Override
        public boolean isSet() {
            return this.object != null;
        }
    }
}

