/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.DecorableBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>>
implements DecorableBean<T> {
    protected final SlimAnnotatedType<T> annotatedType;
    protected volatile EnhancedAnnotatedType<T> enhancedAnnotatedItem;
    private InjectionTarget<T> producer;

    protected AbstractClassBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, String idSuffix, BeanManagerImpl beanManager) {
        super(attributes, idSuffix, beanManager);
        this.enhancedAnnotatedItem = type;
        this.annotatedType = type.slim();
        this.initType();
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkBeanImplementation();
    }

    public boolean hasDecorators() {
        return !this.getDecorators().isEmpty();
    }

    @Override
    public List<Decorator<?>> getDecorators() {
        if (this.isInterceptionCandidate()) {
            return this.beanManager.resolveDecorators(this.getTypes(), this.getQualifiers());
        }
        return Collections.emptyList();
    }

    protected void initType() {
        this.type = this.getEnhancedAnnotated().getJavaClass();
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize() {
        super.preSpecialize();
        Class superclass = this.getAnnotated().getJavaClass().getSuperclass();
        if (superclass == null || superclass.equals(Object.class)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    @Override
    public SlimAnnotatedType<T> getAnnotated() {
        return this.annotatedType;
    }

    public EnhancedAnnotatedType<T> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedItem);
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedItem = null;
    }

    protected abstract boolean isInterceptionCandidate();

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    public InterceptionModel<?, ?> getInterceptors() {
        if (this.isInterceptionCandidate()) {
            return (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getType());
        }
        return null;
    }

    public boolean hasInterceptors() {
        return this.getInterceptors() != null;
    }

    @Override
    public InjectionTarget<T> getProducer() {
        return this.producer;
    }

    @Override
    public void setProducer(InjectionTarget<T> producer) {
        this.producer = producer;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.getProducer();
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.setProducer(injectionTarget);
    }

    @Override
    public void setProducer(Producer<T> producer) {
        throw new IllegalArgumentException("Class bean " + this + " requires an InjectionTarget but a Producer was provided instead " + producer);
    }
}

