/*
 * Decompiled with CFR 0.152.
 */
package optas.tools;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TableRowHeader
extends JViewport
implements AdjustmentListener {
    private JTable table;
    private Cell cell;
    private Object[] names;

    public TableRowHeader(JTable table, JScrollPane parent) {
        this.table = table;
        this.cell = new Cell();
        this.setView(new Dummy());
        this.setPreferredSize(new Dimension(100, 0));
        parent.getVerticalScrollBar().addAdjustmentListener(this);
        parent.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public void setRowHeaderName(Object[] names) {
        this.names = names;
        int width = 0;
        for (int i = 0; i < names.length; ++i) {
            JLabel test = new JLabel(names[i].toString());
            width = Math.max(test.getPreferredSize().width, width);
        }
        this.setPreferredSize(new Dimension(width + 20, 0));
        this.invalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int index;
        super.paintComponent(g);
        Rectangle rec = this.getViewRect();
        int y = 0;
        int rows = this.table.getRowCount();
        if (rows == 0) {
            return;
        }
        if (y + this.table.getRowHeight(0) < rec.y) {
            int height;
            for (index = 0; index < rows && y + (height = this.table.getRowHeight(index)) < rec.y; ++index) {
                y += height;
            }
        }
        int max = rec.y + rec.height;
        int width = this.getWidth();
        while (y < max && index < rows) {
            int height = this.table.getRowHeight(index);
            this.cell.set(index);
            SwingUtilities.paintComponent(g, this.cell, this, 0, y - rec.y, width, height);
            y += height;
            ++index;
        }
    }

    private class Cell
    extends JLabel {
        private Cell() {
        }

        public void set(int row) {
            this.setHorizontalAlignment(0);
            this.setForeground(TableRowHeader.this.getForeground());
            this.setBackground(TableRowHeader.this.getBackground());
            this.setFont(TableRowHeader.this.getFont());
            if (TableRowHeader.this.names != null && TableRowHeader.this.names.length > row) {
                this.setText(TableRowHeader.this.names[row].toString());
            } else {
                this.setText("Row " + row);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    private static class Dummy
    extends JComponent {
        private Dummy() {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void update(Graphics g) {
        }
    }
}

