/*
 * Decompiled with CFR 0.152.
 */
package optas.tools;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class ObservableProgress
extends Observable
implements Serializable {
    double progress;
    boolean debugLog = true;
    Set<Observer> myObservers = new HashSet<Observer>();

    @Override
    public void addObserver(Observer o) {
        this.myObservers.add(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        this.myObservers.remove(o);
    }

    @Override
    public void deleteObservers() {
        this.myObservers.clear();
    }

    public double getProgress() {
        return this.progress;
    }

    protected void setProgress(double progress) {
        this.progress = progress;
        this.notifyObservers();
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public boolean getDebugLog() {
        return this.debugLog;
    }

    protected void log(String msg) {
        this.setChanged();
        if (this.debugLog) {
            System.out.println(msg);
        }
        this.notifyObservers(msg);
    }

    protected Set<Observer> getObservers() {
        return this.myObservers;
    }
}

