/*
 * Decompiled with CFR 0.152.
 */
package optas.spatial;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import optas.io.StandardEntityReader;

public class HRUReducer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String srcHRUFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String dstHRUFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Description")
    public Attribute.Integer method;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Description")
    public Attribute.Double mergeRate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="debugging mode", defaultValue="false")
    public Attribute.Boolean debug;
    int hruCount;
    long lastHash = -1L;
    private Map<Integer, Integer> groupMap = new TreeMap<Integer, Integer>();

    public void mergeHRUs(ArrayList<Attribute.Entity> srcEntities, long srcID, long dstID) {
        Attribute.Entity src = null;
        Attribute.Entity dst = null;
        for (int i = 0; i < srcEntities.size(); ++i) {
            Attribute.Entity e = srcEntities.get(i);
            try {
                if ((long)e.getDouble("to_poly") == srcID) {
                    e.setDouble("to_poly", (double)dstID);
                }
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendHalt("Entity " + e.getId() + " has no to_poly attribute!");
            }
            if (this.getID(e) == srcID) {
                src = e;
            }
            if (this.getID(e) != dstID) continue;
            dst = e;
        }
        srcEntities.remove(src);
        if (this.debug.getValue()) {
            int srcGroup = this.groupMap.get((int)srcID);
            int dstGroup = this.groupMap.get((int)dstID);
            for (Map.Entry<Integer, Integer> e : this.groupMap.entrySet()) {
                if (e.getValue() != srcGroup) continue;
                e.setValue(dstGroup);
            }
        }
        try {
            double src_x = src.getDouble("x");
            double dst_x = dst.getDouble("x");
            double src_y = src.getDouble("y");
            double dst_y = dst.getDouble("y");
            double src_area = src.getDouble("area");
            double dst_area = dst.getDouble("area");
            double src_slope = src.getDouble("slope");
            double dst_slope = dst.getDouble("slope");
            double src_flowLength = src.getDouble("flowlength");
            double dst_flowLength = dst.getDouble("flowlength");
            double src_flowAmount = src.getDouble("flowAmount");
            double dst_flowAmount = dst.getDouble("flowAmount");
            double src_weight = src_area / (src_area + dst_area);
            double dst_weight = dst_area / (src_area + dst_area);
            double result_x = src_weight * src_x + dst_weight * dst_x;
            double result_y = src_weight * src_y + dst_weight * dst_y;
            double result_slope = src_weight * src_slope + dst_weight * dst_slope;
            double result_flowLength = src_weight * src_flowLength + dst_weight * dst_flowLength;
            double result_flowAmount = src_flowAmount + dst_flowAmount;
            dst.setDouble("area", src_area + dst_area);
            dst.setDouble("x", result_x);
            dst.setDouble("y", result_y);
            dst.setDouble("slope", result_slope);
            dst.setDouble("flowlength", result_flowLength);
            dst.setDouble("flowAmount", result_flowAmount);
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            nsae.printStackTrace();
        }
    }

    public long getToPoly(Attribute.Entity e) {
        try {
            return (long)e.getDouble("to_poly");
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.getModel().getRuntime().sendHalt("Entity " + e.getId() + " has no to_poly attribute!");
            return 0L;
        }
    }

    public long getID(Attribute.Entity e) {
        try {
            return (long)e.getDouble("ID");
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.getModel().getRuntime().sendHalt("Entity " + e.getId() + " has no ID attribute!");
            return 0L;
        }
    }

    private int method1(ArrayList<Attribute.Entity> srcEntities) {
        int minIndex = 0;
        double minArea = Double.POSITIVE_INFINITY;
        for (int i = 0; i < srcEntities.size(); ++i) {
            try {
                double area = srcEntities.get(i).getDouble("area");
                if (!(area < minArea) || this.getToPoly(srcEntities.get(i)) == 0L) continue;
                minIndex = i;
                minArea = area;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendHalt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    private int method2(ArrayList<Attribute.Entity> srcEntities) {
        int i;
        int minIndex = 0;
        double minDistance = Double.POSITIVE_INFINITY;
        HashSet<Weighting> weightSet = new HashSet<Weighting>();
        weightSet.add(new Weighting("elevation", 0.01, true));
        weightSet.add(new Weighting("slope", 1.0, true));
        weightSet.add(new Weighting("aspect", 0.01, true));
        weightSet.add(new Weighting("soilID", 5.0, false));
        weightSet.add(new Weighting("landuseID", 3.5, false));
        weightSet.add(new Weighting("hgeoID", 1.0, false));
        HashMap<Integer, Attribute.Entity> map = new HashMap<Integer, Attribute.Entity>();
        for (i = 0; i < srcEntities.size(); ++i) {
            map.put((int)this.getID(srcEntities.get(i)), srcEntities.get(i));
        }
        for (i = 0; i < srcEntities.size(); ++i) {
            try {
                Attribute.Entity e = srcEntities.get(i);
                int upstreamId = (int)this.getToPoly(e);
                if (upstreamId == 0) continue;
                Attribute.Entity u = (Attribute.Entity)map.get(upstreamId);
                double distance = 0.0;
                for (Weighting w : weightSet) {
                    double value1 = e.getDouble(w.attribute);
                    double value2 = u.getDouble(w.attribute);
                    distance = w.isNumeric ? (distance += Math.abs(value1 - value2) * w.weight) : (distance += value1 != value2 ? w.weight : 0.0);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    minIndex = i;
                }
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendHalt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    public int method3(ArrayList<Attribute.Entity> srcEntities) {
        int minIndex = 0;
        double minFlow = Double.POSITIVE_INFINITY;
        for (int i = 0; i < srcEntities.size(); ++i) {
            try {
                double flow = srcEntities.get(i).getDouble("flowAmount");
                if (!(flow < minFlow) || this.getToPoly(srcEntities.get(i)) == 0L) continue;
                minIndex = i;
                minFlow = flow;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendHalt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    private int findNextCandidate(ArrayList<Attribute.Entity> srcEntities) {
        switch (this.method.getValue()) {
            case 1: {
                return this.method1(srcEntities);
            }
            case 2: {
                return this.method2(srcEntities);
            }
            case 3: {
                return this.method3(srcEntities);
            }
        }
        return -1;
    }

    public void createDstHRUFile(File srcHRUFile, File dstHRUFile, double beta) {
        ArrayList<Attribute.Entity> srcEntities = StandardEntityReader.readParas(srcHRUFile.getAbsolutePath(), this.getModel());
        if (this.debug.getValue()) {
            this.initGroupMap(srcEntities);
        }
        int unmergableHRUs = 0;
        for (int i = 0; i < srcEntities.size(); ++i) {
            long to_poly = this.getToPoly(srcEntities.get(i));
            if (to_poly != 0L) continue;
            ++unmergableHRUs;
        }
        int mergeHRUs = (int)((double)(srcEntities.size() - unmergableHRUs) * beta);
        this.hruCount = srcEntities.size();
        this.getModel().getRuntime().println("Total number of HRUs is: " + srcEntities.size());
        this.getModel().getRuntime().println("Unmergeable number of HRUs is: " + unmergableHRUs);
        this.getModel().getRuntime().println("Number of HRUs to merge: " + mergeHRUs);
        this.getModel().getRuntime().println("Using Method 1 (Eliminate HRU with smallest area!)");
        while (mergeHRUs > 0) {
            int index = this.findNextCandidate(srcEntities);
            long src_id = this.getID(srcEntities.get(index));
            long dst_id = this.getToPoly(srcEntities.get(index));
            this.mergeHRUs(srcEntities, src_id, dst_id);
            --mergeHRUs;
            --this.hruCount;
        }
        StandardEntityReader.writeParas(srcEntities, dstHRUFile.getAbsolutePath(), this.getModel());
    }

    private void initGroupMap(ArrayList<Attribute.Entity> srcEntities) {
        for (int i = 0; i < srcEntities.size(); ++i) {
            long id = this.getID(srcEntities.get(i));
            this.groupMap.put((int)id, (int)id);
        }
    }

    public void init() {
        long hashCode = this.dstHRUFileName.getValue().hashCode() + this.srcHRUFileName.getValue().hashCode() + Double.toString(this.mergeRate.getValue()).hashCode() + Integer.toString(this.method.getValue()).hashCode();
        if (this.lastHash == hashCode) {
            System.out.println("Skip HRU Reducer, because data is identical to last run.");
            return;
        }
        this.lastHash = hashCode;
        this.getModel().getRuntime().println("###########################################");
        this.getModel().getRuntime().println("Creating reduces HRU File:");
        this.getModel().getRuntime().println("Source HRU: " + this.srcHRUFileName.getValue());
        this.getModel().getRuntime().println("Modified HRU: " + this.dstHRUFileName.getValue());
        this.getModel().getRuntime().println("Merge-rate: " + this.mergeRate);
        this.createDstHRUFile(new File(this.getModel().getWorkspacePath() + "/" + this.srcHRUFileName.getValue()), new File(this.getModel().getWorkspacePath() + "/" + this.dstHRUFileName.getValue()), this.mergeRate.getValue());
        this.getModel().getRuntime().println("Merge stopped with: " + this.hruCount + "HRUs");
        this.getModel().getRuntime().println("###########################################");
        if (this.debug.getValue()) {
            String nfoFileName = this.dstHRUFileName.getValue().replaceAll(".par", ".nfo");
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.getModel().getWorkspacePath() + "/" + nfoFileName)));
                writer.write("HRU ID\tGROUP\n");
                for (Map.Entry<Integer, Integer> e : this.groupMap.entrySet()) {
                    writer.write(e.getKey() + "\t" + e.getValue() + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void run() {
    }

    public void cleanup() {
    }

    public static void main(String[] args) {
        HRUReducer reducer = new HRUReducer();
        reducer.dstHRUFileName = DefaultDataFactory.getDataFactory().createString();
        reducer.dstHRUFileName.setValue("C:/Arbeit/test.par");
        reducer.srcHRUFileName = DefaultDataFactory.getDataFactory().createString();
        reducer.srcHRUFileName.setValue("C:/Arbeit/ModelData/JAMS-Gehlberg/parameter/hrus_hor_dist.par");
        reducer.method = DefaultDataFactory.getDataFactory().createInteger();
        reducer.createDstHRUFile(new File("C:/Arbeit/ModelData/JAMS-Gehlberg/parameter/hrus_hor_dist.par"), new File("C:/Arbeit/test.par"), 0.5);
    }

    private class Weighting {
        String attribute;
        double weight;
        boolean isNumeric;

        public Weighting(String attribute, double weight, boolean isNumeric) {
            this.attribute = attribute;
            this.weight = weight;
            this.isNumeric = isNumeric;
        }
    }
}

