/*
 * Decompiled with CFR 0.152.
 */
package optas.spatial;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import optas.io.StandardEntityReader;

public class HRUReachReducer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String srcHRUFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String srcReachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String dstHRUFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public Attribute.String dstReachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Description")
    public Attribute.Integer method;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Description")
    public Attribute.Double mergeRate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="debugging mode", defaultValue="false")
    public Attribute.Boolean debug;
    int hruCount;
    long lastHash = -1L;
    private Map<Integer, Integer> groupMap = new TreeMap<Integer, Integer>();
    private Map<Integer, ArrayList<Attribute.Entity>> reach2HRUMap = new TreeMap<Integer, ArrayList<Attribute.Entity>>();

    private int getDownstreamReach(ArrayList<Attribute.Entity> srcReaches, int reachID) {
        Attribute.Entity reach = null;
        for (int i = 0; i < srcReaches.size(); ++i) {
            Attribute.Entity e = srcReaches.get(i);
            long id = this.getID(e);
            if (id != (long)reachID) continue;
            reach = e;
            break;
        }
        if (reach == null) {
            this.halt("No Reach to id " + reachID);
        }
        return (int)this.getToReach(reach);
    }

    private int getDownstreamHRU(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches, Attribute.Entity e) {
        long dst_id = this.getToPoly(e);
        long src_id = this.getID(e);
        if (dst_id == 0L) {
            long reach_id = this.getToReach(e);
            int ownerReach = (int)reach_id;
            while (dst_id == 0L) {
                ArrayList<Attribute.Entity> neighbourHRUs = this.getHRUsForReach(srcEntities, reach_id);
                if (neighbourHRUs == null) {
                    System.out.println("error");
                }
                if (reach_id == (long)ownerReach && neighbourHRUs.size() <= 1 || neighbourHRUs.isEmpty()) {
                    if ((reach_id = (long)this.getDownstreamReach(srcReaches, (int)reach_id)) != 0L) continue;
                    return 0;
                }
                dst_id = this.getID(neighbourHRUs.get(0));
                if (dst_id != src_id) continue;
                dst_id = this.getID(neighbourHRUs.get(1));
            }
        }
        return (int)dst_id;
    }

    public void mergeHRUs(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches, long srcID, long dstID) {
        long reachIdSrc;
        Attribute.Entity src = null;
        Attribute.Entity dst = null;
        for (int i = 0; i < srcEntities.size(); ++i) {
            Attribute.Entity e = srcEntities.get(i);
            try {
                if ((long)e.getDouble("to_poly") == srcID) {
                    e.setDouble("to_poly", (double)dstID);
                }
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.halt("Entity " + e.getId() + " has no to_poly attribute!");
            }
            if (this.getID(e) == srcID) {
                src = e;
            }
            if (this.getID(e) != dstID) continue;
            dst = e;
        }
        if (dst == null) {
            System.out.println("cannot find hru with id:" + dstID + " during merge with:" + srcID);
        }
        if (this.debug != null && this.debug.getValue()) {
            int srcGroup = this.groupMap.get((int)srcID);
            int dstGroup = this.groupMap.get((int)dstID);
            for (Map.Entry<Integer, Integer> e : this.groupMap.entrySet()) {
                if (e.getValue() != srcGroup) continue;
                e.setValue(dstGroup);
            }
        }
        if ((reachIdSrc = this.getToReach(src)) != 0L) {
            long reachIdDst = this.getToReach(dst);
            while (reachIdDst != 0L && reachIdSrc != reachIdDst) {
                this.mergeReaches(srcReaches, (int)reachIdSrc);
                reachIdSrc = this.getToReach(src);
                reachIdDst = this.getToReach(dst);
            }
            this.reach2HRUMap.get((int)reachIdSrc).remove(src);
        }
        srcEntities.remove(src);
        try {
            double src_x = src.getDouble("x");
            double dst_x = dst.getDouble("x");
            double src_y = src.getDouble("y");
            double dst_y = dst.getDouble("y");
            double src_area = src.getDouble("area");
            double dst_area = dst.getDouble("area");
            double src_slope = src.getDouble("slope");
            double dst_slope = dst.getDouble("slope");
            double src_flowLength = src.getDouble("flowlength");
            double dst_flowLength = dst.getDouble("flowlength");
            double src_weight = src_area / (src_area + dst_area);
            double dst_weight = dst_area / (src_area + dst_area);
            double result_x = src_weight * src_x + dst_weight * dst_x;
            double result_y = src_weight * src_y + dst_weight * dst_y;
            double result_slope = src_weight * src_slope + dst_weight * dst_slope;
            double result_flowLength = src_weight * src_flowLength + dst_weight * dst_flowLength;
            dst.setDouble("area", src_area + dst_area);
            dst.setDouble("x", result_x);
            dst.setDouble("y", result_y);
            dst.setDouble("slope", result_slope);
            dst.setDouble("flowlength", result_flowLength);
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            nsae.printStackTrace();
        }
        if (this.method.getValue() == 3) {
            try {
                double src_flowAmount = src.getDouble("flowAmount");
                double dst_flowAmount = dst.getDouble("flowAmount");
                double result_flowAmount = src_flowAmount + dst_flowAmount;
                dst.setDouble("flowAmount", result_flowAmount);
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                nsae.printStackTrace();
            }
        }
    }

    public long getToPoly(Attribute.Entity e) {
        try {
            return (long)e.getDouble("to_poly");
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.halt("Entity " + e.getId() + " has no to_poly attribute!");
            return 0L;
        }
    }

    public long getToReach(Attribute.Entity e) {
        try {
            return (long)e.getDouble("to_reach");
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.halt("Entity " + e.getId() + " has no to_poly attribute!");
            return 0L;
        }
    }

    public long getID(Attribute.Entity e) {
        try {
            return (long)e.getDouble("ID");
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.halt("Entity " + e.getId() + " has no ID attribute!");
            return 0L;
        }
    }

    private int method1(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        int minIndex = 0;
        double minArea = Double.POSITIVE_INFINITY;
        for (int i = 0; i < srcEntities.size(); ++i) {
            try {
                Attribute.Entity e = srcEntities.get(i);
                double area = srcEntities.get(i).getDouble("area");
                if (this.getDownstreamHRU(srcEntities, srcReaches, e) == 0 || !(area < minArea)) continue;
                minIndex = i;
                minArea = area;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.halt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    private int method2(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        int i;
        int minIndex = 0;
        double minDistance = Double.POSITIVE_INFINITY;
        HashSet<Weighting> weightSet = new HashSet<Weighting>();
        weightSet.add(new Weighting("elevation", 0.01, true));
        weightSet.add(new Weighting("slope", 1.0, true));
        weightSet.add(new Weighting("aspect", 0.01, true));
        weightSet.add(new Weighting("soilID", 5.0, false));
        weightSet.add(new Weighting("landuseID", 3.5, false));
        weightSet.add(new Weighting("hgeoID", 1.0, false));
        HashMap<Integer, Attribute.Entity> map = new HashMap<Integer, Attribute.Entity>();
        for (i = 0; i < srcEntities.size(); ++i) {
            map.put((int)this.getID(srcEntities.get(i)), srcEntities.get(i));
        }
        for (i = 0; i < srcEntities.size(); ++i) {
            try {
                Attribute.Entity e = srcEntities.get(i);
                int downstreamId = this.getDownstreamHRU(srcEntities, srcReaches, e);
                if (downstreamId == 0) continue;
                Attribute.Entity u = (Attribute.Entity)map.get(downstreamId);
                double distance = 0.0;
                for (Weighting w : weightSet) {
                    double value1 = e.getDouble(w.attribute);
                    double value2 = u.getDouble(w.attribute);
                    if (w.isNumeric) {
                        distance += Math.abs(value1 - value2) * w.weight;
                        continue;
                    }
                    distance += value1 != value2 ? w.weight : 0.0;
                }
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.halt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    public int method3(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        int minIndex = 0;
        double minFlow = Double.POSITIVE_INFINITY;
        for (int i = 0; i < srcEntities.size(); ++i) {
            try {
                Attribute.Entity e = srcEntities.get(i);
                double flow = e.getDouble("flowAmount");
                if (this.getDownstreamHRU(srcEntities, srcReaches, e) == 0 || !(flow < minFlow)) continue;
                minIndex = i;
                minFlow = flow;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.halt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    private int method4(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        int i;
        int minIndex = 0;
        double minDistance = Double.POSITIVE_INFINITY;
        HashSet<Weighting> weightSet = new HashSet<Weighting>();
        weightSet.add(new Weighting("elevation", 0.01, true));
        weightSet.add(new Weighting("slope", 1.0, true));
        weightSet.add(new Weighting("aspect", 0.01, true));
        weightSet.add(new Weighting("soilID", 5.0, false));
        weightSet.add(new Weighting("landuseID", 3.5, false));
        weightSet.add(new Weighting("hgeoID", 1.0, false));
        HashMap<Integer, Attribute.Entity> map = new HashMap<Integer, Attribute.Entity>();
        for (i = 0; i < srcEntities.size(); ++i) {
            map.put((int)this.getID(srcEntities.get(i)), srcEntities.get(i));
        }
        for (i = 0; i < srcEntities.size(); ++i) {
            try {
                Attribute.Entity e = srcEntities.get(i);
                int downstreamId = this.getDownstreamHRU(srcEntities, srcReaches, e);
                if (downstreamId == 0) continue;
                Attribute.Entity u = (Attribute.Entity)map.get(downstreamId);
                double distance = 0.0;
                for (Weighting w : weightSet) {
                    double value1 = e.getDouble(w.attribute);
                    double value2 = u.getDouble(w.attribute);
                    if (w.isNumeric) {
                        distance += Math.abs(value1 - value2) * w.weight;
                        continue;
                    }
                    distance += value1 != value2 ? w.weight : 0.0;
                }
                if (!((distance *= e.getDouble("area")) < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
                continue;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.halt("Entity " + srcEntities.get(i).getId() + " has no area attribute!");
            }
        }
        return minIndex;
    }

    private int findNextCandidate(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        switch (this.method.getValue()) {
            case 1: {
                return this.method1(srcEntities, srcReaches);
            }
            case 2: {
                return this.method2(srcEntities, srcReaches);
            }
            case 3: {
                return this.method3(srcEntities, srcReaches);
            }
            case 4: {
                return this.method4(srcEntities, srcReaches);
            }
        }
        return -1;
    }

    private ArrayList<Attribute.Entity> getHRUsForReach(ArrayList<Attribute.Entity> srcEntities, long reachID) {
        ArrayList<Attribute.Entity> list = this.reach2HRUMap.get((int)reachID);
        return list;
    }

    private int mergeReaches(ArrayList<Attribute.Entity> srcReaches, int reachID) {
        Attribute.Entity reach = null;
        for (int i = 0; i < srcReaches.size(); ++i) {
            Attribute.Entity e = srcReaches.get(i);
            long id = this.getID(e);
            if (id != (long)reachID) continue;
            reach = e;
            break;
        }
        if (reach == null) {
            this.halt("No Reach to id " + reachID);
        }
        long toReach = this.getToReach(reach);
        int reachIDsrc = 0;
        Attribute.Entity src = null;
        int reachIDdst = 0;
        Attribute.Entity dst = null;
        if (toReach == 0L) {
            return 0;
        }
        for (int i = 0; i < srcReaches.size(); ++i) {
            Attribute.Entity e = srcReaches.get(i);
            long id = this.getID(e);
            if (id != toReach) continue;
            reachIDsrc = reachID;
            src = reach;
            reachIDdst = (int)id;
            dst = e;
            break;
        }
        if (src == null || dst == null) {
            this.log("Failed to merge reach with id:" + reachID);
            StandardEntityReader.writeParas(srcReaches, "test.par", this.getModel());
        }
        srcReaches.remove(src);
        ArrayList<Attribute.Entity> list = this.reach2HRUMap.get(reachIDsrc);
        for (Attribute.Entity e : list) {
            e.setDouble("to_reach", (double)reachIDdst);
        }
        this.reach2HRUMap.get(reachIDdst).addAll(list);
        this.reach2HRUMap.put(reachIDsrc, null);
        for (int i = 0; i < srcReaches.size(); ++i) {
            Attribute.Entity e = srcReaches.get(i);
            long id = this.getToReach(e);
            if (id != (long)reachIDsrc) continue;
            e.setDouble("to_reach", (double)reachIDdst);
        }
        try {
            double src_length = src.getDouble("length");
            double dst_length = dst.getDouble("length");
            double src_slope = src.getDouble("slope");
            double dst_slope = dst.getDouble("slope");
            double src_rough = src.getDouble("rough");
            double dst_rough = dst.getDouble("rough");
            double src_width = src.getDouble("width");
            double dst_width = dst.getDouble("width");
            double src_weight = src_length / (src_length + dst_length);
            double dst_weight = dst_length / (src_length + dst_length);
            double result_length = src_length + dst_length;
            double result_slope = src_weight * src_slope + dst_weight * dst_slope;
            double result_rough = src_weight * src_rough + dst_weight * dst_rough;
            double result_width = src_width + dst_width;
            dst.setDouble("length", result_length);
            dst.setDouble("slope", result_slope);
            dst.setDouble("rough", result_rough);
            dst.setDouble("width", result_width);
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            this.log(nsae.toString());
            nsae.printStackTrace();
        }
        return reachIDdst;
    }

    public void createDstHRUFile(File srcHRUFile, File dstHRUFile, File srcReachFile, File dstReachFile, double beta) {
        this.groupMap = new TreeMap<Integer, Integer>();
        this.reach2HRUMap = new TreeMap<Integer, ArrayList<Attribute.Entity>>();
        ArrayList<Attribute.Entity> srcEntities = StandardEntityReader.readParas(srcHRUFile.getAbsolutePath(), this.getModel());
        ArrayList<Attribute.Entity> srcReaches = StandardEntityReader.readParas(srcReachFile.getAbsolutePath(), this.getModel());
        if (this.debug != null && this.debug.getValue()) {
            this.initGroupMap(srcEntities);
        }
        this.initReach2HRUMap(srcEntities, srcReaches);
        int mergeHRUs = (int)(((double)srcEntities.size() - 1.0) * beta);
        this.hruCount = srcEntities.size();
        this.log("Total number of HRUs is: " + srcEntities.size());
        this.log("Number of HRUs to merge: " + mergeHRUs);
        this.log("Using Method 1 (Eliminate HRU with smallest area!)");
        while (mergeHRUs > 0) {
            int index = this.findNextCandidate(srcEntities, srcReaches);
            long src_id = this.getID(srcEntities.get(index));
            long dst_id = this.getDownstreamHRU(srcEntities, srcReaches, srcEntities.get(index));
            this.mergeHRUs(srcEntities, srcReaches, src_id, dst_id);
            --mergeHRUs;
            --this.hruCount;
        }
        StandardEntityReader.writeParas(srcEntities, dstHRUFile.getAbsolutePath(), this.getModel());
        StandardEntityReader.writeParas(srcReaches, dstReachFile.getAbsolutePath(), this.getModel());
    }

    private void initGroupMap(ArrayList<Attribute.Entity> srcEntities) {
        for (int i = 0; i < srcEntities.size(); ++i) {
            long id = this.getID(srcEntities.get(i));
            this.groupMap.put((int)id, (int)id);
        }
    }

    private void initReach2HRUMap(ArrayList<Attribute.Entity> srcEntities, ArrayList<Attribute.Entity> srcReaches) {
        int reachID;
        Attribute.Entity e;
        int i;
        for (i = 0; i < srcReaches.size(); ++i) {
            e = srcReaches.get(i);
            reachID = (int)this.getID(e);
            this.reach2HRUMap.put(reachID, new ArrayList());
        }
        for (i = 0; i < srcEntities.size(); ++i) {
            e = srcEntities.get(i);
            reachID = (int)this.getToReach(e);
            if (reachID == 0) continue;
            this.reach2HRUMap.get(reachID).add(e);
        }
    }

    public void init() {
        long hashCode = this.dstHRUFileName.getValue().hashCode() + this.srcHRUFileName.getValue().hashCode() + Double.toString(this.mergeRate.getValue()).hashCode() + Integer.toString(this.method.getValue()).hashCode();
        if (this.lastHash == hashCode) {
            this.log("Skip HRU Reducer, because data is identical to last run.");
            return;
        }
        this.lastHash = hashCode;
        this.log("###########################################");
        this.log("Creating reduces HRU File:");
        this.log("Source HRU: " + this.srcHRUFileName.getValue());
        this.log("Modified HRU: " + this.dstHRUFileName.getValue());
        this.log("Merge-rate: " + this.mergeRate);
        this.createDstHRUFile(new File(this.getModel().getWorkspacePath() + "/" + this.srcHRUFileName.getValue()), new File(this.getModel().getWorkspacePath() + "/" + this.dstHRUFileName.getValue()), new File(this.getModel().getWorkspacePath() + "/" + this.srcReachFileName.getValue()), new File(this.getModel().getWorkspacePath() + "/" + this.dstReachFileName.getValue()), this.mergeRate.getValue());
        this.log("Merge stopped with: " + this.hruCount + "HRUs");
        this.log("###########################################");
        if (this.debug.getValue()) {
            String nfoFileName = this.dstHRUFileName.getValue().replaceAll(".par", ".nfo");
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.getModel().getWorkspacePath() + "/" + nfoFileName)));
                writer.write("HRU ID\tGROUP\n");
                for (Map.Entry<Integer, Integer> e : this.groupMap.entrySet()) {
                    writer.write(e.getKey() + "\t" + e.getValue() + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void run() {
    }

    public void cleanup() {
    }

    private void halt(String msg) {
        if (this.getModel() != null && this.getModel().getRuntime() != null) {
            this.getModel().getRuntime().sendHalt(msg);
        } else {
            System.out.println("msg");
            System.exit(0);
        }
    }

    private void log(String msg) {
        if (this.getModel() != null && this.getModel().getRuntime() != null) {
            this.getModel().getRuntime().sendInfoMsg(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        HRUReachReducer reducer = new HRUReachReducer();
        reducer.dstHRUFileName = DefaultDataFactory.getDataFactory().createString();
        reducer.dstHRUFileName.setValue("C:/Arbeit/test.par");
        reducer.srcHRUFileName = DefaultDataFactory.getDataFactory().createString();
        reducer.srcHRUFileName.setValue("C:/Arbeit/ModelData/JAMS-Gehlberg/parameter/hrus_hor_dist.par");
        reducer.method = DefaultDataFactory.getDataFactory().createInteger();
        reducer.method.setValue(4);
        reducer.debug = DefaultDataFactory.getDataFactory().createBoolean();
        reducer.debug.setValue(true);
        reducer.createDstHRUFile(new File("C:/Arbeit/ModelData/ARS/J2KIlm/parameter/hrus_hor_dist.par"), new File("C:/Arbeit/hru_test.par"), new File("C:/Arbeit/ModelData/ARS/J2KIlm/parameter/reach.par"), new File("C:/Arbeit/reach_test.par"), 1.0);
    }

    private class Weighting {
        String attribute;
        double weight;
        boolean isNumeric;

        public Weighting(String attribute, double weight, boolean isNumeric) {
            this.attribute = attribute;
            this.weight = weight;
            this.isNumeric = isNumeric;
        }
    }
}

