/*
 * Decompiled with CFR 0.152.
 */
package optas.sampler;

import jams.io.SerializableBufferedWriter;
import jams.model.JAMSComponentDescription;
import java.util.ArrayList;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.StringOptimizerParameter;
import optas.optimizer.parallel.ParallelSequence;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.hups.SobolSequence;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class SobolsSequence
extends Optimizer {
    SerializableBufferedWriter writer = null;
    public String excludeFiles = "";
    public double threadCount = 12.0;
    public boolean parallelExecution = false;
    public SampleFactory.Sample[] initialSimplex = null;
    ParallelSequence pSeq = null;
    transient DataCollection collection = null;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(SobolsSequence.class.getSimpleName(), SobolsSequence.class.getName(), 500, false);
        desc.addParameter(new BooleanOptimizerParameter("parallelExecution", "parallelExecution", false));
        desc.addParameter(new StringOptimizerParameter("excludeFiles", "excludeFiles", "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log"));
        desc.addParameter(new NumericOptimizerParameter("threadCount", "threadCount", 8.0, 2.0, 100.0));
        return desc;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        if (this.parallelExecution) {
            this.pSeq = new ParallelSequence(this);
            this.pSeq.setExcludeFiles(this.excludeFiles);
            this.pSeq.setThreadCount((int)this.threadCount);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        SobolSequence s = new SobolSequence((int)Math.ceil(this.maxn), this.n);
        PointSetIterator iter = s.iterator();
        int i = 0;
        ArrayList<double[]> set = new ArrayList<double[]>();
        boolean first = true;
        while (iter.hasNextPoint()) {
            double[] x0 = new double[this.n];
            iter.nextPoint(x0, this.n);
            for (int j = 0; j < this.n; ++j) {
                x0[j] = this.lowBound[j] + x0[j] * (this.upBound[j] - this.lowBound[j]);
            }
            if (first) {
                first = false;
                continue;
            }
            set.add(x0);
        }
        int samplesPerIteration2 = (int)(this.threadCount * 6.0);
        if (samplesPerIteration2 == 0) {
            samplesPerIteration2 = 100;
        }
        while ((double)i < this.maxn) {
            int j;
            int sampleCount = (int)Math.min((double)samplesPerIteration2, this.maxn - (double)i);
            double[][] x = new double[sampleCount][];
            for (j = 0; j < sampleCount; ++j) {
                x[j] = (double[])set.remove(0);
                ++i;
            }
            if (this.parallelExecution) {
                ParallelSequence.OutputData result = this.pSeq.procedure(x);
                if (this.collection == null) {
                    this.collection = result.dc;
                } else {
                    DataCollection dataCollection = this.collection;
                    synchronized (dataCollection) {
                        if (result.dc != null) {
                            this.collection.mergeDataCollections(result.dc);
                        }
                    }
                }
                if (result.list != null) {
                    this.injectSamples(result.list);
                }
                if (this.collection == null) continue;
                this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), true);
                continue;
            }
            for (j = 0; j < x.length; ++j) {
                this.getSample(x[j]);
            }
        }
        if (this.collection != null) {
            this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), false);
        }
    }
}

