/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.parallel;

import jams.model.JAMSComponentDescription;
import jams.model.JAMSModel;
import jams.runtime.StandardRuntime;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.io.ImportMonteCarloData;
import optas.io.ImportMonteCarloException;
import optas.optimizer.Optimizer;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.parallel.ParallelExecution;
import optas.optimizer.parallel.ParallelJob;
import optas.optimizer.parallel.ParallelTask;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class ParallelSequence
implements Serializable {
    public String excludeFiles = "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log";
    private int threadCount = 12;
    Optimizer context;
    transient ParallelExecution<InputData, OutputData> executor = null;

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(String excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    public ParallelSequence(Optimizer context) {
        this.context = context;
        this.init(context);
    }

    private boolean init(Optimizer context) {
        String[] libs = null;
        if (context.getModel().getRuntime() instanceof StandardRuntime) {
            libs = ((StandardRuntime)context.getModel().getRuntime()).getLibs();
        }
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                String lib = libs[i];
                File fileToLib = new File(lib);
                if (!fileToLib.exists()) continue;
                ParallelExecution.addJarsToClassPath(ClassLoader.getSystemClassLoader(), fileToLib);
            }
        } else {
            System.out.println("Warning: no libary path was specified");
        }
        return true;
    }

    public OutputData procedure(double[][] x) throws SampleLimitException, ObjectiveAchievedException {
        OutputData result = null;
        if (this.executor == null) {
            this.executor = new ParallelExecution(this.context.getModel().getWorkspaceDirectory(), this.excludeFiles);
        }
        InputData param = new InputData(x, 0, x.length, this.context);
        result = this.executor.execute(param, new ParallelSequenceTask(), this.getThreadCount());
        return result;
    }

    private static OutputData parallelExecute(InputData in) {
        ArrayList<SampleFactory.Sample> sampleList = new ArrayList<SampleFactory.Sample>();
        try {
            for (int i = in.start; i < in.end; ++i) {
                sampleList.add(in.context.getSample(in.x[i]));
            }
        }
        catch (SampleLimitException sle) {
            sle.printStackTrace();
        }
        catch (ObjectiveAchievedException oae) {
            oae.printStackTrace();
        }
        try {
            in.context.getModel().cleanup();
            in.context.getModel().getWorkspace().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OutputData data = new OutputData(sampleList);
        data.start = in.start;
        File outputDataDir = in.context.getModel().getWorkspace().getOutputDataDirectory();
        File[] list = outputDataDir.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().endsWith("dat")) continue;
                data.add(list[i].getName(), list[i]);
            }
        }
        return data;
    }

    public static class ParallelSequenceTask
    extends ParallelTask<InputData, OutputData>
    implements Serializable {
        @Override
        public ArrayList<ParallelJob> split(InputData taskArgument, int gridSize) {
            int i;
            ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>(gridSize);
            int iterationsPerJob = (int)Math.ceil((double)taskArgument.x.length / (double)gridSize);
            while (iterationsPerJob * (gridSize - 1) >= taskArgument.x.length) {
                --gridSize;
            }
            InputData[] jobsData = new InputData[gridSize];
            int start = 0;
            int end = 0;
            for (i = 0; i < gridSize; ++i) {
                end = Math.min(start + iterationsPerJob, taskArgument.x.length);
                jobsData[i] = new InputData(taskArgument.x, start, end, taskArgument.context);
                start = end;
            }
            for (i = 0; i < jobsData.length; ++i) {
                jobs.add(new ParallelJob<InputData, OutputData>(jobsData[i]){

                    @Override
                    public void moveWorkspace(File newWorkspace) {
                        ((JAMSModel)((InputData)this.arg).context.getModel()).moveWorkspaceDirectory(newWorkspace.getAbsolutePath());
                    }

                    @Override
                    public OutputData execute() {
                        OutputData result = ParallelSequence.parallelExecute((InputData)this.arg);
                        return result;
                    }
                });
            }
            return jobs;
        }

        @Override
        public OutputData reduce(ArrayList<OutputData> results) {
            System.out.println("reduce_function_started_");
            OutputData merged = new OutputData(new ArrayList<SampleFactory.Sample>());
            for (int i = 0; i < results.size(); ++i) {
                if (merged.dc == null) {
                    merged.dc = results.get((int)i).dc;
                } else if (results.get((int)i).dc != null) {
                    merged.dc.mergeDataCollections(results.get((int)i).dc);
                }
                OutputData result = results.get(i);
                for (int j = 0; j < result.list.size(); ++j) {
                    while (merged.list.size() < result.start + j + 1) {
                        merged.list.add(result.list.get(j));
                    }
                    merged.list.set(result.start + j, result.list.get(j));
                }
            }
            System.out.println("reduce_function_finished");
            return merged;
        }
    }

    public static class OutputData
    implements Serializable {
        public DataCollection dc = null;
        int start;
        public ArrayList<SampleFactory.Sample> list;

        public OutputData(ArrayList<SampleFactory.Sample> list) {
            this.list = list;
        }

        public void add(String context, File dataStore) {
            try {
                ImportMonteCarloData importer = new ImportMonteCarloData();
                importer.addFile(dataStore);
                DataCollection nextDC = importer.getEnsemble();
                if (nextDC == null) {
                    return;
                }
                if (this.dc == null) {
                    this.dc = importer.getEnsemble();
                } else {
                    this.dc.unifyDataCollections(importer.getEnsemble());
                }
            }
            catch (ImportMonteCarloException imce) {
                imce.printStackTrace();
                System.out.println(imce);
            }
        }
    }

    public static class InputData
    implements Serializable {
        public Optimizer context;
        public double[][] x;
        int start;
        int end;

        public InputData(double[][] x, int start, int end, Optimizer context) {
            this.context = context;
            this.start = start;
            this.end = end;
            this.x = x;
        }
    }
}

