/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import optas.gui.wizard.OPTASWizardException;
import optas.optimizer.experimental.ParallelPostSampling;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.StringOptimizerParameter;

public class Tools {
    public static double dist(double[] p1, double[] p2, double[] lb, double[] ub) {
        double d = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            d += (p1[i] - p2[i]) * (p1[i] - p2[i]) / (ub[i] - lb[i]);
        }
        return d;
    }

    public static double[] clamp(Rectangle rect, double[] p) {
        double[] clamp = new double[p.length];
        for (int j = 0; j < p.length; ++j) {
            clamp[j] = p[j] < rect.lb[j] ? rect.lb[j] : (p[j] > rect.ub[j] ? rect.ub[j] : p[j]);
        }
        return clamp;
    }

    public static double[][] parseStringTo2dArray(String in) {
        int n = -1;
        int counter = 0;
        in = in.replaceAll("\n", "");
        in = in.replaceAll(" ", "");
        StringTokenizer tokStartValue = new StringTokenizer(in, ";");
        ArrayList<double[]> list = new ArrayList<double[]>();
        while (tokStartValue.hasMoreTokens()) {
            String param = tokStartValue.nextToken();
            param = param.replace("[", "");
            param = param.replace("]", "");
            StringTokenizer subTokenizer = new StringTokenizer(param, ",");
            double[] xi = new double[subTokenizer.countTokens()];
            if (n != -1) {
                if (xi.length != n) {
                    return null;
                }
            } else {
                n = subTokenizer.countTokens();
            }
            int subCounter = 0;
            while (subTokenizer.hasMoreTokens()) {
                try {
                    xi[subCounter] = Double.valueOf(subTokenizer.nextToken());
                    ++subCounter;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            list.add(xi);
            ++counter;
        }
        double[][] result = new double[list.size()][n];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (double[])list.get(i);
        }
        return result;
    }

    public static HashMap<String, OptimizerParameter> paramString2PropertyMap(String paramString) throws OPTASWizardException {
        HashMap<String, OptimizerParameter> propertyList = new HashMap<String, OptimizerParameter>();
        if (paramString.isEmpty()) {
            return new HashMap<String, OptimizerParameter>();
        }
        String[] params = paramString.split(";");
        for (int i = 0; i < params.length; ++i) {
            String[] entry = params[i].split("=");
            if (entry.length != 2) {
                throw new OPTASWizardException("Invalid parameterization of SimpleOptimizationController. The Parameter in question is" + params[i]);
            }
            if (entry[1].equals("true") || entry[1].equals("false")) {
                propertyList.put(entry[0], new BooleanOptimizerParameter(entry[0], "unknown", Boolean.parseBoolean(entry[1])));
                continue;
            }
            try {
                double value = Double.parseDouble(entry[1]);
                propertyList.put(entry[0], new NumericOptimizerParameter(entry[0], "unknown", value, Double.MIN_VALUE, Double.MAX_VALUE));
                continue;
            }
            catch (NumberFormatException nfe) {
                propertyList.put(entry[0], new StringOptimizerParameter(entry[0], "unknown", entry[1]));
            }
        }
        return propertyList;
    }

    public static OptimizerDescription getStandardOptimizerDesc() {
        OptimizerDescription desc = new OptimizerDescription();
        desc.setDoSpatialRelaxation(new BooleanOptimizerParameter("doSpatialRelaxation", "?", false));
        desc.setShortName("unknown optimizer");
        desc.setId(1);
        desc.setAssessNonUniqueness(new BooleanOptimizerParameter("AssessNonUniqueness", "?", false));
        desc.setOptimizerClassName(ParallelPostSampling.class.getName());
        desc.setMultiObjective(false);
        return desc;
    }

    public static OptimizerDescription getStandardOptimizerDesc(String paramString) throws OPTASWizardException {
        OptimizerDescription desc = Tools.getStandardOptimizerDesc();
        desc.setPropertyMap(Tools.paramString2PropertyMap(paramString));
        return desc;
    }

    public static class Rectangle
    implements Serializable {
        public double[] lb;
        public double[] ub;

        public double[] m() {
            double[] x = new double[this.lb.length];
            for (int i = 0; i < this.lb.length; ++i) {
                x[i] = (this.lb[i] + this.ub[i]) / 2.0;
            }
            return x;
        }
    }
}

