/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import jams.data.Attribute;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.NelderMead;
import optas.optimizer.Optimizer;
import optas.optimizer.management.OptimizationController;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.Statistics;

public class SpatialRelaxation {
    Attribute.Double relaxationParameter = null;
    Statistics lastStat = null;

    public void setRelaxationParameter(Attribute.Double relaxationParameter) {
        this.relaxationParameter = relaxationParameter;
    }

    public Attribute.Double getRelaxationParameter() {
        return this.relaxationParameter;
    }

    public Statistics applyProcedure(OptimizationController.OptimizationConfiguration conf) {
        double relaxationValue = 1.0;
        SampleFactory.Sample last = null;
        int count = 0;
        int n = conf.n();
        conf.log("########################################################");
        conf.log("Relaxation Optimization");
        conf.log("########");
        SampleFactory.Sample currentBest = null;
        double[][] currentSpace = null;
        double[] defaultValue = new double[n];
        for (int i = 0; i < n; ++i) {
            defaultValue[i] = Double.NaN;
        }
        while (relaxationValue > 0.0) {
            int i;
            SampleFactory.Sample min;
            conf.log("#Using relaxaxtion value:" + relaxationValue);
            conf.log("#Optimize now...");
            conf.log("#Current iteration is:" + conf.getIterationCount());
            this.relaxationParameter.setValue(relaxationValue);
            Optimizer optimizer = null;
            if (relaxationValue < 0.8 && conf.getLocalSearchDuringRelaxation()) {
                optimizer = conf.loadOptimizer(NelderMead.class.getName());
                NelderMead nmOptimizer = (NelderMead)optimizer;
                nmOptimizer.setMax_restart_count(1.0);
                nmOptimizer.setEpsilon(0.01);
            } else {
                optimizer = conf.loadOptimizer(null);
            }
            if (currentSpace != null) {
                // empty if block
            }
            if (currentBest != null) {
                optimizer.setStartValue(currentBest.getParameter());
            }
            optimizer.optimize();
            last = last == null ? optimizer.getSamples().get(0) : last;
            conf.log("#...Finished");
            int lastIterations = conf.getIterationCount() - count;
            this.lastStat = optimizer.getStatistics();
            currentBest = min = this.lastStat.getMin(0);
            currentSpace = new double[2][n];
            for (i = 0; i < n; ++i) {
                currentSpace[0][i] = this.lastStat.getMaximalParameter(i);
                currentSpace[1][i] = this.lastStat.getMinimalParameter(i);
            }
            for (i = 0; i < this.lastStat.m(); ++i) {
                double[][] space = this.lastStat.getParameterSpace(0, this.lastStat.size(), i, 0.7);
                if (currentSpace == null) continue;
                for (int j = 0; j < n; ++j) {
                    currentSpace[0][j] = Math.min(currentSpace[0][j], space[0][j]);
                    currentSpace[1][j] = Math.max(currentSpace[1][j], space[1][j]);
                }
            }
            for (i = 0; i < n; ++i) {
                double r = currentSpace[1][i] - currentSpace[0][i];
                currentSpace[0][i] = currentSpace[0][i] - 0.1 * r;
                currentSpace[1][i] = currentSpace[1][i] + 0.1 * r;
            }
            conf.log("#new lower range:" + Arrays.toString(currentSpace[0]));
            conf.log("#new upper range:" + Arrays.toString(currentSpace[1]));
            conf.log("#Minimum:" + Arrays.toString(min.x) + "Objective:" + Arrays.toString(min.F()));
            conf.log("#Geometric range:" + this.lastStat.calcGeometricRange(lastIterations));
            if (count != 0) {
                double dist = 0.0;
                for (int i2 = 0; i2 < n; ++i2) {
                    dist += (min.getParameter()[i2] - last.getParameter()[i2]) * (min.getParameter()[i2] - last.getParameter()[i2]);
                }
                dist = Math.sqrt(dist);
                conf.log("#Distance to last minimum:" + dist);
                conf.log("#Improvement:" + this.lastStat.calcImprovement(lastIterations, 0));
            }
            double step = 0.0;
            if (conf.getAdaptiveRelaxation()) {
                step = -relaxationValue / 2.0;
                double adaption_best = 0.2;
                double adaption_cur = 0.0;
                double epsilon_low = 0.02;
                double epsilon_up = relaxationValue - 0.03;
                double epsilon = 0.05;
                if (relaxationValue <= 2.0E-6) {
                    relaxationValue = 0.0;
                    step = 0.0;
                } else if (relaxationValue < epsilon) {
                    relaxationValue = 1.0E-6;
                    step = 0.0;
                } else {
                    for (double stepLength = Math.abs(step / 2.0); Math.abs(step) > epsilon_low && Math.abs(step) < epsilon_up && stepLength > epsilon; stepLength /= 2.0) {
                        this.relaxationParameter.setValue(relaxationValue + step);
                        try {
                            double[] result = conf.evaluate(currentBest.getParameter());
                            for (int j = 0; j < result.length; ++j) {
                                adaption_cur = Math.min(adaption_cur, Math.abs(1.0 - result[j] / currentBest.F()[j]));
                            }
                            if (adaption_cur > adaption_best) {
                                step += stepLength;
                                continue;
                            }
                            step -= stepLength;
                            continue;
                        }
                        catch (SampleLimitException sle) {
                            return this.lastStat;
                        }
                        catch (ObjectiveAchievedException oae) {
                            return this.lastStat;
                        }
                    }
                    conf.log("Relexation was adapted to " + relaxationValue + " adapted rate was " + adaption_cur);
                }
            } else {
                step = -0.1;
            }
            relaxationValue += step;
            count = this.lastStat.size();
        }
        return this.lastStat;
    }
}

