/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSBoolean;
import jams.data.JAMSDouble;
import jams.data.JAMSInteger;
import jams.data.JAMSString;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.Context;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.Statistics;

public abstract class OptimizerWrapper
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="List of parameter identifiers to be sampled")
    public JAMSString parameterNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSDouble[] parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="List of parameter identifiers to be sampled", defaultValue="")
    public JAMSString startValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="current iteration")
    public JAMSInteger iterationCounter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="file for saving sample data", defaultValue="false")
    public JAMSBoolean debugMode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="objective function name")
    public Attribute.String effMethodName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the prediction series")
    public Attribute.Double[] effValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="known optimal value", defaultValue="-Infinity")
    public Attribute.DoubleArray target;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="stopping criterion if target is met", defaultValue="-1")
    public Attribute.Double epsilonToTarget;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="solutions")
    public Attribute.Entity solution;
    protected String[] efficiencyNames;
    protected JAMSDouble[] parameter;
    protected String[] names;
    protected double[] lowBound;
    protected double[] upBound;
    public int n;
    public int m;
    protected double[][] x0 = null;
    private SampleFactory factory = new SampleFactory();

    public void initAll() {
    }

    public void init() {
        if (this.getModel() == null) {
            System.out.println("Failure: Optimization Wrapper is not located inside a model!");
            return;
        }
        super.init();
        if (this.parameterIDs == null) {
            this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"parameterIDs_not_specified"));
        }
        if (this.boundaries == null) {
            this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"parameter_boundaries_not_specified"));
        }
        if (this.parameterNames == null) {
            this.getModel().getRuntime().sendInfoMsg("names of parameters are not provided!");
        }
        this.n = this.parameterIDs.length;
        this.parameter = this.parameterIDs;
        this.lowBound = new double[this.n];
        this.upBound = new double[this.n];
        StringTokenizer tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (i >= this.n) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"too_many_boundaries"));
                return;
            }
            String key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            try {
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            }
            catch (NumberFormatException e) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"unsupported_number_format_found_for_lower_or_upper_bound"));
                return;
            }
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Component") + " " + this.getInstanceName() + ": " + JAMS.i18n((String)"upBound_must_be_higher_than_lowBound"));
                return;
            }
            ++i;
        }
        if (this.parameterNames != null) {
            tok = new StringTokenizer(this.parameterNames.getValue(), ";");
            if (tok.countTokens() != this.n) {
                this.getModel().getRuntime().sendInfoMsg("wrong number of parameter names");
            }
            int c = 0;
            this.names = new String[this.n];
            while (tok.hasMoreTokens()) {
                this.names[c++] = tok.nextToken();
            }
        }
        if (this.startValue != null) {
            int counter = 0;
            StringTokenizer tokStartValue = new StringTokenizer(this.startValue.getValue(), ";");
            ArrayList<double[]> x0List = new ArrayList<double[]>();
            while (tokStartValue.hasMoreTokens()) {
                String param = tokStartValue.nextToken();
                param = param.replace("[", "");
                param = param.replace("]", "");
                StringTokenizer subTokenizer = new StringTokenizer(param, ",");
                double[] x0i = new double[subTokenizer.countTokens()];
                int subCounter = 0;
                if (x0i.length != this.n) {
                    this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Component") + " " + JAMS.i18n((String)"startvalue_too_many_parameter"));
                }
                while (subTokenizer.hasMoreTokens()) {
                    try {
                        x0i[subCounter] = Double.valueOf(subTokenizer.nextToken());
                        ++subCounter;
                    }
                    catch (NumberFormatException e) {
                        this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Component") + " " + this.getInstanceName() + ": " + JAMS.i18n((String)"unparseable_number") + param);
                    }
                }
                x0List.add(x0i);
                ++counter;
            }
            this.x0 = new double[x0List.size()][this.n];
            for (int j = 0; j < x0List.size(); ++j) {
                this.x0[j] = (double[])x0List.get(j);
            }
        }
        if (this.effMethodName == null) {
            this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"effMethod_not_specified"));
        }
        if (this.effValue == null) {
            this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"effValue_not_specified"));
        }
        this.m = this.effValue.length;
        StringTokenizer effTok = new StringTokenizer(this.effMethodName.getValue(), ";");
        this.efficiencyNames = new String[this.m];
        for (int j = 0; j < this.m; ++j) {
            try {
                this.efficiencyNames[j] = effTok.nextToken();
                continue;
            }
            catch (NoSuchElementException e) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"efficiency_count_does_not_effMethodName_mode_count"));
            }
        }
        this.iterationCounter.setValue(0);
    }

    public Statistics getStatistics() {
        return this.factory.getStatistics();
    }

    public int getIterationCount() {
        return this.factory.getSize();
    }

    public void setupDataTracer() {
        super.setupDataTracer();
        for (DataTracer dataTracer : this.dataTracers) {
            dataTracer.startMark();
        }
    }

    String buildMark() {
        return Integer.toString(this.iterationCounter.getValue()) + "\t";
    }

    protected AbstractTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSInteger.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String s = filter.getContext().getTraceMark();
                    if (filter.isFiltered(s)) continue;
                    return;
                }
                this.output(OptimizerWrapper.this.buildMark());
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    public String getTraceMark() {
        return this.buildMark();
    }

    public SampleFactory.Sample getSample(int index) {
        return this.factory.getSampleList().get(index);
    }

    public SampleFactory.Sample getSample(double[] x) throws SampleLimitException, ObjectiveAchievedException {
        SampleFactory.Sample s = this.factory.getSample(x, this.funct(x));
        return s;
    }

    private double[] funct(double[] x) throws ObjectiveAchievedException {
        double[] value = new double[this.m];
        this.setParameters(x);
        this.singleRun();
        for (int i = 0; i < this.m; ++i) {
            value[i] = this.effValue[i].getValue();
        }
        this.iterationCounter.setValue(this.iterationCounter.getValue() + 1);
        if (this.target != null && this.target.getValue().length == this.effValue.length) {
            boolean objectiveAchieved = true;
            for (int i = 0; i < this.effValue.length; ++i) {
                if (!(this.effValue[i].getValue() - this.target.getValue()[i] >= this.epsilonToTarget.getValue())) continue;
                objectiveAchieved = false;
            }
            if (objectiveAchieved) {
                double[] targets = new double[this.target.getValue().length];
                for (int i = 0; i < targets.length; ++i) {
                    targets[i] = this.target.getValue()[i];
                }
                throw new ObjectiveAchievedException(value, targets);
            }
        }
        return value;
    }

    protected void setParameters(double[] x) {
        for (int j = 0; j < this.parameter.length; ++j) {
            try {
                this.parameter[j].setValue(x[j]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Error_Parameter_No") + " " + j + " " + JAMS.i18n((String)"wasnt_found") + " " + e.toString());
            }
        }
    }

    public long getRunCount() {
        return this.iterationCounter.getValue();
    }

    public void run() {
        try {
            this.procedure();
        }
        catch (SampleLimitException e1) {
            System.out.println(e1);
        }
        catch (ObjectiveAchievedException e2) {
            System.out.println(e2);
        }
    }

    protected abstract void procedure() throws SampleLimitException, ObjectiveAchievedException;

    protected void singleRun() {
        Component comp;
        if (!this.doRun) {
            return;
        }
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.getMessage());
                e.printStackTrace();
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.getMessage());
                e.printStackTrace();
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.toString());
                e.printStackTrace();
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.getMessage());
                e.printStackTrace();
            }
        }
        this.updateEntityData();
        for (DataTracer dataTracer : this.dataTracers) {
            dataTracer.trace();
        }
    }

    public void cleanup() {
        for (DataTracer dataTracer : this.dataTracers) {
            dataTracer.endMark();
            dataTracer.close();
        }
    }
}

