/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import java.io.Serializable;
import java.util.HashMap;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.OptimizerParameter;

public class OptimizerDescription
implements Serializable {
    private String shortName;
    private String optimizerClassName;
    private int id;
    private HashMap<String, OptimizerParameter> propertyMap = new HashMap();
    private boolean multiObjective = false;
    private BooleanOptimizerParameter doSpatialRelaxation = new BooleanOptimizerParameter("spatialRelaxation", "do spatial relaxation", false);
    private BooleanOptimizerParameter assessNonUniqueness = new BooleanOptimizerParameter("assessNonUniqueness", "assess non uniqueness", false);
    private BooleanOptimizerParameter localSearchDuringRelaxation = new BooleanOptimizerParameter("localSearchDuringRelaxation", "local search during relaxation", true);
    private BooleanOptimizerParameter adaptiveRelaxation = new BooleanOptimizerParameter("adaptiveRelacation", "adaptive relaxation", false);

    public OptimizerDescription() {
        this.shortName = "Optimization Configuration";
    }

    public OptimizerDescription(String shortName, int id) {
        this.shortName = shortName;
        this.id = id;
    }

    public OptimizerDescription(String shortName, int id, boolean multiObjective) {
        this.shortName = shortName;
        this.multiObjective = multiObjective;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setOptimizerClassName(String className) {
        this.optimizerClassName = className;
    }

    public String getOptimizerClassName() {
        return this.optimizerClassName;
    }

    public void addParameter(OptimizerParameter param) {
        this.getPropertyMap().put(param.getName(), param);
    }

    public String toString() {
        return this.getShortName();
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public HashMap<String, OptimizerParameter> getPropertyMap() {
        return this.propertyMap;
    }

    public boolean isMultiObjective() {
        return this.multiObjective;
    }

    public void setMultiObjective(boolean multiObjective) {
        this.multiObjective = multiObjective;
    }

    public void setPropertyMap(HashMap<String, OptimizerParameter> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public BooleanOptimizerParameter getDoSpatialRelaxation() {
        return this.doSpatialRelaxation;
    }

    public void setDoSpatialRelaxation(BooleanOptimizerParameter doSpatialRelaxation) {
        this.doSpatialRelaxation = doSpatialRelaxation;
    }

    public BooleanOptimizerParameter getLocalSearchDuringRelaxation() {
        return this.localSearchDuringRelaxation;
    }

    public void setLocalSearchDuringRelaxation(BooleanOptimizerParameter localSearchDuringRelaxation) {
        this.localSearchDuringRelaxation = localSearchDuringRelaxation;
    }

    public BooleanOptimizerParameter getAdaptiveRelaxation() {
        return this.adaptiveRelaxation;
    }

    public void setAdaptiveRelacation(BooleanOptimizerParameter adaptiveRelaxation) {
        this.adaptiveRelaxation = adaptiveRelaxation;
    }

    public BooleanOptimizerParameter getAssessNonUniqueness() {
        return this.assessNonUniqueness;
    }

    public void setAssessNonUniqueness(BooleanOptimizerParameter assessNonUniqueness) {
        this.assessNonUniqueness = assessNonUniqueness;
    }
}

