/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.JAMS;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

public class ParticleSwarm
extends Optimizer {
    int numberOfParticles = 1000;
    Particle[] particles = new Particle[this.numberOfParticles];
    Particle bestParticle = null;
    double w = 0.9;
    double c1 = 0.7;
    double c2 = 1.4;
    double c3 = 0.0;

    @Override
    public OptimizerDescription getDescription() {
        return OptimizerLibrary.getDefaultOptimizerDescription(ParticleSwarm.class.getSimpleName(), ParticleSwarm.class.getName(), 500, false);
    }

    boolean feasible(double[] nextPosition) {
        for (int i = 0; i < this.n; ++i) {
            if (!(nextPosition[i] < this.lowBound[i]) && !(nextPosition[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        System.out.println(JAMS.i18n((String)"start_optimization_of"));
        for (int i = 0; i < this.numberOfParticles; ++i) {
            SampleFactory.SampleSO rndSample = null;
            rndSample = this.x0 != null && i < this.x0.length ? this.getSampleSO(this.x0[i]) : this.getSampleSO(this.randomSampler());
            this.particles[i] = new Particle(rndSample, new double[this.n]);
            if (this.bestParticle != null) {
                if (!(this.bestParticle.particle.f() > this.particles[i].particle.f())) continue;
                this.bestParticle = this.particles[i];
                continue;
            }
            this.bestParticle = this.particles[i];
        }
        while (true) {
            int i;
            double[] r1 = new double[this.n];
            double[] r2 = new double[this.n];
            double[] r3 = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                r1[i] = generator.nextDouble();
                r2[i] = generator.nextDouble();
                r3[i] = generator.nextDouble();
            }
            for (i = 0; i < this.numberOfParticles; ++i) {
                double[] nextPosition = new double[this.n];
                for (int j = 0; j < this.n; ++j) {
                    this.particles[i].velocity[j] = this.w * this.particles[i].velocity[j];
                    int n = j;
                    this.particles[i].velocity[n] = this.particles[i].velocity[n] - this.c1 * r1[j] * (this.particles[i].particle.x[j] - this.particles[i].local_best.x[j]);
                    int n2 = j;
                    this.particles[i].velocity[n2] = this.particles[i].velocity[n2] - this.c2 * r2[j] * (this.particles[i].particle.x[j] - this.bestParticle.local_best.x[j]);
                    int rndParticle = generator.nextInt(this.numberOfParticles);
                    int n3 = j;
                    this.particles[i].velocity[n3] = this.particles[i].velocity[n3] - this.c3 * r3[j] * (this.particles[i].particle.x[j] - this.particles[rndParticle].local_best.x[j]);
                    nextPosition[j] = this.particles[i].particle.x[j] + this.particles[i].velocity[j];
                }
                double beta = 0.5;
                while (!this.feasible(nextPosition)) {
                    for (int j = 0; j < this.n; ++j) {
                        int n = j;
                        nextPosition[n] = nextPosition[n] - beta * this.particles[i].velocity[j];
                    }
                }
                this.particles[i].particle = this.getSampleSO(nextPosition);
                if (this.particles[i].particle.f() < this.particles[i].local_best.f()) {
                    this.particles[i].local_best = this.particles[i].particle;
                }
                if (!(this.particles[i].particle.f() < this.bestParticle.local_best.f())) continue;
                this.bestParticle = this.particles[i];
            }
            this.log(JAMS.i18n((String)"current_best") + ":" + this.bestParticle.local_best.toString() + " " + JAMS.i18n((String)"after") + " " + this.getIterationCounter());
        }
    }

    public static class Particle {
        SampleFactory.SampleSO particle;
        SampleFactory.SampleSO local_best;
        double[] velocity;

        Particle(SampleFactory.SampleSO particle, double[] velocity) {
            this.particle = particle;
            this.local_best = particle;
            this.velocity = velocity;
        }
    }
}

