/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.JAMS;
import jams.data.DefaultDataFactory;
import jams.data.JAMSEntity;
import jams.model.JAMSComponentDescription;
import jams.tools.JAMSTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import optas.core.AbstractFunction;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.datamining.GaussianLearner;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.SCE;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.StringOptimizerParameter;

@JAMSComponentDescription(title="NNOptimizer", author="Christian Fischer", description="under construction!!")
public class GPSearch
extends Optimizer {
    private String outputFileName;
    private String modelGridFileName;
    private Boolean writeGPData;
    public int gaussProcessMethod;
    ArrayList<double[]> TrainData = new ArrayList();
    ArrayList<double[]> samplePoint = new ArrayList();
    ArrayList<Double> sampleValue = new ArrayList();
    final int initalSampleSize = 25;
    double maxValue = Double.NEGATIVE_INFINITY;
    double minValue = Double.POSITIVE_INFINITY;
    double[] minPosition = null;
    int createCount = 0;
    double[] params = new double[this.n * this.n + 5 * this.n];
    GaussianLearner GP = null;
    int lastTrainingSize = 0;
    final int PerformanceMeasure = 2;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(GPSearch.class.getSimpleName(), GPSearch.class.getName(), 250, false);
        desc.addParameter(new NumericOptimizerParameter("gaussProcessMethod", "Gaussian Process Method used for optimization", 6.0, 0.0, 20.0));
        desc.addParameter(new StringOptimizerParameter("outputFileName", "File to write data log", "out.log"));
        desc.addParameter(new StringOptimizerParameter("writeGPData", "File to write gaussian regression log", "gp.log"));
        desc.addParameter(new StringOptimizerParameter("modelGridFileName", "File to write model grid", "grid.dat"));
        return desc;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public String getModelGridFileName() {
        return this.modelGridFileName;
    }

    public void setModelGridFileName(String modelGridFileName) {
        this.modelGridFileName = modelGridFileName;
    }

    public Boolean getWriteGPData() {
        return this.writeGPData;
    }

    public void setWriteGPData(Boolean writeGPData) {
        this.writeGPData = writeGPData;
    }

    public double getGaussProcessMethod() {
        return this.gaussProcessMethod;
    }

    public void setGaussProcessMethod(double gaussProcessMethod) {
        this.gaussProcessMethod = (int)gaussProcessMethod;
    }

    SampleFactory.SampleSO TransformAndEvaluate(double[] in) throws SampleLimitException, ObjectiveAchievedException {
        double[] value = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            value[i] = in[i] * (this.upBound[i] - this.lowBound[i]) + this.lowBound[i];
        }
        return this.getSampleSO(value);
    }

    GaussianLearner CreateGPModel(ArrayList<double[]> samplePoint, ArrayList<Double> sampleValue) {
        if (this.GP == null || this.createCount % 10 == 0) {
            this.GP = new GaussianLearner();
            this.GP.MeanMethod = DefaultDataFactory.getDataFactory().createInteger();
            this.GP.MeanMethod.setValue(0);
            this.GP.PerformanceMeasure = DefaultDataFactory.getDataFactory().createInteger();
            this.GP.PerformanceMeasure.setValue(2);
            this.GP.mode = DefaultDataFactory.getDataFactory().createInteger();
            this.GP.mode.setValue(2);
            this.GP.kernelMethod = DefaultDataFactory.getDataFactory().createInteger();
            this.GP.kernelMethod.setValue(8);
            this.GP.resultFile = DefaultDataFactory.getDataFactory().createString();
            this.GP.resultFile.setValue("tmp.dat");
            this.GP.param_theta = DefaultDataFactory.getDataFactory().createDoubleArray();
            if (this.createCount == 0) {
                int i;
                this.params = new double[this.n * this.n + 5 * this.n];
                for (i = 0; i < this.params.length; ++i) {
                    this.params[i] = 2.71;
                }
                for (i = 0; i < this.n; ++i) {
                    this.params[i * (this.n + 2)] = 2.71;
                }
            }
            this.GP.param_theta.setValue(this.params);
            double[][] data = new double[samplePoint.size()][];
            for (int i = 0; i < samplePoint.size(); ++i) {
                data[i] = samplePoint.get(i);
            }
            double[] predict = new double[sampleValue.size()];
            for (int i = 0; i < sampleValue.size(); ++i) {
                predict[i] = sampleValue.get(i);
            }
            this.GP.trainData = DefaultDataFactory.getDataFactory().createEntity();
            this.GP.trainData.setObject("data", (Object)data);
            this.GP.trainData.setObject("predict", (Object)predict);
            this.GP.optimizationData = (JAMSEntity)DefaultDataFactory.getDataFactory().createEntity();
            this.GP.optimizationData.setObject("data", (Object)data);
            this.GP.optimizationData.setObject("predict", (Object)predict);
            this.GP.run();
            this.lastTrainingSize = samplePoint.size();
        } else if (this.createCount % 10 != 0) {
            for (int i = this.lastTrainingSize; i < samplePoint.size(); ++i) {
                this.GP.RetrainWithANewObservation(2, samplePoint.get(i), sampleValue.get(i));
            }
            this.lastTrainingSize = samplePoint.size();
        }
        ++this.createCount;
        return this.GP;
    }

    public void WriteSamples(ArrayList<Double> sampleValue, ArrayList<double[]> samplePoint, String file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.getWorkspace().getAbsolutePath() + "/" + file));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JAMSTools.handle((Throwable)ioe);
        }
        for (int i = 0; i < samplePoint.size(); ++i) {
            try {
                double[] point = samplePoint.get(i);
                double value = sampleValue.get(i);
                for (int j = 0; j < point.length; ++j) {
                    writer.write(point[j] + "\t");
                }
                writer.write(value + "\n");
                continue;
            }
            catch (Exception e) {
                System.out.println(JAMS.i18n((String)"Error") + " " + e.toString());
            }
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void WriteGPData(GaussianLearner GP, String GPmeanFile, String GPvarFile) {
        if (this.n != 2) {
            System.out.println(JAMS.i18n((String)"Skip_rasterized_output"));
            return;
        }
        BufferedWriter writer_mean = null;
        BufferedWriter writer_var = null;
        try {
            writer_mean = new BufferedWriter(new FileWriter(this.getWorkspace().getAbsolutePath() + "/" + GPmeanFile));
            writer_var = new BufferedWriter(new FileWriter(this.getWorkspace().getAbsolutePath() + "/" + GPvarFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JAMSTools.handle((Throwable)ioe);
        }
        for (int i = 0; i < 51; ++i) {
            for (int j = 0; j < 51; ++j) {
                double[] x = new double[]{0.0 + (double)i / 50.0, 0.0 + (double)j / 50.0};
                double mean = GP.getMean(x);
                double variance = GP.getVariance(x);
                try {
                    writer_mean.write(mean + "\t");
                    writer_var.write(variance + "\t");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(JAMS.i18n((String)"Error") + " " + e.toString());
                }
            }
            try {
                writer_mean.write("\n");
                writer_var.write("\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(JAMS.i18n((String)"Error") + " " + e.toString());
            }
        }
        try {
            writer_mean.close();
            writer_var.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void WriteGPProb(GaussianLearner GP, String GPprobFile, double target, int method) {
        if (this.n != 2) {
            System.out.println(JAMS.i18n((String)"Skip_rasterized_output"));
            return;
        }
        BufferedWriter writer_prob = null;
        try {
            writer_prob = new BufferedWriter(new FileWriter(this.getWorkspace().getAbsolutePath() + "/" + GPprobFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JAMSTools.handle((Throwable)ioe);
        }
        GaussEffFunction function = new GaussEffFunction();
        function.GP = GP;
        function.target = target;
        function.method = method;
        for (int i = 0; i < 51; ++i) {
            for (int j = 0; j < 51; ++j) {
                double[] x = new double[]{0.0 + (double)i / 50.0, 0.0 + (double)j / 50.0};
                double mean = GP.getMean(x);
                double optprob = function.evaluate(x)[0];
                try {
                    writer_prob.write(optprob + "\t");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(JAMS.i18n((String)"Error") + " " + e.toString());
                }
            }
            try {
                writer_prob.write("\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(JAMS.i18n((String)"Error") + " " + e.toString());
            }
        }
        try {
            writer_prob.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public double[] FindMostProbablePoint(double[] startpoint, GaussianLearner GP, double target, int method) {
        double[] best = new double[this.n];
        double value = -1.0E23;
        double cumulatedProb = 0.0;
        if (this.n != -1) {
            double[] normedLowBound = new double[this.n];
            double[] normedUpBound = new double[this.n];
            for (int i = 0; i < this.n; ++i) {
                normedLowBound[i] = 0.0;
                normedUpBound[i] = 1.0;
            }
            GaussEffFunction function = new GaussEffFunction();
            function.GP = GP;
            function.target = target;
            function.method = method;
            SCE optimizer = new SCE();
            optimizer.setStartValue(startpoint);
            optimizer.setWorkspace(this.getWorkspace());
            optimizer.complexesCount = 3.0;
            optimizer.setMaxn(10000.0);
            optimizer.pcento = 0.05;
            optimizer.kstop = 12.0;
            optimizer.peps = 1.0E-4;
            optimizer.setFunction(function);
            best = optimizer.optimize().get((int)0).x;
        } else {
            GaussEffFunction function = new GaussEffFunction();
            function.GP = GP;
            function.target = target;
            function.method = method;
            for (int i = 0; i < 51; ++i) {
                for (int j = 0; j < 51; ++j) {
                    double[] x = new double[]{0.0 + (double)i / 50.0, 0.0 + (double)j / 50.0};
                    double prob = function.evaluate(x)[0];
                    if (!(prob >= value)) continue;
                    best = x;
                    value = prob;
                }
            }
        }
        return best;
    }

    public ArrayList<double[]> cluster(ArrayList<double[]> set) {
        ArrayList clusterset = new ArrayList();
        for (int i = 0; i < set.size(); ++i) {
            int k;
            double best = 1.0E11;
            int bestindex = -1;
            for (int j = 0; j < clusterset.size(); ++j) {
                for (k = 0; k < ((ArrayList)clusterset.get(j)).size(); ++k) {
                    double d = 0.0;
                    for (int l = 0; l < this.n; ++l) {
                        d += (((double[])((ArrayList)clusterset.get(j)).get(k))[l] - set.get(i)[l]) * (((double[])((ArrayList)clusterset.get(j)).get(k))[l] - set.get(i)[l]);
                    }
                    if (!(d < best)) continue;
                    best = d;
                    bestindex = j;
                }
            }
            if (bestindex == -1 || best > 0.05) {
                ArrayList<double[]> nextCluster = new ArrayList<double[]>();
                nextCluster.add(set.get(i));
                clusterset.add(nextCluster);
                continue;
            }
            double[] newPoint = new double[this.n];
            for (k = 0; k < this.n; ++k) {
            }
            ((ArrayList)clusterset.get(bestindex)).add(set.get(i));
        }
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (int j = 0; j < clusterset.size(); ++j) {
            result.add((double[])((ArrayList)clusterset.get(j)).get(((ArrayList)clusterset.get(j)).size() - 1));
        }
        return result;
    }

    public boolean inList(ArrayList<double[]> list, double[] point) {
        for (int j = 0; j < list.size(); ++j) {
            double[] sampleInList = list.get(j);
            double d = 0.0;
            for (int k = 0; k < this.n; ++k) {
                d += (sampleInList[k] - point[k]) * (sampleInList[k] - point[k]);
            }
            if (!(d < 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    public void initalPhase() {
        GaussianLearner.BuildGaussDistributionTable();
        for (int i = 0; i < this.n * 25; ++i) {
            double[] nextSample = this.randomSampler();
            if (i == 0 && this.x0 != null) {
                nextSample = Arrays.copyOf(this.x0[0], this.n);
            }
            for (int j = 0; j < this.n; ++j) {
                nextSample[j] = (nextSample[j] - this.lowBound[j]) / (this.upBound[j] - this.lowBound[j]);
            }
            this.samplePoint.add(nextSample);
            SampleFactory.SampleSO value = null;
            try {
                value = this.TransformAndEvaluate(nextSample);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e);
                return;
            }
            if (value.f() < this.minValue) {
                this.minValue = value.f();
                this.minPosition = nextSample;
            } else if (value.f() > this.maxValue) {
                this.maxValue = value.f();
            }
            this.sampleValue.add(value.f());
        }
    }

    public ArrayList<double[]> searchPhase_MaxExpectedImprovement(GaussianLearner GP) {
        ArrayList<double[]> bestPoints = new ArrayList<double[]>();
        bestPoints.add(this.FindMostProbablePoint(this.minPosition, GP, this.minValue, 2));
        System.out.println(JAMS.i18n((String)"Expected_Improvement") + GP.getExpectedImprovement((double[])bestPoints.get(0), this.minValue));
        if (this.getWriteGPData() != null && this.getWriteGPData().booleanValue()) {
            this.WriteGPProb(GP, "\\info\\gp_eimpr_" + this.factory.getSize() + ".dat", this.minValue, 2);
        }
        return bestPoints;
    }

    public ArrayList<double[]> searchPhase_MaxProbOfImprovement(GaussianLearner GP) {
        double[] T = new double[]{0.0, 1.0E-4, 0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0};
        ArrayList<double[]> bestPoints = new ArrayList<double[]>();
        for (int i = 0; i < T.length; ++i) {
            double opt = this.minValue - T[i] * (this.maxValue - this.minValue);
            if (this.getWriteGPData() != null && this.getWriteGPData().booleanValue()) {
                this.WriteGPProb(GP, "\\info\\gp_prob" + this.factory.getSize() + "_T" + T[i] + ".dat", opt, 1);
            }
            bestPoints.add(this.FindMostProbablePoint(this.minPosition, GP, opt, 1));
        }
        return this.cluster(bestPoints);
    }

    public ArrayList<double[]> searchPhase_MaximalLikelihood(GaussianLearner GP) {
        double[] T = new double[]{0.0, 1.0E-4, 0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0};
        ArrayList<double[]> bestPoints = new ArrayList<double[]>();
        for (int i = 0; i < T.length; ++i) {
            double opt = this.minValue - T[i] * (this.maxValue - this.minValue);
            if (this.getWriteGPData() != null && this.getWriteGPData().booleanValue()) {
                this.WriteGPProb(GP, "\\info\\gp_prob" + this.factory.getSize() + "_T" + T[i] + ".dat", opt, 3);
            }
            bestPoints.add(this.FindMostProbablePoint(this.minPosition, GP, opt, 3));
        }
        return this.cluster(bestPoints);
    }

    @Override
    protected void procedure() {
        this.initalPhase();
        while (true) {
            GaussianLearner GP = this.CreateGPModel(this.samplePoint, this.sampleValue);
            if (this.getWriteGPData() != null && this.getWriteGPData().booleanValue()) {
                this.WriteGPData(GP, "/info/gp_mean" + this.factory.getSize() + ".dat", "/info/gp_variance" + this.factory.getSize() + ".dat");
            }
            ArrayList<double[]> nextSamples = null;
            switch ((int)this.getGaussProcessMethod()) {
                case 1: {
                    nextSamples = this.searchPhase_MaxProbOfImprovement(GP);
                }
                case 2: {
                    nextSamples = this.searchPhase_MaxExpectedImprovement(GP);
                }
                case 3: {
                    nextSamples = this.searchPhase_MaximalLikelihood(GP);
                }
            }
            nextSamples = null;
            for (int i = 0; i < nextSamples.size(); ++i) {
                boolean pointInList = true;
                double[] nextSample = nextSamples.get(i);
                while (pointInList) {
                    pointInList = this.inList(this.samplePoint, nextSample);
                    if (!pointInList) continue;
                    nextSample = this.randomSampler();
                    for (int j = 0; j < this.n; ++j) {
                        nextSample[j] = (nextSample[j] - this.lowBound[j]) / (this.upBound[j] - this.lowBound[j]);
                    }
                }
                this.samplePoint.add(nextSample);
                SampleFactory.SampleSO value = null;
                try {
                    value = this.TransformAndEvaluate(nextSample);
                }
                catch (SampleLimitException sle) {
                    return;
                }
                catch (ObjectiveAchievedException oae) {
                    return;
                }
                if (value.f() < this.minValue) {
                    this.minValue = value.f();
                    this.minPosition = nextSample;
                } else if (value.f() > this.maxValue) {
                    this.maxValue = value.f();
                }
                this.sampleValue.add(value.f());
                for (int j = 0; j < this.n; ++j) {
                    System.out.println(nextSample[j] + " ");
                }
                this.log(JAMS.i18n((String)"value") + ":" + value);
            }
            this.log(JAMS.i18n((String)"Evaluations") + ":" + this.factory.getSize() + "\n" + JAMS.i18n((String)"Minimum") + ":" + this.minValue);
        }
    }

    class DVector {
        double[] value;

        DVector(int d) {
            this.value = new double[d];
        }

        public String toString() {
            String r = new String();
            for (int i = 0; i < this.value.length; ++i) {
                r = r + this.value[i] + "\t";
            }
            return r;
        }
    }

    public class GaussEffFunction
    extends AbstractFunction {
        GaussianLearner GP = null;
        double target;
        int method;

        @Override
        public String[] getInputFactorNames() {
            String[] names = new String[GPSearch.this.n];
            for (int i = 0; i < GPSearch.this.n; ++i) {
                names[i] = "p_" + i;
            }
            return names;
        }

        @Override
        public int getInputDimension() {
            return GPSearch.this.n;
        }

        @Override
        public double[][] getRange() {
            double[][] range = new double[GPSearch.this.n][2];
            for (int i = 0; i < GPSearch.this.n; ++i) {
                range[i][0] = GPSearch.this.lowBound[i];
                range[i][1] = GPSearch.this.upBound[i];
            }
            return range;
        }

        @Override
        public String[] getOutputFactorNames() {
            return new String[]{"GaussEff"};
        }

        @Override
        public int getOutputDimension() {
            return GPSearch.this.m;
        }

        @Override
        public void log(String s) {
            GPSearch.this.log(s);
        }

        @Override
        public double[] evaluate(double[] x) {
            if (this.method == 1) {
                return new double[]{this.GP.getProbabilityForXLessY(x, this.target)};
            }
            if (this.method == 2) {
                return new double[]{this.GP.getExpectedImprovement(x, this.target)};
            }
            return new double[]{this.GP.getMarginalLikelihoodWithAdditionalSample(x, this.target)};
        }
    }
}

