/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import jams.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import optas.core.AbstractFunction;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.Statistics;
import optas.optimizer.management.StringOptimizerParameter;

public abstract class Optimizer
implements Serializable,
Comparable {
    private String[] parameterNames;
    protected double[] lowBound;
    protected double[] upBound;
    protected double[][] x0;
    protected String[] objNames;
    protected int n;
    protected int m;
    protected static Random generator;
    private boolean debugMode = false;
    private AbstractFunction function;
    public double maxn;
    public boolean verbose = true;
    int sampleCount = 0;
    File workspace = null;
    File outputFile = null;
    private ArrayList<SampleFactory.Sample> solution = null;
    protected Model model = null;
    protected transient SampleFactory factory = new SampleFactory();

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    protected void log(String msg) {
        if (this.verbose) {
            this.function.log(msg);
        }
    }

    public void injectSamples(Collection<? extends SampleFactory.Sample> list) throws SampleLimitException, ObjectiveAchievedException {
        for (SampleFactory.Sample sample : list) {
            if (this.isObjectiveAchieved(sample)) {
                throw new ObjectiveAchievedException(sample.x, sample.F());
            }
            this.factory.injectSample(sample);
        }
        if ((double)this.factory.getSampleList().size() > this.maxn) {
            throw new SampleLimitException();
        }
    }

    protected boolean isObjectiveAchieved(SampleFactory.Sample s) {
        return false;
    }

    public AbstractFunction getFunction() {
        return this.function;
    }

    public Statistics getStatistics() {
        return this.factory.getStatistics();
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public ArrayList<SampleFactory.Sample> getSamples() {
        return this.factory.getSampleList();
    }

    public ArrayList<SampleFactory.Sample> getSolution() {
        if (this.solution != null) {
            return this.solution;
        }
        this.solution = this.factory.getStatistics().getParetoFront();
        return this.solution;
    }

    public SampleFactory.SampleSO getSampleSO(double[] x) throws SampleLimitException, ObjectiveAchievedException {
        return this.factory.getSampleSO(x, this.evaluate(x)[0]);
    }

    public SampleFactory.Sample getSample(double[] x) throws SampleLimitException, ObjectiveAchievedException {
        return this.factory.getSample(x, this.evaluate(x));
    }

    private double[] evaluate(double[] x) throws SampleLimitException, ObjectiveAchievedException {
        int n = this.sampleCount++;
        if ((double)n >= this.getMaxn()) {
            throw new SampleLimitException();
        }
        return this.function.evaluate(x);
    }

    public void setFunction(AbstractFunction function) {
        this.function = function;
        this.parameterNames = function.getInputFactorNames();
        this.objNames = function.getOutputFactorNames();
        this.n = function.getInputDimension();
        this.m = function.getOutputDimension();
        this.lowBound = new double[this.n];
        this.upBound = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.lowBound[i] = function.getRange()[i][0];
            this.upBound[i] = function.getRange()[i][1];
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setStartValue(double[][] startValue) {
        this.x0 = startValue;
    }

    public void setStartValue(double[] startValue) {
        this.x0 = new double[][]{startValue};
    }

    private Field getField(Class o, String name) {
        try {
            return o.getField(name);
        }
        catch (NoSuchFieldException e) {
            if (o.getSuperclass() == null) {
                return null;
            }
            return this.getField(o.getSuperclass(), name);
        }
    }

    public void setSetup(OptimizerParameter p) {
        Field f = this.getField(this.getClass(), p.getName());
        if (f == null) {
            System.out.println("Field " + p.getName() + " not found!");
            return;
        }
        try {
            if (p instanceof BooleanOptimizerParameter) {
                f.setBoolean(this, ((BooleanOptimizerParameter)p).isValue());
            }
            if (p instanceof NumericOptimizerParameter) {
                try {
                    f.setDouble(this, ((NumericOptimizerParameter)p).getValue());
                }
                catch (IllegalArgumentException iea) {
                    try {
                        f.setFloat(this, (float)((NumericOptimizerParameter)p).getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        f.setInt(this, (int)((NumericOptimizerParameter)p).getValue());
                    }
                }
            }
            if (p instanceof StringOptimizerParameter) {
                f.set(this, ((StringOptimizerParameter)p).getValue());
            }
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
    }

    public double getMaxn() {
        return this.maxn;
    }

    public void setMaxn(double maxn) {
        this.maxn = (int)maxn;
    }

    public void setDebugMode(boolean flag) {
        this.debugMode = flag;
    }

    protected boolean checkConfiguration() {
        int i;
        this.log("Checking optimizer configuration");
        if (this.n == 0) {
            this.log("Failure: optimization cannot start, because the number of parameters in unknown");
            return false;
        }
        if (this.m == 0) {
            this.log("Failure: optimization cannot start, because the number of objectives in unknown");
            return false;
        }
        if (this.parameterNames == null || this.parameterNames.length != this.n) {
            this.parameterNames = new String[this.n];
            for (i = 0; i < this.n; ++i) {
                this.parameterNames[i] = "param_" + i;
            }
        }
        if (this.objNames == null || this.objNames.length != this.m) {
            this.objNames = new String[this.m];
            for (i = 0; i < this.m; ++i) {
                this.objNames[i] = "obj_" + i;
            }
        }
        if (this.lowBound.length != this.n || this.upBound.length != this.n) {
            this.log("Failure: optimization cannot start, because the number of bounds does not match");
            return false;
        }
        for (i = 0; i < this.n; ++i) {
            if (!(this.lowBound[i] > this.upBound[i])) continue;
            this.log("Failure: optimization cannot start, because an upper bound is lower than a lower bound!");
            return false;
        }
        if (this.getMaxn() < 0.0) {
            this.setMaxn(500.0);
        }
        if (this.workspace == null) {
            this.log("Warning: workspace was not setup! Set to current directory");
            this.workspace = new File(System.getProperty("user.dir"));
        }
        return true;
    }

    public boolean init() {
        this.log("Initialize Optimizer");
        if (!this.checkConfiguration()) {
            return false;
        }
        generator = !this.debugMode ? new Random(System.nanoTime()) : new Random(0L);
        return true;
    }

    protected double randomValue() {
        return generator.nextDouble();
    }

    protected double[] randomSampler() {
        double[] sample = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            sample[i] = this.lowBound[i] + this.randomValue() * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    protected int getIterationCounter() {
        return this.factory.getSize();
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(File ws) {
        this.workspace = ws;
    }

    public void setOutputFile(String name) {
        this.outputFile = new File(this.workspace.getAbsolutePath() + "/" + name);
    }

    protected int getMaximumIterationCount() {
        return (int)this.maxn;
    }

    public void printSamples() {
        int j;
        int i;
        this.log("Listing of all samples drawn during optimization");
        String line1 = "";
        String header = "";
        for (i = 0; i < this.n; ++i) {
            if (this.parameterNames[i] == null) {
                this.parameterNames[i] = "p" + i;
            }
            for (j = 0; j < this.parameterNames[i].length(); ++j) {
                line1 = line1 + "-";
            }
            line1 = line1 + "---";
            header = header + this.parameterNames[i] + "\t";
        }
        for (i = 0; i < this.m; ++i) {
            if (this.objNames[i] == null) {
                this.objNames[i] = "obji";
            }
            for (j = 0; j < this.objNames[i].length(); ++j) {
                line1 = line1 + "-";
            }
            line1 = line1 + "---";
            header = header + this.objNames[i] + "\t";
        }
        this.log(line1);
        this.log(header);
        for (SampleFactory.Sample s : this.factory.getSampleList()) {
            this.log(s.toString());
        }
        this.log(line1);
    }

    protected abstract void procedure() throws SampleLimitException, ObjectiveAchievedException;

    public ArrayList<SampleFactory.Sample> optimize() {
        if (!this.init()) {
            return null;
        }
        try {
            this.procedure();
        }
        catch (SampleLimitException sle) {
            this.log(JAMS.i18n((String)"Optimization_finished_because_of_the_number_of_allowed_samples_is_reached"));
        }
        catch (ObjectiveAchievedException oae) {
            this.log(JAMS.i18n((String)"Optimization_finished_because_the_objective_was_archieved!"));
        }
        this.printSamples();
        return this.getSolution();
    }

    public abstract OptimizerDescription getDescription();

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        this.factory = new SampleFactory();
    }
}

