/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.StringOptimizerParameter;
import optas.optimizer.parallel.ParallelSequence;

public class NSGA2
extends Optimizer {
    public double populationSize = 30.0;
    public double crossoverProbability = 0.9;
    public double mutationProbability = 1.0;
    public double crossoverDistributionIndex = 20.0;
    public double mutationDistributionIndex = 20.0;
    public int maxGeneration = 1000;
    public boolean parallelExecution = false;
    public double threadCount = 12.0;
    public String excludeFiles = "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log";
    int crossoverCount = 0;
    int mutationCount = 0;
    ParallelSequence pseq = null;
    SampleFactory.SampleComperator moComparer = new SampleFactory.SampleComperator(false);
    CustomRand generator = null;
    transient DataCollection collection = null;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(NSGA2.class.getSimpleName(), NSGA2.class.getName(), 500, false);
        desc.addParameter(new NumericOptimizerParameter("populationSize", JAMS.i18n((String)"size_of_population"), 30.0, 1.0, 100000.0));
        desc.addParameter(new NumericOptimizerParameter("crossoverProbability", JAMS.i18n((String)"propability_for_crossover"), 0.9, 0.0, 1.0));
        desc.addParameter(new NumericOptimizerParameter("mutationProbability", JAMS.i18n((String)"propability_for_mutations"), 1.0, 0.5, 1.0));
        desc.addParameter(new NumericOptimizerParameter("crossoverDistributionIndex", JAMS.i18n((String)"distribution_index_for_crossover"), 20.0, 1.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("mutationDistributionIndex", JAMS.i18n((String)"distribution_index_for_mutation"), 20.0, 1.0, 500.0));
        desc.addParameter(new NumericOptimizerParameter("maxGeneration", JAMS.i18n((String)"maximum_number_of_generations"), 1000.0, 1.0, 10000.0));
        desc.addParameter(new StringOptimizerParameter("excludeFiles", JAMS.i18n((String)"exclude_files_list"), "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log"));
        desc.addParameter(new NumericOptimizerParameter("threadCount", JAMS.i18n((String)"threadCount"), 8.0, 2.0, 100.0));
        desc.addParameter(new BooleanOptimizerParameter("parallelExecution", JAMS.i18n((String)"parallelExecution"), false));
        return desc;
    }

    public double getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(double populationSize) {
        this.populationSize = populationSize;
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    public double getCrossoverDistributionIndex() {
        return this.crossoverDistributionIndex;
    }

    public void setCrossoverDistributionIndex(double crossoverDistributionIndex) {
        this.crossoverDistributionIndex = crossoverDistributionIndex;
    }

    public double getMutationDistributionIndex() {
        return this.mutationDistributionIndex;
    }

    public void setMutationDistributionIndex(double mutationDistributionIndex) {
        this.mutationDistributionIndex = mutationDistributionIndex;
    }

    public double getMaxGeneration() {
        return this.maxGeneration;
    }

    public void setMaxGeneration(double maxGeneration) {
        this.maxGeneration = (int)maxGeneration;
    }

    public void setThreadCount(double threadCount) {
        this.threadCount = (int)threadCount;
    }

    public double getThreadCount() {
        return this.threadCount;
    }

    public boolean isParallelExecution() {
        return this.parallelExecution;
    }

    public void setParallelExecution(boolean parallelExecution) {
        this.parallelExecution = parallelExecution;
    }

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(String excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    @Override
    protected double randomValue() {
        return Optimizer.generator.nextDouble();
    }

    private void ranking(Population population) {
        int rnk = 0;
        int nondom = 0;
        int[] flag = new int[population.size];
        Arrays.fill(flag, 2);
        int q = 0;
        for (int k = 0; k < population.size; ++k) {
            int j;
            for (j = 0; j < population.size && flag[j] == 1; ++j) {
            }
            if (j == population.size) break;
            ++rnk;
            for (j = 0; j < population.size; ++j) {
                if (flag[j] != 0) continue;
                flag[j] = 2;
            }
            for (int i = 0; i < population.size; ++i) {
                if (flag[i] == 1 || flag[i] == 0) continue;
                for (j = 0; j < population.size; ++j) {
                    if (i == j || flag[j] == 1) continue;
                    int val = this.moComparer.compare(population.ind[i].sample, population.ind[j].sample);
                    if (val == 1) {
                        flag[i] = 0;
                        break;
                    }
                    if (val == -1) {
                        flag[j] = 0;
                    }
                    if (val != 0) continue;
                    ++nondom;
                    if (flag[j] == 0) continue;
                    flag[j] = 3;
                }
                if (j != population.size) continue;
                population.ind[i].rank = rnk;
                flag[i] = 1;
                ++q;
            }
            population.rankno[rnk - 1] = q;
            q = 0;
        }
        population.maxrank = rnk;
        for (int i = 0; i < population.size; ++i) {
            if (population.ind[i].rank <= population.maxrank) continue;
            population.maxrank = population.ind[i].rank;
        }
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.crossoverCount = 0;
        this.mutationCount = 0;
        if (this.mutationProbability > 1.0 / (double)this.n) {
            this.mutationProbability = 1.0 / (double)this.n;
        }
        if (this.parallelExecution) {
            this.pseq = new ParallelSequence(this);
            this.pseq.setExcludeFiles(this.excludeFiles);
            this.pseq.setThreadCount((int)this.threadCount);
        }
        return true;
    }

    void nselect(Population old_pop, Population pop2) {
        int n = 0;
        int k = 0;
        while (n < old_pop.size) {
            int rnd1 = (int)Math.floor(this.randomValue() * (double)old_pop.size);
            int rnd2 = (int)Math.floor(this.randomValue() * (double)old_pop.size);
            if (rnd1 == 0) {
                rnd1 = old_pop.size - k;
            }
            if (rnd2 == 0) {
                rnd2 = old_pop.size - n;
            }
            if (rnd1 == old_pop.size) {
                rnd1 = (old_pop.size - 2) / 2;
            }
            if (rnd2 == old_pop.size) {
                rnd2 = (old_pop.size - 4) / 2;
            }
            int j = rnd1 - 1;
            int j1 = rnd2 - 1;
            pop2.ind[k] = old_pop.ind[j].rank > old_pop.ind[j1].rank ? old_pop.ind[j1] : (old_pop.ind[j].rank < old_pop.ind[j1].rank ? old_pop.ind[j] : (old_pop.ind[j].cub_len < old_pop.ind[j1].cub_len ? old_pop.ind[j1] : old_pop.ind[j]));
            ++n;
            ++k;
        }
    }

    double[][] realcross(Population mate_pop) {
        int nvar = mate_pop.ind[0].sample.getParameter().length;
        double[][] newParameter = new double[mate_pop.size][nvar];
        int k = 0;
        int y = 0;
        for (int i = 0; i < mate_pop.size / 2; ++i) {
            int j;
            double rnd = this.randomValue();
            if (rnd <= this.getCrossoverProbability()) {
                for (j = 0; j < nvar; ++j) {
                    double chld2;
                    double chld1;
                    double par1 = mate_pop.ind[y].sample.getParameter()[j];
                    double par2 = mate_pop.ind[y + 1].sample.getParameter()[j];
                    double yl = this.lowBound[j];
                    double yu = this.upBound[j];
                    double y1 = par1;
                    double y2 = par2;
                    rnd = this.randomValue();
                    if (rnd <= 0.5) {
                        ++this.crossoverCount;
                        double betaq = 1.0;
                        if (Math.abs(par1 - par2) > 1.0E-8) {
                            double expp;
                            double beta;
                            double alpha;
                            if (par2 <= par1) {
                                y1 = par2;
                                y2 = par1;
                            }
                            if ((alpha = 2.0 - Math.pow(beta = y1 - yl > yu - y2 ? 1.0 / (1.0 + 2.0 * (yu - y2) / (y2 - y1)) : 1.0 / (1.0 + 2.0 * (y1 - yl) / (y2 - y1)), expp = this.getCrossoverDistributionIndex() + 1.0)) < 0.0) {
                                this.log("ERRRROR: " + alpha + " " + y + " " + k + " " + par1 + " " + par2);
                                System.exit(-1);
                            }
                            alpha *= this.randomValue();
                            expp = 1.0 / (this.getCrossoverDistributionIndex() + 1.0);
                            if (alpha > 1.0) {
                                alpha = 1.0 / (2.0 - alpha);
                            }
                            betaq = Math.pow(alpha, expp);
                        }
                        chld1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
                        chld2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
                        if (chld1 < yl) {
                            chld1 = yl;
                        }
                        if (chld1 > yu) {
                            chld1 = yu;
                        }
                        if (chld2 < yl) {
                            chld2 = yl;
                        }
                        if (chld2 > yu) {
                            chld2 = yu;
                        }
                    } else {
                        chld1 = par1;
                        chld2 = par2;
                    }
                    newParameter[k][j] = chld1;
                    newParameter[k + 1][j] = chld2;
                }
            } else {
                for (j = 0; j < nvar; ++j) {
                    newParameter[k][j] = mate_pop.ind[y].sample.getParameter()[j];
                    newParameter[k + 1][j] = mate_pop.ind[y + 1].sample.getParameter()[j];
                }
            }
            k += 2;
            y += 2;
        }
        return newParameter;
    }

    void real_mutate(double[][] new_pop) {
        int popSize = new_pop.length;
        int nvar = new_pop[0].length;
        double indi = 1.0 / (this.getMutationDistributionIndex() + 1.0);
        for (int j = 0; j < popSize; ++j) {
            for (int i = 0; i < nvar; ++i) {
                double rnd = this.randomValue();
                if (!(rnd <= this.getMutationProbability())) continue;
                double y = new_pop[j][i];
                double yl = this.lowBound[i];
                double yu = this.upBound[i];
                double delta = 0.0;
                if (y > yl) {
                    double deltaq;
                    double val;
                    delta = y - yl < yu - y ? 1.0 - (y - yl) / (yu - yl) : 1.0 - (yu - y) / (yu - yl);
                    rnd = this.randomValue();
                    if (rnd <= 0.5) {
                        val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(delta, this.getMutationDistributionIndex() + 1.0);
                        deltaq = Math.pow(val, indi) - 1.0;
                    } else {
                        val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(delta, this.getMutationDistributionIndex() + 1.0);
                        deltaq = 1.0 - Math.pow(val, indi);
                    }
                    y += deltaq * (yu - yl);
                    if (y < yl) {
                        y = yl;
                    }
                    if (y > yu) {
                        y = yu;
                    }
                    new_pop[j][i] = y;
                } else {
                    new_pop[j][i] = this.randomValue() * (yu - yl) + yl;
                }
                ++this.mutationCount;
            }
        }
    }

    void grank(int gen, Population globalPopulation) {
        this.log("Genration no. = " + gen);
        int[] gflg = new int[globalPopulation.size];
        int rnk = 0;
        int nondom = 0;
        Arrays.fill(gflg, 2);
        for (int k = 0; k < globalPopulation.size; ++k) {
            int j = 0;
            int q = 0;
            for (j = 0; j < globalPopulation.size && gflg[j] == 1; ++j) {
            }
            if (j == globalPopulation.size) break;
            ++rnk;
            for (j = 0; j < globalPopulation.size; ++j) {
                if (gflg[j] != 0) continue;
                gflg[j] = 2;
            }
            for (int i = 0; i < globalPopulation.size; ++i) {
                if (gflg[i] == 1 || gflg[i] == 0) continue;
                for (j = 0; j < globalPopulation.size; ++j) {
                    if (i == j || gflg[j] == 1) continue;
                    int val = this.moComparer.compare(globalPopulation.ind[i].sample, globalPopulation.ind[j].sample);
                    if (val == 1) {
                        gflg[i] = 0;
                        break;
                    }
                    if (val == -1) {
                        gflg[j] = 0;
                        continue;
                    }
                    if (val != 0) continue;
                    ++nondom;
                    if (gflg[j] == 0) continue;
                    gflg[j] = 3;
                }
                if (j != globalPopulation.size) continue;
                globalPopulation.ind[i].rank = rnk;
                gflg[i] = 1;
                globalPopulation.rankar[rnk - 1][q] = i;
                ++q;
            }
            globalPopulation.rankno[rnk - 1] = q;
        }
        globalPopulation.maxrank = rnk;
    }

    void sort(int m1, int[] index, double[] value) {
        for (int k1 = 0; k1 < m1; ++k1) {
            for (int i1 = k1 + 1; i1 < m1; ++i1) {
                if (!(value[k1] > value[i1])) continue;
                double temp = value[k1];
                int temp1 = index[k1];
                value[k1] = value[i1];
                index[k1] = index[i1];
                value[i1] = temp;
                index[i1] = temp1;
            }
        }
    }

    void gshare(int rnk, Population globalPopulation) {
        int m1 = globalPopulation.rankno[rnk - 1];
        int nfunc = globalPopulation.ind[0].sample.F().length;
        int[] index = new int[globalPopulation.size];
        double[] value = new double[globalPopulation.size];
        for (int j = 0; j < nfunc; ++j) {
            for (int i = 0; i < m1; ++i) {
                index[i] = globalPopulation.rankar[rnk - 1][i];
                value[i] = globalPopulation.ind[index[i]].sample.F()[j];
            }
            this.sort(m1, index, value);
            double max = value[m1 - 1];
            double min = value[0];
            for (int i = 0; i < m1; ++i) {
                if (i == 0 || i == m1 - 1) {
                    globalPopulation.ind[index[i]].cub_len += 100.0 * max;
                    continue;
                }
                globalPopulation.ind[index[i]].cub_len += Math.abs(value[i + 1] - value[i - 1]) / (max - min);
            }
        }
    }

    void gsort(int rnk, int sel, Population globalPopulation, boolean[] flag) {
        int i;
        int[] index = new int[globalPopulation.size];
        double[] value = new double[globalPopulation.size];
        int q = globalPopulation.rankno[rnk - 1];
        for (i = 0; i < q; ++i) {
            index[i] = globalPopulation.rankar[rnk - 1][i];
            value[i] = -globalPopulation.ind[index[i]].cub_len;
        }
        this.sort(q, index, value);
        for (i = 0; i < sel; ++i) {
            flag[index[i]] = true;
        }
    }

    void keepalive(Population pop1, Population pop2, Population pop3, int gen) {
        int k;
        int i;
        int i2;
        Population globalPopulation = new Population(pop1.size * 2);
        boolean[] flag = new boolean[pop1.size * 2];
        int lastRank = 0;
        for (i2 = 0; i2 < pop1.size; ++i2) {
            globalPopulation.ind[i2] = pop1.ind[i2];
            globalPopulation.ind[i2].cub_len = 0.0;
            globalPopulation.ind[i2 + pop1.size] = pop2.ind[i2];
            globalPopulation.ind[i2 + pop1.size].cub_len = 0.0;
            flag[i2] = false;
            flag[i2 + pop1.size] = false;
        }
        this.grank(gen, globalPopulation);
        for (i2 = 0; i2 < globalPopulation.maxrank; ++i2) {
            this.gshare(i2 + 1, globalPopulation);
        }
        int st = 0;
        int pool = 0;
        for (i = 0; i < globalPopulation.maxrank; ++i) {
            st = pool;
            if ((pool += globalPopulation.rankno[i]) <= pop1.size) {
                for (k = 0; k < 2 * pop1.size; ++k) {
                    if (globalPopulation.ind[k].rank != i + 1) continue;
                    flag[k] = true;
                }
            } else {
                int sel = pop1.size - st;
                lastRank = i + 1;
                pop3.rankno[i] = sel;
                this.gsort(i + 1, sel, globalPopulation, flag);
                break;
            }
            pop3.rankno[i] = globalPopulation.rankno[i];
        }
        k = 0;
        for (i = 0; i < 2 * pop1.size && k < pop1.size; ++i) {
            if (!flag[i]) continue;
            pop3.ind[k] = globalPopulation.ind[i];
            ++k;
        }
        pop3.maxrank = lastRank;
    }

    void report(int t, Population pop1, Population pop2) {
        int j;
        int i;
        int j2;
        this.log("\n-----------------------------------------------------------------------------------");
        this.log("Generation No.     ->" + (t + 1));
        this.log("-----------------------------------------------------------------------------------");
        int popSize = pop1.ind.length;
        DecimalFormat f = new DecimalFormat("#0.00000");
        String text = "";
        for (j2 = 0; j2 < this.n; ++j2) {
            text = text + "x" + j2 + "\t\t";
        }
        for (j2 = 0; j2 < this.m; ++j2) {
            text = text + "y" + j2 + "\t\t";
        }
        this.log(text + "\tcublen\trank");
        text = "";
        for (i = 0; i < popSize; ++i) {
            for (j = 0; j < this.n; ++j) {
                text = text + f.format(pop1.ind[i].sample.getParameter()[j]) + "\t";
            }
            for (j = 0; j < this.m; ++j) {
                text = text + f.format(pop1.ind[i].sample.F()[j]) + "\t";
            }
            text = text + pop1.ind[i].cub_len + "\t" + pop1.ind[i].rank;
            this.log(text);
            text = "";
        }
        this.log(text);
        text = "";
        this.log("-----------------------------------------------------------------------------------");
        for (i = 0; i < popSize; ++i) {
            for (j = 0; j < this.n; ++j) {
                text = text + f.format(pop2.ind[i].sample.getParameter()[j]) + "\t";
            }
            for (j = 0; j < this.m; ++j) {
                text = text + f.format(pop2.ind[i].sample.F()[j]) + "\t";
            }
            text = text + pop2.ind[i].cub_len + "\t" + pop2.ind[i].rank;
            this.log(text);
            text = "";
        }
        this.log("-----------------------------------------------------------------------------------");
        this.log("-----------------------------------------------------------------------------------");
        this.log("-----------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        try {
            if (this.getPopulationSize() < 1.0) {
                this.log(JAMS.i18n((String)"size_of_population_not_specified_or_out_of_bounds"));
                return;
            }
            if (this.getCrossoverDistributionIndex() < 0.5 || this.getCrossoverDistributionIndex() > 100.0) {
                this.log(JAMS.i18n((String)"crossoverDistributionIndex_not_specified_or_out_of_bounds"));
                return;
            }
            if (this.getMutationDistributionIndex() < 0.5 || this.getMutationDistributionIndex() > 500.0) {
                this.log(JAMS.i18n((String)"mutationDistributionIndex_not_specified_or_out_of_bounds"));
                return;
            }
            if (this.getCrossoverProbability() < 0.0 || this.getCrossoverProbability() > 1.0) {
                this.log(JAMS.i18n((String)"crossoverProbability_not_specified_or_out_of_bounds"));
                return;
            }
            if (this.getMutationProbability() < 0.0 || this.getMutationProbability() > 1.0) {
                this.log(JAMS.i18n((String)"mutationProbability_not_specified_or_out_of_bounds"));
                return;
            }
            this.setMutationProbability(1.0 / (double)this.n);
            if (this.getMaxGeneration() < 0.0) {
                this.log(JAMS.i18n((String)"maxGeneration_not_specified_or_out_of_bounds"));
                return;
            }
            this.generator = new CustomRand(0.5);
            Population oldPopulation = new Population((int)this.getPopulationSize());
            Population matePopulation = new Population((int)this.getPopulationSize());
            Population newPopulation = new Population((int)this.getPopulationSize());
            double[][] initParameter = new double[(int)this.getPopulationSize()][];
            int i = 0;
            while ((double)i < this.getPopulationSize()) {
                initParameter[i] = this.x0 != null && this.x0.length > i ? (double[])this.x0[i].clone() : this.randomSampler();
                ++i;
            }
            if (!this.parallelExecution) {
                i = 0;
                while ((double)i < this.getPopulationSize()) {
                    oldPopulation.ind[i] = new Individual(this.getSample(initParameter[i]));
                    ++i;
                }
            } else {
                ParallelSequence.OutputData result = this.pseq.procedure(initParameter);
                for (int j = 0; j < initParameter.length; ++j) {
                    try {
                        oldPopulation.ind[j] = new Individual(result.list.get(j));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        System.out.println("For an unknown reason parallel sampling did not succeed completly .. switching to sequential execution");
                        for (int k = j; k < initParameter.length; ++k) {
                            oldPopulation.ind[k] = new Individual(this.getSample(initParameter[k]));
                        }
                        j = initParameter.length;
                        break;
                    }
                }
                if (this.collection == null) {
                    this.collection = result.dc;
                } else {
                    DataCollection j = this.collection;
                    synchronized (j) {
                        this.collection.mergeDataCollections(result.dc);
                        this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), true);
                    }
                }
                this.injectSamples(result.list);
            }
            this.ranking(oldPopulation);
            i = 0;
            while ((double)i < this.getMaxGeneration()) {
                matePopulation = new Population((int)this.getPopulationSize());
                newPopulation = new Population((int)this.getPopulationSize());
                this.nselect(oldPopulation, matePopulation);
                double[][] newParameter = this.realcross(matePopulation);
                this.real_mutate(newParameter);
                if (!this.parallelExecution) {
                    for (int j = 0; j < newParameter.length; ++j) {
                        newPopulation.ind[j] = new Individual(this.getSample(newParameter[j]));
                    }
                } else {
                    ParallelSequence.OutputData result = this.pseq.procedure(newParameter);
                    for (int j = 0; j < newParameter.length; ++j) {
                        try {
                            newPopulation.ind[j] = new Individual(result.list.get(j));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            System.out.println("For an unknown reason parallel sampling did not succeed completly .. switching to sequential execution");
                            for (int k = j; k < newParameter.length; ++k) {
                                newPopulation.ind[k] = new Individual(this.getSample(newParameter[k]));
                            }
                            j = newParameter.length;
                            break;
                        }
                    }
                    if (this.collection == null) {
                        this.collection = result.dc;
                    } else {
                        DataCollection dataCollection = this.collection;
                        synchronized (dataCollection) {
                            this.collection.mergeDataCollections(result.dc);
                            this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), true);
                        }
                    }
                    this.injectSamples(result.list);
                }
                this.ranking(newPopulation);
                this.keepalive(oldPopulation, newPopulation, matePopulation, i + 1);
                oldPopulation = newPopulation = matePopulation;
                ++i;
            }
            this.log(JAMS.i18n((String)"NO_OF_MUTATION") + this.crossoverCount);
            this.log(JAMS.i18n((String)"NO_OF_CROSSOVER") + this.mutationCount);
            this.log("-----------------------------------------------------------------------------------");
        }
        finally {
            if (this.collection != null) {
                this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), false);
            }
        }
    }

    public static class CustomRand
    implements Serializable {
        double[] oldrand = new double[55];
        int jrand = 0;

        CustomRand(double random_seed) {
            double new_random = 1.0E-9;
            double prev_random = random_seed;
            this.oldrand[54] = random_seed;
            for (int j1 = 1; j1 <= 54; ++j1) {
                int ii = 21 * j1 % 54;
                this.oldrand[ii] = new_random;
                if ((new_random = prev_random - new_random) < 0.0) {
                    new_random += 1.0;
                }
                prev_random = this.oldrand[ii];
            }
            this.advance_random();
            this.advance_random();
            this.advance_random();
            this.jrand = 0;
        }

        private void advance_random() {
            double new_random;
            int j1;
            for (j1 = 0; j1 < 24; ++j1) {
                new_random = this.oldrand[j1] - this.oldrand[j1 + 31];
                if (new_random < 0.0) {
                    new_random += 1.0;
                }
                this.oldrand[j1] = new_random;
            }
            for (j1 = 24; j1 < 55; ++j1) {
                new_random = this.oldrand[j1] - this.oldrand[j1 - 24];
                if (new_random < 0.0) {
                    new_random += 1.0;
                }
                this.oldrand[j1] = new_random;
            }
        }

        public double rand() {
            if (++this.jrand >= 55) {
                this.jrand = 1;
                this.advance_random();
            }
            return this.oldrand[this.jrand];
        }
    }

    private class Population
    implements Serializable {
        int maxrank;
        int[][] rankar;
        int[] rankno;
        Individual[] ind;
        int size;

        public Population(int size) {
            this.size = size;
            this.rankno = new int[size + 1];
            this.ind = new Individual[size];
            this.rankar = new int[size][size];
        }
    }

    private static class Individual
    implements Serializable {
        SampleFactory.Sample sample;
        int rank;
        double cub_len;

        public Individual(SampleFactory.Sample sample) {
            this.sample = sample;
            this.rank = 0;
            this.cub_len = 0.0;
        }
    }
}

