/*
 * Decompiled with CFR 0.152.
 */
package optas.io;

import jams.data.Attribute;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.EfficiencyEnsemble;
import optas.data.Ensemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerieEnsemble;
import optas.io.ImportMonteCarloData;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class NetCDFFileWriter {
    private NetcdfFileWriter file = null;

    public NetCDFFileWriter(String file) throws IOException {
        this.file = NetcdfFileWriter.createNew((String)file, (boolean)true);
    }

    private boolean hasSuitableTimeInterval(Attribute.TimeInterval collectionInterval, Attribute.TimeInterval dataSetInterval) {
        if (collectionInterval.getTimeUnit() != dataSetInterval.getTimeUnit()) {
            return false;
        }
        if (collectionInterval.getTimeUnitCount() != dataSetInterval.getTimeUnitCount()) {
            return false;
        }
        if (collectionInterval.getStart().getTimeInMillis() > dataSetInterval.getStart().getTimeInMillis()) {
            return false;
        }
        return collectionInterval.getEnd().getTimeInMillis() >= dataSetInterval.getEnd().getTimeInMillis();
    }

    private boolean hasSuitableModelRuns(Integer[] collectionModelRuns, Integer[] dataSetModelRuns) {
        if (collectionModelRuns.length < dataSetModelRuns.length) {
            return false;
        }
        if (collectionModelRuns[0] > dataSetModelRuns[0]) {
            return false;
        }
        return collectionModelRuns[collectionModelRuns.length - 1] >= dataSetModelRuns[dataSetModelRuns.length - 1];
    }

    private int getTimeIntervalOffset(Attribute.TimeInterval collectionInterval, Attribute.TimeInterval dataSetInterval) {
        long intervalOffset = collectionInterval.getStartOffset(dataSetInterval);
        int offset = 0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(collectionInterval.getStart().getTimeInMillis());
        while (cal.getTimeInMillis() < collectionInterval.getStart().getTimeInMillis() + intervalOffset) {
            cal.add(collectionInterval.getTimeUnit(), 1);
            ++offset;
        }
        return offset;
    }

    private int getModelRunIDOffset(Integer[] collectionModelRuns, Integer[] dataSetModelRuns) {
        int offset = 0;
        while (collectionModelRuns[offset] != dataSetModelRuns[0]) {
            ++offset;
        }
        return offset;
    }

    public void write(DataCollection collection) throws IOException, UnsupportedOperationException, DataSet.MismatchException {
        int i;
        this.file.addVariableAttribute((String)null, new Attribute("samplerClass", collection.getSamplerClass()));
        Integer[] collectionModelRuns = collection.getModelrunIds();
        Dimension modelRunID = this.file.addDimension("modelRuns", collectionModelRuns.length, true, false);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(modelRunID);
        this.file.addVariable("modelRunID", DataType.INT, dimensions);
        Attribute.TimeInterval collectionInterval = null;
        Dimension time = null;
        if (collection.getTimeDomain() != null) {
            collectionInterval = collection.getTimeDomain();
            int numberOfTimeSteps = (int)collectionInterval.getNumberOfTimesteps();
            time = this.file.addDimension("time", numberOfTimeSteps, true, false);
            String timeUnit = String.valueOf(collectionInterval.getTimeUnit());
            String timeUnitCount = String.valueOf(collectionInterval.getTimeUnitCount());
            String start = String.valueOf(collectionInterval.getStart().getTimeInMillis());
            String end = String.valueOf(collectionInterval.getEnd().getTimeInMillis());
            this.file.addVariableAttribute((String)null, new Attribute("timeUnit", timeUnit));
            this.file.addVariableAttribute((String)null, new Attribute("timeUnitCount", timeUnitCount));
            this.file.addVariableAttribute((String)null, new Attribute("timeDomainStart", start));
            this.file.addVariableAttribute((String)null, new Attribute("timeDomainEnd", end));
        }
        Set<String> dataSetNames = collection.getDatasets();
        for (String name : dataSetNames) {
            DataSet dataSet = collection.getDataSet(name);
            dimensions = new ArrayList();
            if (dataSet instanceof TimeSerieEnsemble) {
                dimensions.addAll(Arrays.asList(modelRunID, time));
            } else if (dataSet instanceof Measurement) {
                dimensions.add(time);
            } else if (dataSet instanceof SimpleEnsemble || dataSet instanceof EfficiencyEnsemble) {
                dimensions.add(modelRunID);
            } else {
                throw new UnsupportedOperationException();
            }
            Variable var = this.file.addVariable(name, DataType.DOUBLE, dimensions);
            var.addAttribute(new Attribute("className", dataSet.getClass().getName()));
            if (dimensions.contains(time)) {
                Attribute.TimeInterval interval = null;
                if (dataSet instanceof TimeSerieEnsemble) {
                    interval = ((TimeSerieEnsemble)dataSet).getTimeInterval();
                }
                if (dataSet instanceof Measurement) {
                    interval = ((Measurement)dataSet).getTimeDomain();
                }
                var.addAttribute(new Attribute("timeunit", (Number)interval.getTimeUnit()));
                var.addAttribute(new Attribute("timeunitcount", (Number)interval.getTimeUnitCount()));
                var.addAttribute(new Attribute("start", String.valueOf(interval.getStart().getTimeInMillis())));
                var.addAttribute(new Attribute("end", String.valueOf(interval.getEnd().getTimeInMillis())));
            }
            if (!(dataSet instanceof EfficiencyEnsemble)) continue;
            var.addAttribute(new Attribute("isPositiveBest", String.valueOf(((EfficiencyEnsemble)dataSet).isPositiveBest())));
        }
        this.file.create();
        Array modelRunArray = Array.factory((DataType)DataType.INT, (int[])new int[]{collectionModelRuns.length});
        for (i = 0; i < collectionModelRuns.length; ++i) {
            modelRunArray.setObject(i, (Object)collectionModelRuns[i]);
        }
        try {
            this.file.write("modelRunID", modelRunArray);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(NetCDFFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (String name : dataSetNames) {
            ArrayDouble.D1 dataSetArray;
            int[] offset;
            Attribute.TimeInterval dataSetInterval;
            Ensemble ensemble;
            DataSet dataSet = collection.getDataSet(name);
            if (dataSet instanceof TimeSerieEnsemble) {
                ensemble = (TimeSerieEnsemble)dataSet;
                dataSetInterval = ((TimeSerieEnsemble)ensemble).getTimeInterval();
                Integer[] dataSetModelRuns = ensemble.getIds();
                if (!this.hasSuitableTimeInterval(collectionInterval, dataSetInterval)) {
                    throw new DataSet.MismatchException("Time intervals don't match.");
                }
                if (!this.hasSuitableModelRuns(collectionModelRuns, dataSetModelRuns)) {
                    throw new DataSet.MismatchException("Model run IDs don't match.");
                }
                ArrayDouble.D2 dataSetArray2 = new ArrayDouble.D2(dataSetModelRuns.length, (int)dataSetInterval.getNumberOfTimesteps());
                for (i = 0; i < dataSetModelRuns.length; ++i) {
                    int t = 0;
                    while ((long)t < dataSetInterval.getNumberOfTimesteps()) {
                        Index index = dataSetArray2.getIndex();
                        dataSetArray2.set(index.set(i, t), ((TimeSerieEnsemble)ensemble).get(t, dataSetModelRuns[i]));
                        ++t;
                    }
                }
                offset = new int[]{this.getModelRunIDOffset(collectionModelRuns, dataSetModelRuns), this.getTimeIntervalOffset(collectionInterval, dataSetInterval)};
                try {
                    this.file.write(name, offset, (Array)dataSetArray2);
                }
                catch (InvalidRangeException ex) {
                    Logger.getLogger(NetCDFFileWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (dataSet instanceof Measurement) {
                Measurement measurement = (Measurement)dataSet;
                dataSetInterval = measurement.getTimeDomain();
                if (!this.hasSuitableTimeInterval(collectionInterval, dataSetInterval)) {
                    throw new DataSet.MismatchException("Time intervals don't match.");
                }
                dataSetArray = new ArrayDouble.D1((int)dataSetInterval.getNumberOfTimesteps());
                int t = 0;
                while ((long)t < dataSetInterval.getNumberOfTimesteps()) {
                    dataSetArray.set(t, measurement.getValue(t));
                    ++t;
                }
                offset = new int[]{this.getTimeIntervalOffset(collectionInterval, dataSetInterval)};
                try {
                    this.file.write(name, offset, (Array)dataSetArray);
                }
                catch (InvalidRangeException ex) {
                    Logger.getLogger(NetCDFFileWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (dataSet instanceof SimpleEnsemble || dataSet instanceof EfficiencyEnsemble) {
                ensemble = (SimpleEnsemble)dataSet;
                Integer[] dataSetModelRuns = ensemble.getIds();
                if (!this.hasSuitableModelRuns(collectionModelRuns, dataSetModelRuns)) {
                    throw new DataSet.MismatchException("Model run IDs don't match.");
                }
                dataSetArray = new ArrayDouble.D1(dataSetModelRuns.length);
                for (i = 0; i < dataSetModelRuns.length; ++i) {
                    dataSetArray.set(i, ((SimpleEnsemble)ensemble).getValue(dataSetModelRuns[i]));
                }
                int[] offset2 = new int[]{this.getModelRunIDOffset(collectionModelRuns, dataSetModelRuns)};
                try {
                    this.file.write(name, offset2, (Array)dataSetArray);
                }
                catch (InvalidRangeException ex) {
                    Logger.getLogger(NetCDFFileWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    public void flush() throws IOException {
        this.file.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ImportMonteCarloData data = new ImportMonteCarloData();
        data.addFile(new File("E:/ModelData/JAMS-Gehlberg/output/mc3_1600Final_Nov2/optimization_wizard_optimizer.dat"));
        DataCollection collection = data.getEnsemble();
        NetCDFFileWriter stream = null;
        try {
            stream = new NetCDFFileWriter("E:/ModelData/test.nc");
            stream.write(collection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.flush();
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

