/*
 * Decompiled with CFR 0.152.
 */
package optas.io;

import jams.JAMS;
import jams.JAMSProperties;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.EnsembleTimeSeriesProcessor;
import jams.workspace.dsproc.Processor;
import jams.workspace.dsproc.SimpleSerieProcessor;
import jams.workspace.dsproc.TimeSpaceProcessor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Measurement;
import optas.data.Modelrun;
import optas.data.NegativeEfficiency;
import optas.data.Parameter;
import optas.data.PositiveEfficiency;
import optas.data.SimpleDataSet;
import optas.data.StateVariable;
import optas.data.TimeSerie;
import optas.io.ImportMonteCarloException;

public class ImportMonteCarloData
implements Serializable {
    ArrayList<Processor> fileProcessors = new ArrayList();
    HashMap<AbstractDataStoreProcessor.AttributeData, Processor> attributeDataMap = new HashMap();
    HashMap<AbstractDataStoreProcessor.AttributeData, EnsembleType> typeMap = new HashMap();
    EnumMap<EnsembleType, Class> simpleDatasetClasses = new EnumMap(EnsembleType.class);
    EnumMap<EnsembleType, Class> timeSerieDatasetClasses = new EnumMap(EnsembleType.class);
    final EnsembleType[] ensembleVariableTypes = new EnsembleType[]{EnsembleType.Ignore, EnsembleType.Parameter, EnsembleType.StateVariable, EnsembleType.NegEfficiency, EnsembleType.PosEfficiency};
    final EnsembleType[] ensembleTimeserieTypes = new EnsembleType[]{EnsembleType.Ignore, EnsembleType.Timeserie, EnsembleType.Measurement};
    final EnsembleType[] timeserieTypes = new EnsembleType[]{EnsembleType.Ignore, EnsembleType.Measurement};
    DataCollection ensemble = null;
    final TreeMap<String, EnsembleType> defaultAttributeTypes = new TreeMap();
    boolean isValid = false;
    static int badIDCounter = 1000000;
    TreeSet<String> ensembleIDs = new TreeSet();
    TreeSet<String> ensembleTimesteps = new TreeSet();
    Attribute.TimeInterval ensembleTime = null;

    public ImportMonteCarloData() {
        this.init();
    }

    private void init() {
        this.simpleDatasetClasses.put(EnsembleType.Parameter, Parameter.class);
        this.simpleDatasetClasses.put(EnsembleType.Measurement, Measurement.class);
        this.simpleDatasetClasses.put(EnsembleType.NegEfficiency, NegativeEfficiency.class);
        this.simpleDatasetClasses.put(EnsembleType.PosEfficiency, PositiveEfficiency.class);
        this.simpleDatasetClasses.put(EnsembleType.StateVariable, StateVariable.class);
        this.simpleDatasetClasses.put(EnsembleType.Unknown, Parameter.class);
        this.timeSerieDatasetClasses.put(EnsembleType.Timeserie, TimeSerie.class);
        this.timeSerieDatasetClasses.put(EnsembleType.Measurement, Measurement.class);
        JAMSProperties prop = JAMSProperties.createProperties();
        for (EnsembleType e : EnsembleType.values()) {
            String[] parameterAttributes;
            String value = prop.getProperty(e.toString());
            if (value == null) continue;
            for (String parameterAttribute : parameterAttributes = value.split(";")) {
                this.defaultAttributeTypes.put(parameterAttribute, e);
            }
        }
    }

    public EnsembleType[] getValidProcessingOptions(Processor p) {
        switch (AbstractDataStoreProcessor.getDataStoreType((File)p.getDataStoreProcessor().getFile())) {
            case TimeDataSerie: {
                return this.ensembleTimeserieTypes;
            }
            case DataSerie1D: {
                return this.ensembleVariableTypes;
            }
            case Timeserie: {
                return this.timeserieTypes;
            }
        }
        return null;
    }

    public boolean addFile(File file) throws ImportMonteCarloException {
        if (!this.loadDataStore(file)) {
            this.isValid = false;
            return false;
        }
        this.updateDataTable();
        this.isValid = true;
        return true;
    }

    public Processor getProcessorForAttribute(AbstractDataStoreProcessor.AttributeData a) {
        return this.attributeDataMap.get(a);
    }

    private boolean loadDataStore(File file) throws ImportMonteCarloException {
        EnsembleTimeSeriesProcessor proc;
        AbstractDataStoreProcessor dsdb = AbstractDataStoreProcessor.getProcessor((File)file);
        if (dsdb.isEmpty()) {
            return false;
        }
        try {
            dsdb.createDB();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_load_data_store_") + file, ioe);
        }
        catch (SQLException ioe) {
            ioe.printStackTrace();
            throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_create_database"), ioe);
        }
        catch (ClassNotFoundException ioe) {
            ioe.printStackTrace();
            throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_load_data_store_"), ioe);
        }
        switch (AbstractDataStoreProcessor.getDataStoreType((File)file)) {
            case Unsupported: {
                return false;
            }
            case TimeDataSerie: {
                proc = new EnsembleTimeSeriesProcessor(dsdb);
                break;
            }
            case SpatioTemporal: {
                proc = new TimeSpaceProcessor(dsdb);
                break;
            }
            case DataSerie1D: {
                proc = new SimpleSerieProcessor(dsdb);
                break;
            }
            case Timeserie: {
                proc = new SimpleSerieProcessor(dsdb);
                break;
            }
            default: {
                return false;
            }
        }
        this.fileProcessors.add((Processor)proc);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataCollection buildEnsemble() throws ImportMonteCarloException {
        this.ensemble = new DataCollection();
        String samplerClass = null;
        for (AbstractDataStoreProcessor.AttributeData a : this.attributeDataMap.keySet()) {
            Object ts;
            String[] ids;
            SimpleSerieProcessor s;
            Processor p;
            EnsembleType dataSetClassName;
            block33: {
                dataSetClassName = this.typeMap.get(a);
                p = this.attributeDataMap.get(a);
                if (dataSetClassName == null) {
                    if (p instanceof SimpleSerieProcessor) {
                        dataSetClassName = EnsembleType.StateVariable;
                    } else if (p instanceof EnsembleTimeSeriesProcessor) {
                        dataSetClassName = EnsembleType.Timeserie;
                    }
                }
                for (AbstractDataStoreProcessor.ContextData c : p.getDataStoreProcessor().getContexts()) {
                    if (!c.getType().startsWith("jams.components.optimizer") && !c.getType().contains("optas")) continue;
                    if (samplerClass == null) {
                        samplerClass = c.getType();
                        this.ensemble.setSamplerClass(samplerClass);
                        continue;
                    }
                    if (c.getType().equals(samplerClass)) continue;
                    samplerClass = "jams.components.optimizer.Optimizer";
                }
                try {
                    if (!this.simpleDatasetClasses.containsKey((Object)dataSetClassName) || !(p instanceof SimpleSerieProcessor) || !(p instanceof SimpleSerieProcessor)) break block33;
                    s = (SimpleSerieProcessor)p;
                    ids = s.getIDs();
                    for (AbstractDataStoreProcessor.AttributeData ad : s.getDataStoreProcessor().getAttributes()) {
                        ad.setSelected(false);
                    }
                    a.setSelected(true);
                    DataMatrix m = s.getData(ids);
                    a.setSelected(false);
                    int row = 0;
                    if (s.isTimeSerie()) {
                        double[] dArray = m.getCol(0);
                        Attribute.TimeInterval timeInterval = DefaultDataFactory.getDataFactory().createTimeInterval();
                        timeInterval.setStart(s.getTimeSteps()[0]);
                        timeInterval.setEnd(s.getTimeSteps()[dArray.length - 1]);
                        timeInterval.setTimeUnit(s.getTimeUnit());
                        ts = new TimeSerie(dArray, timeInterval, a.getName(), (DataSet)this.ensemble);
                        this.ensemble.addTimeSerie(new Measurement((TimeSerie)ts));
                        break block33;
                    }
                    for (String id : ids) {
                        Integer intID = null;
                        try {
                            intID = Integer.parseInt(id);
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                            intID = new Integer(badIDCounter++);
                        }
                        Modelrun r = new Modelrun(intID, null);
                        Class datasetClass = this.simpleDatasetClasses.get((Object)dataSetClassName);
                        Constructor c = datasetClass.getConstructor(SimpleDataSet.class);
                        SimpleDataSet nonTypedSDS = new SimpleDataSet(m.get(row, 0), a.getName(), r);
                        ++row;
                        SimpleDataSet typedSDS = (SimpleDataSet)c.newInstance(nonTypedSDS);
                        r.addDataSet(typedSDS);
                        this.ensemble.addModelRun(r);
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), sqle);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), ioe);
                }
                catch (DataSet.MismatchException me) {
                    me.printStackTrace();
                    throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), me);
                }
                catch (ClassCastException cce) {
                    throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), cce);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), t);
                }
            }
            try {
                void var10_26;
                if (!this.timeSerieDatasetClasses.containsKey((Object)dataSetClassName) || !(p instanceof EnsembleTimeSeriesProcessor)) continue;
                s = (EnsembleTimeSeriesProcessor)p;
                ids = (String[])s.getModelRuns();
                Attribute.Calendar[] timesteps = s.getTimeSteps();
                if (timesteps == null) continue;
                String[] namedTimesteps = new String[timesteps.length];
                boolean bl = false;
                while (var10_26 < timesteps.length) {
                    namedTimesteps[var10_26] = timesteps[var10_26].toString();
                    ++var10_26;
                }
                this.ensembleTime = DefaultDataFactory.getDataFactory().createTimeInterval();
                this.ensembleTime.setStart(timesteps[0]);
                this.ensembleTime.setEnd(timesteps[timesteps.length - 1]);
                this.ensembleTime.setTimeUnit(s.getTimeUnit());
                for (AbstractDataStoreProcessor.AttributeData ad : s.getDataStoreProcessor().getAttributes()) {
                    ad.setSelected(false);
                }
                a.setSelected(true);
                DataMatrix dataMatrix = s.getCrossProduct((long[])ids, namedTimesteps);
                a.setSelected(false);
                if (this.timeSerieDatasetClasses.get((Object)dataSetClassName).equals(TimeSerie.class)) {
                    int col = 0;
                    ts = ids;
                    int n = ((String[])ts).length;
                    for (int i = 0; i < n; ++i) {
                        Long id = (long)ts[i];
                        Modelrun r = new Modelrun(id.intValue(), null);
                        r.addDataSet(new TimeSerie(dataMatrix.getCol(col), this.ensembleTime, a.getName(), (DataSet)r));
                        ++col;
                        this.ensemble.addModelRun(r);
                    }
                    continue;
                }
                if (!this.timeSerieDatasetClasses.get((Object)dataSetClassName).equals(Measurement.class)) continue;
                int col = 0;
                ts = null;
                String[] stringArray = ids;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Long id = (long)stringArray[i];
                    Modelrun r = new Modelrun(id.intValue(), null);
                    Measurement ts2 = new Measurement(new TimeSerie(dataMatrix.getCol(col), this.ensembleTime, a.getName(), (DataSet)r));
                    if (ts == null) {
                        ts = ts2;
                    } else {
                        int i2 = 0;
                        while ((long)i2 < ((TimeSerie)ts).getTimeDomain().getNumberOfTimesteps()) {
                            if (((TimeSerie)ts).getValue(i2) != ts2.getValue(i2)) {
                                throw new DataSet.MismatchException(JAMS.i18n((String)"timeserie_ensemble_could_not_be_used_as_measurement"));
                            }
                            ++i2;
                        }
                    }
                    ++col;
                }
                this.ensemble.addTimeSerie((TimeSerie)ts);
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), sqle);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), ioe);
            }
            catch (DataSet.MismatchException me) {
                me.printStackTrace();
                throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), me);
            }
            catch (ClassCastException cce) {
                throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), cce);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ImportMonteCarloException(JAMS.i18n((String)"Could_not_build_ensemble_"), t);
            }
        }
        return this.ensemble;
    }

    public EnsembleType getDefaultAttributeType(AbstractDataStoreProcessor.AttributeData a) {
        EnsembleType type = this.defaultAttributeTypes.get(a.getName());
        if (type == null) {
            for (String key : this.defaultAttributeTypes.keySet()) {
                if (!a.getName().contains(key)) continue;
                return this.defaultAttributeTypes.get(key);
            }
            return null;
        }
        return type;
    }

    public boolean isEmpty() {
        return this.attributeDataMap.isEmpty();
    }

    public DataCollection getEnsemble() throws ImportMonteCarloException {
        if (!this.isValid) {
            return null;
        }
        this.buildEnsemble();
        return this.ensemble;
    }

    public void setEnsemble(DataCollection dc) {
        this.ensemble = dc;
    }

    public void setType(AbstractDataStoreProcessor.AttributeData a, EnsembleType type) {
        if (type != null) {
            this.typeMap.put(a, type);
        } else {
            this.typeMap.put(a, EnsembleType.Unknown);
        }
    }

    public ArrayList<Processor> getFileProcessors() {
        return this.fileProcessors;
    }

    public void removeFileProcessor(int index) {
        this.fileProcessors.remove(index);
    }

    public TreeSet<AbstractDataStoreProcessor.AttributeData> getAttributeData() {
        if (this.attributeDataMap == null) {
            return null;
        }
        return new TreeSet<AbstractDataStoreProcessor.AttributeData>(this.attributeDataMap.keySet());
    }

    private void updateDataTable() {
        HashMap<Processor, EnsembleType[]> processorTypeMap = new HashMap<Processor, EnsembleType[]>();
        for (Processor p : this.fileProcessors) {
            switch (AbstractDataStoreProcessor.getDataStoreType((File)p.getDataStoreProcessor().getFile())) {
                case TimeDataSerie: {
                    processorTypeMap.put(p, this.ensembleTimeserieTypes);
                    break;
                }
                case DataSerie1D: {
                    processorTypeMap.put(p, this.ensembleVariableTypes);
                    break;
                }
                case Timeserie: {
                    processorTypeMap.put(p, this.timeserieTypes);
                }
            }
            for (AbstractDataStoreProcessor.AttributeData a : p.getDataStoreProcessor().getAttributes()) {
                this.attributeDataMap.put(a, p);
                this.typeMap.put(a, this.getDefaultAttributeType(a));
            }
        }
    }

    public void finish() {
        for (AbstractDataStoreProcessor.AttributeData attributeData : this.typeMap.keySet()) {
            this.defaultAttributeTypes.put(attributeData.getName(), this.typeMap.get(attributeData));
        }
        HashMap reverseMapping = new HashMap();
        for (String string : this.defaultAttributeTypes.keySet()) {
            EnsembleType type = this.defaultAttributeTypes.get(string);
            if (reverseMapping.containsKey((Object)type)) {
                ((ArrayList)reverseMapping.get((Object)type)).add(string);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(string);
            reverseMapping.put(type, list);
        }
        JAMSProperties jAMSProperties = JAMSProperties.createProperties();
        for (EnsembleType e : reverseMapping.keySet()) {
            String valueString = "";
            for (String value : (ArrayList)reverseMapping.get((Object)e)) {
                valueString = valueString + value + ";";
            }
            jAMSProperties.setProperty(e.toString(), valueString);
        }
        try {
            jAMSProperties.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            for (Processor p : this.fileProcessors) {
                p.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.fileProcessors = null;
        this.typeMap = null;
        this.ensemble = null;
        this.ensembleIDs = null;
    }

    public static enum EnsembleType {
        Parameter,
        StateVariable,
        Measurement,
        NegEfficiency,
        PosEfficiency,
        Timeserie,
        Unknown,
        Ignore;

    }
}

