/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.calculations;

import Jama.LUDecomposition;
import Jama.Matrix;
import jams.JAMS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import optas.data.DataCollection;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.tools.Resources;
import org.jfree.data.xy.XYSeries;

public class SlopeCalculations {
    private static double calcRegression(ArrayList<Coordinate> list) {
        double avg_x = 0.0;
        double avg_y = 0.0;
        for (Coordinate c : list) {
            avg_x += c.x;
            avg_y += c.y;
        }
        avg_x /= (double)list.size();
        avg_y /= (double)list.size();
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (Coordinate c : list) {
            sum1 += (c.x - avg_x) * (c.y - avg_y);
            sum2 += (c.x - avg_x) * (c.x - avg_x);
        }
        return sum1 / sum2;
    }

    private static XYSeries[] calcRegression(SimpleEnsemble[] param, EfficiencyEnsemble eff) {
        int N = eff.getSize();
        int n = param.length;
        int k = 2 * n;
        int iter = N / (k + 1);
        XYSeries[] dataset = new XYSeries[n];
        for (int i = 0; i < n; ++i) {
            dataset[i] = new XYSeries((Comparable)((Object)JAMS.i18n((String)"DATA_POINT")));
            dataset[i].setDescription(param[i].getName());
        }
        Matrix X = new Matrix(k, n + 1);
        Matrix Y = new Matrix(k, 1);
        double[] x0 = new double[n];
        for (int i = 0; i < iter; ++i) {
            int offset = i * (k + 1);
            boolean isValidIteration = true;
            for (int j = 0; j < n; ++j) {
                x0[j] = param[j].getValue(offset);
            }
            for (int row = 0; row < k; ++row) {
                X.set(row, 0, 1.0);
                double value = eff.getValue(offset + row);
                if (!SlopeCalculations.isValidDouble(value)) {
                    isValidIteration = false;
                    break;
                }
                Y.set(row, 0, value);
                for (int col = 0; col < n; ++col) {
                    X.set(row, col + 1, 0.01 * Math.signum(param[col].getValue(offset + row) - x0[col]));
                }
            }
            if (!isValidIteration) continue;
            LUDecomposition solver = new LUDecomposition(X.transpose().times(X));
            Matrix beta = solver.solve(X.transpose().times(Y));
            double value = eff.getValue(offset);
            if (!SlopeCalculations.isValidDouble(value)) continue;
            for (int j = 0; j < n; ++j) {
                dataset[j].add(eff.getValue(offset), beta.get(j + 1, 0));
            }
        }
        return dataset;
    }

    private static boolean isValidDouble(double value) {
        return !Double.isNaN(value) && Math.abs(value) < 1.0E12;
    }

    public static XYSeries[] calculateDerivative(EfficiencyEnsemble eff, DataCollection dc) {
        return SlopeCalculations.calcRegression(SlopeCalculations.getParameterEnsembles(dc), eff);
    }

    private static double[] getInitializedArray(int n, double v) {
        double[] array = new double[n];
        for (int i = 0; i < n; ++i) {
            array[i] = v;
        }
        return array;
    }

    public static XYSeries[] calculateGradientAtTime(DataCollection param, TimeSerieEnsemble timeseries, int timeIndex) {
        SimpleEnsemble[] p = SlopeCalculations.getParameterEnsembles(param);
        int n = p.length;
        return SlopeCalculations.calculateDerivativesAtTime(p, timeseries, timeIndex, SlopeCalculations.getInitializedArray(n, Double.NEGATIVE_INFINITY), SlopeCalculations.getInitializedArray(n, Double.POSITIVE_INFINITY));
    }

    public static XYSeries[] calculateDerivativesAtTime(SimpleEnsemble[] param, TimeSerieEnsemble timeseries, int timeIndex, double[] range_min, double[] range_max) {
        int N = param[0].getSize();
        int n = param.length;
        int k = 2 * n;
        int iter = N / (k + 1);
        XYSeries[] dataset = new XYSeries[n];
        double[] source_range_min = new double[n];
        double[] source_range_max = new double[n];
        for (int i = 0; i < n; ++i) {
            source_range_min[i] = Double.MAX_VALUE;
            source_range_max[i] = Double.MIN_VALUE;
            dataset[i] = new XYSeries((Comparable)((Object)Resources.get("DATA_POINT")));
            dataset[i].setDescription(param[i].getName());
        }
        Matrix X = new Matrix(k, n + 1);
        Matrix Y = new Matrix(k, 1);
        for (int i = 0; i < iter; ++i) {
            int offset = i * (k + 1);
            double[] x0 = new double[n];
            for (int j = 0; j < n; ++j) {
                x0[j] = param[j].getValue(offset);
                source_range_min[j] = Math.min(source_range_min[j], x0[j]);
                source_range_max[j] = Math.max(source_range_max[j], x0[j]);
            }
        }
        double[] weight = new double[n];
        for (int j = 0; j < n; ++j) {
            weight[j] = (range_max[j] - range_min[j]) / (source_range_max[j] - source_range_min[j]);
        }
        for (int i = 0; i < iter; ++i) {
            int offset = i * (k + 1);
            double[] x0 = new double[n];
            boolean skip = false;
            for (int j = 0; j < n; ++j) {
                x0[j] = param[j].getValue(offset);
                if (!(x0[j] < range_min[j]) && !(x0[j] > range_max[j])) continue;
                skip = true;
            }
            if (skip) continue;
            boolean validData = true;
            for (int row = 0; row < k; ++row) {
                double value = timeseries.get(timeIndex, offset + row);
                X.set(row, 0, 1.0);
                if (Double.isNaN(value) || Double.isInfinite(value) || Math.abs(value) > 1.0E14) {
                    validData = false;
                    break;
                }
                Y.set(row, 0, value);
                for (int col = 0; col < n; ++col) {
                    X.set(row, col + 1, weight[col] * 0.01 * Math.signum(param[col].getValue(offset + row) - x0[col]));
                }
            }
            if (!validData) continue;
            LUDecomposition solver = new LUDecomposition(X.transpose().times(X));
            Matrix beta = solver.solve(X.transpose().times(Y));
            double y0 = timeseries.get(timeIndex, offset);
            double error0 = beta.get(0, 0) - y0;
            if (Math.abs(error0 / y0) > 0.2) {
                // empty if block
            }
            if (Double.isNaN(y0) || Math.abs(y0) > 1.0E12) continue;
            for (int j = 0; j < n; ++j) {
                dataset[j].add(y0, beta.get(j + 1, 0));
            }
        }
        return dataset;
    }

    public static SimpleEnsemble[] getParameterEnsembles(DataCollection d) {
        Set<String> parameterSets = d.getDatasets(Parameter.class);
        SimpleEnsemble[] p = new SimpleEnsemble[parameterSets.size()];
        Iterator<String> iter = parameterSets.iterator();
        int c = 0;
        while (iter.hasNext()) {
            p[c++] = d.getSimpleEnsemble(iter.next());
        }
        return p;
    }

    public static double[][] calculateBehavourialRange(SimpleEnsemble[] parameter, SimpleEnsemble objective, double threshold) {
        int M = objective.getSize();
        int n = parameter.length;
        Integer[] order = objective.sort();
        double[][] ranges = new double[n][2];
        for (int i = 0; i < n; ++i) {
            ranges[i][0] = Double.POSITIVE_INFINITY;
            ranges[i][1] = Double.NEGATIVE_INFINITY;
        }
        int m = 0;
        while ((double)m < threshold * (double)M) {
            for (int i = 0; i < n; ++i) {
                ranges[i][0] = Math.min(ranges[i][0], parameter[i].getValue(order[m]));
                ranges[i][1] = Math.max(ranges[i][1], parameter[i].getValue(order[m]));
            }
            ++m;
        }
        return ranges;
    }

    public static double[][] calcParameterSensitivityTimeserie(DataCollection d, TimeSerieEnsemble timeserie, TimeSerie obs, double threshold) {
        SimpleEnsemble[] p = SlopeCalculations.getParameterEnsembles(d);
        int n = p.length;
        int T = timeserie.getTimesteps();
        double[][] result = new double[n][timeserie.getTimesteps()];
        if (timeserie == null || obs == null) {
            return null;
        }
        for (int i = 0; i < timeserie.getTimesteps(); ++i) {
            double real_value = obs.getValue(i);
            double[] range_min = new double[n];
            double[] range_max = new double[n];
            for (int j = 0; j < n; ++j) {
                range_min[j] = Double.POSITIVE_INFINITY;
                range_max[j] = Double.NEGATIVE_INFINITY;
            }
            double[] errorList = new double[timeserie.getSize()];
            int counter = 0;
            for (int j = 0; j < timeserie.getSize(); ++j) {
                if (!SlopeCalculations.isValidDouble(timeserie.get(i, j))) continue;
                errorList[j] = Math.abs(real_value - timeserie.get(i, j));
                ++counter;
            }
            Arrays.sort(errorList, 0, counter);
            for (int k = 0; k < n; ++k) {
                for (int j = 0; j < p[k].getSize(); ++j) {
                    double err;
                    if (!SlopeCalculations.isValidDouble(timeserie.get(i, j)) || !((err = Math.abs(real_value - timeserie.get(i, j))) < errorList[(int)(threshold * (double)counter)])) continue;
                    range_min[k] = Math.min(range_min[k], p[k].getValue(j));
                    range_max[k] = Math.max(range_max[k], p[k].getValue(j));
                }
            }
            XYSeries[] dataset = SlopeCalculations.calculateDerivativesAtTime(p, timeserie, i, range_min, range_max);
            for (int k = 0; k < n; ++k) {
                double max = 0.0;
                for (int j = 0; j < dataset[k].getItemCount(); ++j) {
                    max = Math.max(max, Math.abs(dataset[k].getY(j).doubleValue()));
                }
                result[k][i] = max;
            }
        }
        return result;
    }

    public static class Domination {
        double[][] weights;
        double[] sum;
        boolean[] enable;
        int n;
        int T;
        ArrayList<Integer> timeSteps = new ArrayList();

        public Domination(double[][] weights) {
            this.weights = weights;
            this.n = weights.length;
            this.T = weights[0].length;
            this.enable = new boolean[this.n];
            this.sum = new double[this.T];
        }

        public void enableAll() {
            for (int i = 0; i < this.n; ++i) {
                this.enable[i] = true;
            }
        }

        public void setParameter(int param, boolean value) {
            this.enable[param] = value;
        }

        public void updateSum() {
            for (int i = 0; i < this.T; ++i) {
                this.sum[i] = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    if (!this.enable[j]) continue;
                    int n = i;
                    this.sum[n] = this.sum[n] + this.weights[j][i];
                }
            }
        }

        public ArrayList<Integer> getDominatedTimeSteps() {
            return this.timeSteps;
        }

        public double calcTimeCover(ArrayList<Integer> list) {
            int[] paramList = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                paramList[i] = list.get(i);
            }
            return this.calcTimeCover(paramList);
        }

        public double calcTimeCover(int[] paramList) {
            this.updateSum();
            this.timeSteps.clear();
            int counter = 0;
            double[] result = new double[this.T];
            for (int i = 0; i < this.T; ++i) {
                result[i] = 0.0;
                for (int j = 0; j < paramList.length; ++j) {
                    int n = i;
                    result[n] = result[n] + this.weights[paramList[j]][i];
                }
                if (this.sum[i] == 0.0 || !(result[i] / this.sum[i] > 0.8)) continue;
                this.timeSteps.add(i);
                ++counter;
            }
            return (double)counter / (double)this.T;
        }
    }

    public static class Slope
    implements Comparable {
        int index;
        double value;

        public Slope(int index, double value) {
            this.index = index;
            this.value = value;
        }

        public int compareTo(Object obj) {
            if (obj instanceof Slope) {
                Slope p2 = (Slope)obj;
                if (this.value < p2.value) {
                    return 1;
                }
                if (this.value > p2.value) {
                    return -1;
                }
                if (this.index < p2.index) {
                    return 1;
                }
                if (this.index > p2.index) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }

    private static class Coordinate {
        double x;
        double y;

        public Coordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

