/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.calculations;

import java.util.ArrayList;
import java.util.TreeSet;
import optas.data.TimeSerie;
import optas.hydro.calculations.HydrographSection;

public class RecessionCurve
extends HydrographSection
implements Comparable {
    public RecessionCurve(int startIndex, double value) {
        super(startIndex, value);
    }

    private double getAmount() {
        return (Double)this.value.get(0) - (Double)this.value.get(this.endIndex - this.startIndex - 1);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof RecessionCurve)) {
            return 0;
        }
        RecessionCurve r = (RecessionCurve)obj;
        if (r.getIntervalLength() < this.getIntervalLength()) {
            return -1;
        }
        if (r.getIntervalLength() > this.getIntervalLength()) {
            return 1;
        }
        if (r.getAmount() < this.getAmount()) {
            return -1;
        }
        if (r.getAmount() < this.getAmount()) {
            return 1;
        }
        if (r.startIndex < this.startIndex) {
            return -1;
        }
        if (r.startIndex < this.startIndex) {
            return 1;
        }
        return 0;
    }

    public static ArrayList<RecessionCurve> findRecessionCurves(TimeSerie hydrograph) {
        TreeSet<RecessionCurve> curveList = new TreeSet<RecessionCurve>();
        long n = hydrograph.getTimeDomain().getNumberOfTimesteps();
        double[] filterResponse = new double[(int)n];
        int windowSize = 5;
        double[] weights = new double[]{0.15, 0.15, 0.4, 0.15, 0.15};
        int i = 2;
        while ((long)i < n - 2L) {
            int counter = 0;
            for (int j = -(windowSize - 1) / 2; j < windowSize / 2; ++j) {
                int n2 = i;
                filterResponse[n2] = filterResponse[n2] + weights[counter] * hydrograph.getValue(i + j);
                ++counter;
            }
            ++i;
        }
        i = 2;
        while ((long)i < n - 2L) {
            double v1;
            double v2;
            if (!((v2 = filterResponse[++i]) <= (v1 = filterResponse[i]))) continue;
            RecessionCurve r = new RecessionCurve(i - 1, hydrograph.getValue(i - 1));
            r.add(hydrograph.getValue(i));
            double v3 = filterResponse[++i];
            while (v3 <= v2 && (long)i < n - 1L) {
                r.add(hydrograph.getValue(i));
                v2 = v3;
                v3 = filterResponse[++i];
            }
            curveList.add(r);
        }
        return new ArrayList<RecessionCurve>(curveList);
    }
}

