/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import optas.hydro.Identifiable;
import optas.hydro.ObjectPool;
import optas.hydro.OptimizationScheme;
import optas.hydro.ParameterGroup;

public class OptimalOptimizationScheme
extends OptimizationScheme {
    ObjectPool<IdentifiableHashSet<ParameterGroup>> spgPool = null;
    ObjectPool<ParameterGroup> pgPool = null;

    @Override
    public String toString() {
        return "Optimal";
    }

    private void initObjectPools() {
        Identifiable[] poolData = new IdentifiableHashSet[100000];
        for (int i = 0; i < poolData.length; ++i) {
            poolData[i] = new IdentifiableHashSet();
        }
        this.spgPool = new ObjectPool(poolData);
        Identifiable[] pgPoolData = new ParameterGroup[2000000];
        for (int i = 0; i < pgPoolData.length; ++i) {
            pgPoolData[i] = new ParameterGroup(this.parameter, this.weights.length);
        }
        this.pgPool = new ObjectPool(pgPoolData);
    }

    public IdentifiableHashSet<ParameterGroup> findSolutions(ParameterGroup availableParameters, double threshold, double oldUnusableSum, int size) {
        IdentifiableHashSet<ParameterGroup> allSolutions = this.spgPool.allocate();
        allSolutions.clear();
        if (size == 0) {
            if (threshold <= 0.0) {
                allSolutions.add(availableParameters.createEmptyGroup(this.pgPool.allocate()));
            }
            return allSolutions;
        }
        double unusableSum = oldUnusableSum;
        int j = 0;
        ParameterGroup group = availableParameters.copy(this.pgPool.allocate());
        group.sortByWeight();
        while (unusableSum < 1.0 - threshold && group.size > 0) {
            int p_j = group.get(j);
            double w_j = group.weight(p_j);
            group.remove(j);
            IdentifiableHashSet<ParameterGroup> solutions = this.findSolutions(group, threshold - w_j, unusableSum + w_j, size - 1);
            for (ParameterGroup p : solutions) {
                p.add(p_j);
                allSolutions.add(p);
            }
            this.spgPool.free(solutions);
            unusableSum += w_j;
            ++j;
        }
        this.pgPool.free(group);
        return allSolutions;
    }

    public ParameterGroup calculateOptimalGroup(ParameterGroup availableParameters, double[][] weight) {
        HashMap<ParameterGroup, IntWrapper> countList = new HashMap<ParameterGroup, IntWrapper>();
        int k = 1;
        while (true) {
            int j;
            double[] rank = new double[this.n];
            for (int t = 0; t < this.T; ++t) {
                for (j = 0; j < this.n; ++j) {
                    int n = j;
                    rank[n] = rank[n] + weight[j][t];
                }
            }
            ParameterGroup reducedGroup = availableParameters.copy();
            for (j = 0; j < this.n; ++j) {
                if (availableParameters.getMap(j)) continue;
                rank[j] = Double.POSITIVE_INFINITY;
            }
            while (reducedGroup.size > 25) {
                double min = Double.MAX_VALUE;
                int argMin = 0;
                for (int i = 0; i < this.n; ++i) {
                    if (!(rank[i] < min)) continue;
                    min = rank[i];
                    argMin = i;
                }
                rank[argMin] = Double.POSITIVE_INFINITY;
                reducedGroup.remove(reducedGroup.getIndex(argMin));
            }
            for (int t = 0; t < this.T; ++t) {
                reducedGroup.w = new double[this.n];
                for (int j2 = 0; j2 < this.n; ++j2) {
                    reducedGroup.w[j2] = weight[j2][t];
                }
                reducedGroup.w = reducedGroup.normalizeWeight();
                IdentifiableHashSet<ParameterGroup> solutions = this.findSolutions(reducedGroup, this.threshold, 0.0, k);
                for (ParameterGroup p : solutions) {
                    IntWrapper c = (IntWrapper)countList.get(p);
                    if (c == null) {
                        countList.put(p, new IntWrapper(1));
                    } else {
                        IntWrapper intWrapper = c;
                        Iterator iterator = intWrapper.c;
                        Integer n = intWrapper.c = Integer.valueOf(intWrapper.c + 1);
                        this.pgPool.free(p);
                    }
                    if (!(this.pgPool.load() > 0.75)) continue;
                    ArrayList<ParameterGroup> removeList = new ArrayList<ParameterGroup>();
                    for (ParameterGroup key : countList.keySet()) {
                        IntWrapper value = (IntWrapper)countList.get(key);
                        if (!((double)value.c.intValue() < 0.01 * (double)t)) continue;
                        removeList.add(key);
                    }
                    for (ParameterGroup key : removeList) {
                        countList.remove(key);
                        this.pgPool.free(key);
                    }
                }
                this.spgPool.free(solutions);
            }
            if (countList.size() > 0) {
                int max = 0;
                ParameterGroup argMax = null;
                for (ParameterGroup p : countList.keySet()) {
                    IntWrapper value = (IntWrapper)countList.get(p);
                    if (value.c <= max) continue;
                    max = value.c;
                    argMax = p;
                }
                if ((double)max / (double)this.T > 0.1) {
                    return argMax.copy();
                }
            }
            this.pgPool.reset();
            countList.clear();
            ++k;
        }
    }

    public void calcOptimizationScheme() {
        this.initObjectPools();
        this.solutionGroups.clear();
        this.dominatedTimeStepsForGroup.clear();
        ParameterGroup allParameters = new ParameterGroup(this.parameter, this.n);
        while (allParameters.size > 0) {
            ParameterGroup p = this.calculateOptimalGroup(allParameters, this.weights);
            this.solutionGroups.add(p);
            this.update();
            allParameters.sub(p);
        }
    }

    public static class IntWrapper {
        Integer c;

        IntWrapper(int v) {
            this.c = new Integer(v);
        }
    }

    public static class IdentifiableHashSet<T>
    extends HashSet<T>
    implements Identifiable {
        static int counter = 0;
        int id = counter++;

        IdentifiableHashSet() {
        }

        @Override
        public int getID() {
            return this.id;
        }
    }
}

